/*************************************************************************
* Rutoken                                                                *
* Copyright (c) 2003-2017, CJSC Aktiv-Soft. All rights reserved.         *
* Подробная информация:  http://www.rutoken.ru                           *
*------------------------------------------------------------------------*
* Данный пример демонстрирует удаление ключевой пары на токене с помощью *
* pkicore. Для успешного выполнения программы на токене должен           *
* находиться по крайне мере один секретный ключ. В результате            *
* выполнения будет удалена первая найденная ключевая пара.               *
*************************************************************************/

#include <common.h>

using namespace std;
using namespace rutoken::pkicore;

int main()
{
	try {
		cout << boolalpha;

		/**********************************************************************
		* Инициализируем pkicore, передав путь до директории с библиотекой    *
		* rtPKCS11ECP.                                                        *
		**********************************************************************/
		rutoken::pkicore::initialize(".");
		SCOPE_EXIT() {
			/**********************************************************************
			* Завершаем работу с pkicore при выходе из текущего блока.            *
			**********************************************************************/
			rutoken::pkicore::deinitialize();
		};

		/**********************************************************************
		* Получаем список подключенных устройств и продолжаем работу с первым *
		* доступным устройством.                                              *
		**********************************************************************/
		auto devices = Pkcs11Device::enumerate();
		if (devices.empty()) {
			throw runtime_error("There must be at least one device connected");
		}

		auto device = move(devices.front());

		/**********************************************************************
		* Аутентифицируемся на устройстве.                                    *
		**********************************************************************/
		device.login("12345678");
		SCOPE_EXIT(&device) {
			/**********************************************************************
			* Сбрасываем права доступа при выходе из текущего блока.              *
			**********************************************************************/
			device.logout();
		};

		/**********************************************************************
		* Получаем список ключей на устройстве и продолжаем работу с первым   *
		* найденным                                                           *
		**********************************************************************/
		auto keys = device.enumeratePrivateKeys();
		if (keys.empty()) {
			throw runtime_error("There must be at least one key on device");
		}

		auto key = move(keys.front());

		/**********************************************************************
		* Удаляем ключевую пару.                                              *
		**********************************************************************/
		cout << "Deleting key " << toHex(key.getId()) << endl;

		device.deleteKeyPair(key);
	} catch (const exception& e) {
		cerr << e.what() << endl;
		return 1;
	}

	return 0;
}
