/*************************************************************************
* Rutoken                                                                *
* Copyright (c) 2003-2017, CJSC Aktiv-Soft. All rights reserved.         *
* Подробная информация:  http://www.rutoken.ru                           *
*------------------------------------------------------------------------*
* Данный пример демонстрирует работу с токенами с помощью pkicore. Во    *
* время выполнения программы в консоль выводится информация о найденных  *
* устройствах.                                                           *
*************************************************************************/

#include <common.h>

using namespace std;
using namespace rutoken::pkicore;

int main()
{
	try {
		cout << boolalpha;

		/**********************************************************************
		* Инициализируем pkicore, передав путь до директории с библиотекой    *
		* rtPKCS11ECP.                                                        *
		**********************************************************************/
		rutoken::pkicore::initialize(".");
		SCOPE_EXIT() {
			/**********************************************************************
			* Завершаем работу с pkicore при выходе из текущего блока.            *
			**********************************************************************/
			rutoken::pkicore::deinitialize();
		};

		/**********************************************************************
		* Получаем список подключенных устройств.                             *
		**********************************************************************/
		auto devices = Pkcs11Device::enumerate();
		cout << devices.size() << " devices have been found\n" << endl;

		/**********************************************************************
		* Выводим информацию о найденых устройствах.                          *
		**********************************************************************/
		for (auto it = devices.begin(); it != devices.end(); ++it) {
			auto& d = *it;

			/**********************************************************************
			* Выводим серийный номер устройства.                                  *
			**********************************************************************/
			cout << "Device " << d.getSerialNumber() << '\n';

			/**********************************************************************
			* Выводим метку устройства.                                           *
			**********************************************************************/
			cout << "\tlabel: " << d.getLabel() << '\n';

			/**********************************************************************
			* Выводим информацию о функциональности устройства.                   *
			**********************************************************************/
			cout << "\tfeatures supported: \n";

			/**********************************************************************
			* Поддержка журнала операций.                                         *
			**********************************************************************/
			cout << "\t\tjournal: " << d.isFeatureSupported(Pkcs11Device::Feature::journal) << '\n';

			/**********************************************************************
			* Поддержка PIN2.                                                     *
			**********************************************************************/
			cout << "\t\tPIN2: " << d.isFeatureSupported(Pkcs11Device::Feature::pin2) << '\n';

			/**********************************************************************
			* Поддержка отображения на устройстве.                                *
			**********************************************************************/
			cout << "\t\tvisualization: " << d.isFeatureSupported(Pkcs11Device::Feature::visualization)
			     << '\n';

			/**********************************************************************
			* Выводим информацию о поддерживаемых форматах данных.                *
			**********************************************************************/
			cout << "\tformats supported: \n"
			     << "\t\tplain: " << d.isFormatSupported(Pkcs11Device::Format::plain) << '\n'
			     << "\t\traw: " << d.isFormatSupported(Pkcs11Device::Format::raw) << '\n'
			     << "\t\tpinpad2: " << d.isFormatSupported(Pkcs11Device::Format::pinpad2) << '\n'
			     << "\t\txml: " << d.isFormatSupported(Pkcs11Device::Format::xml) << '\n'
			     << "\t\tsafetouch: " << d.isFormatSupported(Pkcs11Device::Format::safetouch) << '\n';

			cout << endl;
		}
	} catch (const exception& e) {
		cerr << e.what() << endl;
		return 1;
	}

	return 0;
}
