/*************************************************************************
* Rutoken                                                                *
* Copyright (c) 2003-2017, CJSC Aktiv-Soft. All rights reserved.         *
* Подробная информация:  http://www.rutoken.ru                           *
*------------------------------------------------------------------------*
* Данный пример демонстрирует импорт сертификата на токен с помощью      *
* pkicore. Сертификат в формате PEM содержится в переменной cert.        *
*************************************************************************/

#include <common.h>

using namespace std;
using namespace rutoken::pkicore;

const string cert =
    "-----BEGIN CERTIFICATE-----\n"
    "MIICVTCCAgKgAwIBAgIJANLSFmtYZcxVMAoGBiqFAwICAwUAMH8xIzAhBgkqhkiG\n"
    "9w0BCQEWFHN1cHBvcnRAY3J5cHRvcHJvLnJ1MQswCQYDVQQGEwJSVTEPMA0GA1UE\n"
    "BwwGTW9zY293MRcwFQYDVQQKDA5DUllQVE8tUFJPIExMQzEhMB8GA1UEAwwYQ1JZ\n"
    "UFRPLVBSTyBUZXN0IENlbnRlciAyMB4XDTE1MDYxNjEyMzEzOVoXDTQ1MDYxNjEy\n"
    "MzEzOVowfzEjMCEGCSqGSIb3DQEJARYUc3VwcG9ydEBjcnlwdG9wcm8ucnUxCzAJ\n"
    "BgNVBAYTAlJVMQ8wDQYDVQQHDAZNb3Njb3cxFzAVBgNVBAoMDkNSWVBUTy1QUk8g\n"
    "TExDMSEwHwYDVQQDDBhDUllQVE8tUFJPIFRlc3QgQ2VudGVyIDIwYzAcBgYqhQMC\n"
    "AhMwEgYHKoUDAgIjAQYHKoUDAgIeAQNDAARAbggW5TS1tZ1DxKWXlf6xN6qiDVsa\n"
    "DtG8KOAlpIjYJEMDU9kVzOxG2WXJjzOjVFY/R+fWBJE1h//r+FUESoBtwqNdMFsw\n"
    "HQYDVR0OBBYEFJPFQPepgPzra0S4FHmkKmOSQ5AcMB8GA1UdIwQYMBaAFJPFQPep\n"
    "gPzra0S4FHmkKmOSQ5AcMAwGA1UdEwQFMAMBAf8wCwYDVR0PBAQDAgGGMAoGBiqF\n"
    "AwICAwUAA0EAGDlLalWCr4CPKOqqa2FmtDdmTRKmh1WT6tgZODoXRl7NCLT+yGeZ\n"
    "BlfPFaqwd+mCj3e0MGphfsirJ7gQEW8slg==\n"
    "-----END CERTIFICATE-----\n";

int main()
{
	try {
		cout << boolalpha;

		/**********************************************************************
		* Инициализируем pkicore, передав путь до директории с библиотекой    *
		* rtPKCS11ECP.                                                        *
		**********************************************************************/
		rutoken::pkicore::initialize(".");
		SCOPE_EXIT() {
			/**********************************************************************
			* Завершаем работу с pkicore при выходе из текущего блока.            *
			**********************************************************************/
			rutoken::pkicore::deinitialize();
		};

		/**********************************************************************
		* Получаем список подключенных устройств и продолжаем работу с первым *
		* доступным устройством.                                              *
		**********************************************************************/
		auto devices = Pkcs11Device::enumerate();
		if (devices.empty()) {
			throw runtime_error("There must be at least one device connected");
		}

		auto device = move(devices.front());

		/**********************************************************************
		* Аутентифицируемся на устройстве.                                    *
		**********************************************************************/
		device.login("12345678");
		SCOPE_EXIT(&device) {
			/**********************************************************************
			* Сбрасываем права доступа при выходе из текущего блока.              *
			**********************************************************************/
			device.logout();
		};

		/**********************************************************************
		* Импортируем сертификат на токен. Сертификат будет импортирован как  *
		* доверенный, если указать trusted = true.                            *
		**********************************************************************/
		device.importCert(ExternalCert(cert), false);
	} catch (const exception& e) {
		cerr << e.what() << endl;
		return 1;
	}

	return 0;
}
