# Комплект разработчика Рутокен SDK

Комплект разработчика Рутокен SDK предназначен для распространения бинарных компонентов, представляющих интерфейс для взаимодействия с устройствами Рутокен в программах, написанных на языках C, C++, C#, Java, Kotlin, Objective-C, Swift,
исходного кода примеров использования этих интерфейсов и диагностических утилит.

Содержимое архива Рутокен SDK распределено по директориям, соответствующим интерфейсу взаимодействия с устройствами Рутокен: CryptoAPI, PKCS#11, pkicore, OpenSSL ENGINE API. Компоненты, обеспечивающие и демонстрирующие взаимодействие с устройствами Рутокен из программ, написанных на языке Java, размещены в одноименной директории. Все компоненты, относящиеся к разработке мобильных приложений для iOS и Android, размещены в директории mobile. Программы-утилиты помещены в директорию util.

## Содержание архива
* `CryptoAPI/`
    * `Cert2Cont/` -- Исходный код утилиты Cert2Cont, предназначенной для импорта DER-сертификата в соответствующий ему контейнер через интерфейс CryptoAPI
    * `CryptoProCSP/` -- Примеры работы с устройствами Рутокен через CryptoAPI с использованием криптопровайдера КриптоПро CSP
    * `RutokenCSP/` -- Примеры работы с устройствами Рутокен через CryptoAPI с использованием Aktiv Rutoken CSP
* `cryptoplugin/` -- Рутокен Плагин, предназначенный для взаимодействия с устройствами Рутокен из браузера
* `csharp/`
    * `pkcs11/` -- Ссылки на репозитории с исходным кодом компонентов, обеспечивающих взаимодействие с устройствами Рутокен программных продуктов, разработанных на C#, и примерами программ, использующих эти компоненты
* `java/`
    * `doc/` -- Документация
    * `samples/` -- Примеры программ на языке Java, взаимодействующих с устройствами Рутокен через интерфейсы PKCS#11, JCA и BouncyCastle
* `mobile/`
    * `android/`
        * `Android_README.md` -- Описание способов встраивания устройств Рутокен в клиентские приложения, в том числе без установки сервиса поддержки Рутокен
        * `libs/`
            * `rtserviceconnection*.aar` -- Библиотека для подключения к сервису поддержки Рутокен в Android из клиентского приложения
        * `pcsc/`
            * `librtpcsc.so` -- Библиотека, реализующая интерфейс PCSC для устройств Рутокен в Android
            * `rtpcsc*.aar` -- Библиотека для подключения к сервису поддержки Рутокен в Android из клиентского приложения. Содержит librtpcsc.so
        * `pkcs11/` -- Компоненты, обеспечивающие взаимодействие с устройствами Рутокен в Android через интерфейс PKCS#11, и примеры программ, использующих данные компоненты
        * `service/` -- Сервис поддержки Рутокен в Android. В случае использования схемы встраивания с помощью приложения "Панель управления Рутокен" установка сервиса является необходимым условием корректной работы программ, взаимодействующих с устройствами Рутокен в Android
    * `ios/`
        * `pcsc/` -- Библиотека, реализующая интерфейс PCSC для устройств Рутокен в iOS
        * `pkcs11/` -- Компоненты, обеспечивающие взаимодействие с устройствами Рутокен в iOS через интерфейс PKCS#11, и примеры программ, использующих данные компоненты
* `openssl/`
    Компания "Актив" не является разработчиком или поставщиком OpenSSL, поставляемые в комплекте разработчика библиотеки и исполняемые файлы предоставляются для удобства сборки и запуска примеров для rtengine и OpenSSL Tool

    Примеры использования устройств Рутокен через OpenSSL при помощи библиотеки-расширения rtengine. Более подробное описание содержится в README.md в соответствующей директории.
    * `bin/` -- Динамические библиотеки OpenSSL и rtengine в бинарном виде, а также утилита для командной строки - OpenSSL tool
    * `doc/` -- Документация библиотеки rtengine
    * `samples/` -- Примеры работы с rtengine через OpenSSL API и OpenSSL tool
* `pkcs11/`
    * `doc/` -- Оригинал стандарта PKCS#11
    * `include/` -- Заголовочные файлы библиотеки rtPKCS11ECP, реализующей интерфейс PKCS#11 для устройств Рутокен
    * `lib/` -- Бинарные компоненты -- библиотека rtPKCS11ECP для использования на различных платформах
    * `samples/` -- Кроссплатформенные примеры работы с устройствами Рутокен с использованием библиотеки PKCS#11 на языке C

        Внимание! Для работы примеров с Рутокен S необходимо установить драйверы, в составе которых будет присутствовать необходимая библиотека `rtPKCS11.dll`.

        Примеры разделены на следующие группы (по именам директорий):
        * `Standard/` -- примеры работы с функциями стандарта PKCS#11
        * `Extended/` -- примеры работы с функциями расширения стандарта PKCS#11
        * `PKIExtensions/` -- примеры работы с функциями расширения стандарта PKCS#11 для использования в PKI
    * `util/` -- Утилиты для диагностики взаимодействия программ с устройствами Рутокен через интерфейс PKCS#11:
        * `pkcs11-spy` -- утилита логгирования вызовов библиотеки PKCS#11
* `pkicore/`
    * `cpp/`
        * `bin/` -- Бинарные компоненты библиотеки pkicore для использования на различных платформах
        * `doc/` -- Документация
        * `samples/` -- Кроссплатформенные примеры для работы с устройствами Рутокен с использованием библиотеки pkicore на языке C++
* `util/`
    * `rtEditor/`
        * `bin/`
            * `rtEditor.exe` -- редактор памяти Рутокен для работы с объектами файловой системы ТОЛЬКО Рутокен S (не подходит для других моделей Рутокен!)
    * `pam/`
        * `lib/` -- Подключаемые модули аутентификации при помощи устройств Рутокен
* `Rutoken documentation` -- Ссылка на Портал документации Рутокен
* `License_Agreement.pdf` -- Лицензионное соглашение на использование программных продуктов и/или онлайн-сервисов Рутокен (Rutoken)

## Сборка C/C++ примеров

Проекты CryptoApi, pkcs11, openssl и pkicore используют CMake в качестве системы сборки своих примеров. Загрузить свежую версию можно с [официального сайта](https://cmake.org/download/). Требуется версия CMake 3.5 и выше.

`project_dir` - директория, содержащая CMakeLists.txt для интересующего вас проекта. Например, `openssl/samples`, `pkcs11/samples` и т.д.

### Сборка примеров с использованием CMake
* Версия cmake до 3.13
```sh
$ cd $project_dir && mkdir build && cd build && cmake .. && cmake --build .
```
* Версия cmake 3.13 и выше
```sh
$ cd $project_dir && cmake -B build -S . && cmake --build build -j
```

Собранные примеры кладутся в директорию out рядом с CMakeLists.txt файлом.

Для Windows возможно использование Visual Studio после первого вызова cmake. Открыть ее можно с помощью `.sln` файла в папке `build`, или вызвав `cmake --open build` (CMake 3.13+).

Некоторые IDE, например, Qt Creator и CLion, имеют встроенную поддержку CMake. В такой ситуации сборка и запуск примеров возможны путем открытия файла `CMakeLists.txt` непосредственно в Вашей среде разработки. Узнать, умеет ли Ваша среда разработки собирать CMake проекты, можно из ее документации.

### Продвинутое использование
#### Задание генератора
По умолчанию в Windows при первом вызове CMake генерируется sln для последней установленной Visual Studio. На остальных ОС по умолчанию генерируется Makefile. Можно использовать другой генератор, например, не последнюю версию Visual Studio для Windows или Xcode для macOS. Для этого при первом вызове CMake можно передать параметр `-G <generator name>`. Список  поддерживаемых генераторов доступен на [сайте документации](https://cmake.org/cmake/help/v3.5/manual/cmake-generators.7.html) (выберите Вашу версию CMake) или по `cmake --help`.

#### Задание архитектуры сборки
По умолчанию примеры собираются под архитектуру, собираемую по умолчанию Вашим компилятором. Для того, чтобы выбрать для сборки другую архитектуру, необходимо при первом запуске CMake передать дополнительные параметры, зависящие от генератора и ОС.
- Visual Studio / Windows: архитектура сборки задается путем передачи параметра `-A $arch`.
  Возможные значения `$arch`:
  - x64;
  - Win32.
- macOS: архитектура задается путем передачи `-DCMAKE_OSX_ARCHITECTURES=$arch`.
  Возможные значения `$arch`:
  - x86_64;
  - arm64 (доступно не для всех примеров и версий Xcode);
  - "x86_64;arm64" (доступно не для всех примеров и версий Xcode).
- Makefile/Linux: изменение архитектуры не рекомендуется.
  Вы можете задать использование другого компилятора с помощью `-DCMAKE_C_COMPILER`/`-DCMAKE_CXX_COMPILER` или передать параметры, специфичные для Вашего компилятора, через `-DCMAKE_C_FLAGS`/`-DCMAKE_CXX_FLAGS`. Если планируется компиляция под другую ОС (например, Linux -> FreeBSD), то требуется ее передача через `-DCMAKE_SYSTEM_NAME`.

  Примеры:
  - сборка x86 примеров на Linux x64 с установленным GNU Multilib: `-DCMAKE_C_FLAGS=-m32 -DCMAKE_CXX_FLAGS=-m32`;
  - сборка FreeBSD кросс-компилятором на Linux x64: `-DCMAKE_SYSTEM_NAME=FreeBSD -DCMAKE_C_COMPILER=/path/to/c/compiler -DCMAKE_CXX_COMPILER=/path/to/c++/compiler`

#### Переключение Debug/Release
По умолчанию собирается `Debug` версия примеров. Указать другой тип сборки можно через интерфейс Вашей IDE, а при сборке из консоли, через переменную `CMAKE_BUILD_TYPE` или флаг сборки --config:
* Версия cmake до 3.13
```sh
$ cmake -DCMAKE_BUILD_TYPE=Debug .. && cmake --config Debug --build .
```
* Версия cmake 3.13 и выше
```sh
$ cmake -DCMAKE_BUILD_TYPE=Debug -B build -S . && cmake --build build --config Debug
```

#### Выбор target для сборки
По умолчанию собираются все имеющиеся примеры. Для сборки части примеров можно использовать параметр --target. Например, так можно собрать примеры на стандартный интерфейс PKCS11:
* Версия cmake до 3.13
```sh
$ cd build && cmake .. && cmake --build . --target Standard
```
* Версия cmake 3.13 и выше
```sh
$ cmake -B build -S . && cmake --build build --target Standard
```

Если сборка производится с использованием Makefile, при помощи `cmake --build build --target help` можно увидеть все доступные target, но вывод команды содержит большое количество вспомогательных целей и сложен в использовании. В противном случае, собрать желаемый пример отдельно можно с помощью Visual Studio (Windows) или Xcode (macOS).

## Лицензионные обязательства
Бинарные компоненты, содержащиеся в данном архиве, распространяются по коммерческой лицензии АО "Актив-Софт" (см. `License_Agreement.pdf`), если противное не указано в файле `README` с описанием бинарного компонента.

Программный код, содержащийся в данном архиве, распространяется по свободной лицензии MIT (см. `LICENSE_FOR_SAMPLES`), если противное не указано в файле с исходным кодом.

(с) Rutoken, 2022
