/*************************************************************************
* Rutoken                                                                *
* Copyright (c) 2003-2025, Aktiv-Soft JSC. All rights reserved.          *
* Подробная информация:  http://www.rutoken.ru                           *
*************************************************************************/

/*************************************************************************
 * Данный пример удаляет ключевую пару ГОСТ 34.10-2012 (256 бит) с        *
 * Рутокен, созданную в примере HardwareTokenPreparation                  *
 *************************************************************************/
#include <assert.h>

#include <Common.h>

int main(void) {
    CK_UTF8CHAR userPin[] = { "12345678" };    // PIN-код пользователя Рутокен
    CK_ULONG userPinLen = sizeof(userPin) - 1; // Длина PIN-кода пользователя Рутокен
    CK_OBJECT_CLASS objectClass;               // Описатель типа объекта
    CK_OBJECT_HANDLE privateKeyHandle;         // Описатель закрытого ключа
    CK_OBJECT_HANDLE publicKeyHandle;          // Описатель открытого ключа
    CK_RV rv;                                  // Код возврата
    int errorCode = 1;                         // Флаг ошибки
    CK_ATTRIBUTE findObjectTemplate[2];        // Шаблон поиска ключей

    printf("    initializeToken...\n");
    g_session = initializeToken(&g_functionList, &g_pkcsModule);
    CHECK("    initializeToken", g_session != CK_INVALID_HANDLE, exit);

    /************************************************************************
     * Задание шаблона поиска открытого ключа                               *
     * Для использования ECDSA ключа необходимо заменить                    *
     * g_keyPairIdGost2012RtEngine на g_keyPairIdEcdsaRtEngine              *
     * ---------------------------------------------------------------------*
     * Для использования RSA ключа необходимо заменить                      *
     * g_keyPairIdGost2012RtEngine на g_keyPairIdRsaRtEngine                *
     ************************************************************************/
    objectClass = CKO_PUBLIC_KEY;
    findObjectTemplate[0].type = CKA_CLASS;
    findObjectTemplate[0].pValue = &objectClass;
    findObjectTemplate[0].ulValueLen = sizeof(objectClass);
    findObjectTemplate[1].type = CKA_ID;
    findObjectTemplate[1].pValue = &g_keyPairIdGost2012RtEngine;
    findObjectTemplate[1].ulValueLen = sizeof(g_keyPairIdGost2012RtEngine) - 1;

    printf("    getObjectFromToken...\n");
    publicKeyHandle = getObjectFromToken(g_functionList, g_session, findObjectTemplate,
                                         sizeof(findObjectTemplate) / sizeof(findObjectTemplate[0]));
    CHECK("    getObjectFromToken", publicKeyHandle != CK_INVALID_HANDLE, finalize_token);

    /*************************************************************************
     * Аутентификация пользователя                                            *
     *************************************************************************/
    rv = g_functionList->C_Login(g_session, CKU_USER, userPin, userPinLen);
    CHECK("      C_Login", rv == CKR_OK, finalize_token);

    /*************************************************************************
     * Задание шаблона поиска закрытого ключа                                 *
     *************************************************************************/
    objectClass = CKO_PRIVATE_KEY;

    printf("    getObjectFromToken...\n");
    privateKeyHandle = getObjectFromToken(g_functionList, g_session, findObjectTemplate,
                                          sizeof(findObjectTemplate) / sizeof(findObjectTemplate[0]));
    CHECK("    getObjectFromToken", privateKeyHandle != CK_INVALID_HANDLE, logout);

    /*************************************************************************
     * Удаление закрытого ключа с Рутокен                                     *
     *************************************************************************/
    rv = g_functionList->C_DestroyObject(g_session, privateKeyHandle);
    CHECK_RELEASE("  C_DestroyObject(private key)", rv == CKR_OK, errorCode);

    /*************************************************************************
     * Удаление открытого ключа с Рутокен                                     *
     *************************************************************************/
    rv = g_functionList->C_DestroyObject(g_session, publicKeyHandle);
    CHECK_RELEASE("  C_DestroyObject(public key)", rv == CKR_OK, errorCode);

    /*************************************************************************
     * Установка признака успешного завершения программы                      *
     *************************************************************************/
    errorCode = 0;

    /*************************************************************************
     * Сброс прав доступа                                                     *
     *************************************************************************/
logout:
    rv = g_functionList->C_Logout(g_session);
    CHECK("    C_Logout", rv == CKR_OK, finalize_token);

finalize_token:
    finalizeToken();
exit:
    if (errorCode) {
        printf("\n\nSample has failed. Some error has occurred.\n");
    } else {
        printf("\n\nSample has been completed successfully.\n");
    }
    return errorCode;
}