/*************************************************************************
* Rutoken                                                                *
* Copyright (c) 2003-2025, Aktiv-Soft JSC. All rights reserved.          *
* Подробная информация:  http://www.rutoken.ru                           *
*************************************************************************/

#pragma once

#include <dlfcn.h>

typedef void* HMODULE;
typedef int BOOL;

static HMODULE LoadLibrary(const char* path) {
    return dlopen(path, RTLD_NOW);
}

static BOOL FreeLibrary(HMODULE module) {
    return !dlclose(module);
}

static ptrdiff_t GetProcAddress(HMODULE module, const char* proc_name) {
    return (ptrdiff_t)(dlsym(module, proc_name));
}