# Использование rtengine через инструменты командной строки OpenSSL

## Настройка
Чтобы openssl динамически загружал rtengine, создайте файл конфигурации `openssl.cnf` или добавьте в уже имеющийся следующие строки:
```ini
openssl_conf = openssl_def

[ openssl_def ]
    engines = engine_section

[ engine_section ]
    rtengine = gost_section

[ gost_section ]
    dynamic_path = /path/to/librtengine.so
```

`dynamic_path` - путь до библиотеки rtengine.

В переменную среды `OPENSSL_CONF` запишите путь до кофигурационного файла.

Например, для bash выполните:
```bash
export OPENSSL_CONF=/path/to/openssl.cnf
```
Для windows cmd:
```bat
set OPENSSL_CONF=C:\path\to\openssl.cnf
```
Для windows powershell:
```powershell
$env:OPENSSL_CONF="C:\path\to\openssl.cnf"
```

Для формирования псевдослучайной последовательности на токене установите значения для `pkcs11_path` и `rand_token`, а также выставите `enable_rand = yes` в `openssl.cnf` в секции `[ gost_section ]`:
```
[ gost_section ]
    dynamic_path = /path/to/librtengine.so
    enable_rand = yes
    pkcs11_path = /path/to/librtpkcs11ecp.so
    rand_token = pkcs11:manufacturer=Aktiv%20Co.;model=Rutoken%20ECP;serial=2adc8d87
    default_algorithms = ALL
```

* `enable_rand` - использование формирования псевдослучайной последовательности на токене.
* `pkcs11_path` - путь до библиотеки rtpkcs11ecp.
* `rand_token` - идентификатор токена согласно rfc7512 ([pkcs11 uri](https://tools.ietf.org/html/rfc7512)).
    Возможные компоненты идентификатора:
    * `manufacturer`: ID производителя токена;
    * `model`: модель токена;
    * `serial`: серийный номер токена;
    * `token`: метка токена (поле "label").
* `default_algorithms` - устанавливает указанные виды алгоритмов, реализуемых в rtengine, в качестве реализаций по умолчанию. Требуется для корректной работы версии rtengine для OpenSSL 3.

Возможно использование любого сочетания этих компонент, будет использован первый найденный токен, удовлетворяющий критериям поиска.

Изменение порядка строк в секции `[ gost_section ]` в приведенном файле конфигурации может привести к неработоспособности библиотеки.

После успешной настройки все операции по формированию псевдослучайной последовательности будут производится на указанном токене. Пример выработки псевдослучайной последовательности:
```bash
openssl rand -engine rtengine -out rand_file 20
```

## Использование ключей на токене
rtengine позволяет использовать ключи, расположенные на токене. Ключевая пара идентифицируется с помощью описанного выше pkcs11 uri. К уже описанным компонентам идентификатора добавляются:
* `object`: имя объекта (`CKA_LABEL`)
* `id`: идентификатор объекта (`CKA_ID`)

Пример идентификатора ключевой пары на токене:
```
pkcs11:manufacturer=Aktiv%20Co.;model=Rutoken%20ECP;serial=2adc8d87;object=my%20label;id=%aa%bb%cc%dd
```

В зависимости от операции будет выбран открытый или закрытый ключ соответственно. Вследствие этого оба ключа пары должны иметь одинаковый идентификатор объекта и/или имя объекта.

При необходимости, ПИН-код будет запрошен после начала выполнения команды. Для передачи ПИН-кода в неинтерактивном режиме можно использовать параметр `-passin`. Он может не поддерживаться в каких-то командах инструментов командной строки, вариант передачи через идентификатор предпочтителен.

Пример передачи стандартного пинкода пользователя:
```
pass:12345678
```

ПИН-код может быть передан в URI ключа в открытом виде через атрибут `pin-value` или прочитан из файла, путь до которого указан в атрибуте `pin-source`. Обратите внимание, согласно rfc7512 атрибуты `pin-value`/`pin-source` добавляются в конец идентификатора и отделяются от остальных атрибутов символом "?".

Пример передачи ПИН-кода в URI ключа через атрибут `pin-value`:
```
pkcs11:manufacturer=Aktiv%20Co.;model=Rutoken%20ECP;serial=2adc8d87;object=my%20label;id=%aa%bb%cc%dd?pin-value=12345678
```

Пример передачи ПИН-кода в URI ключа через атрибут `pin-source`:
```
pkcs11:manufacturer=Aktiv%20Co.;model=Rutoken%20ECP;serial=38c57a4a;object=my%20label;id=%aa%bb%cc%dd?pin-source=file:/path/to/file
```

Получение пин-кода из другого приложения (`pin-source=|/path/to/application`) или какой-либо другой режим использования pin-source не поддерживается. При получении ПИН-кода из файла все содержимое файла будет считаться ПИН-кодом. Все переданное после `file`: будет считаться путем до файла (относительным или абсолютным).

Примеры реального применения находятся в соответствующих пунктах.

## Использование в командной строке
1. Генерация закрытого ключа
    * Программно:
        ```bash
        openssl genpkey -algorithm gost2012_256 -pkeyopt paramset:A -out seckey.pem
        ```
    * Аппаратная генерация не поддерживается.

    `-algorithm` -- алгоритм выработки ключа
    `-pkeyopt` -- парамсет

    Поддерживаются следующие значения алгоритмов и соответствующих им парамсетов:
    * `gost2001`: A,B,C,XA,XB
    * `gost2012_256`: A,B,C,D,id-GostR3410-2001-CryptoPro-A-ParamSet,id-GostR3410-2001-CryptoPro-B-ParamSet, id-GostR3410-2001-CryptoPro-C-ParamSet, id-GostR3410-2001-CryptoPro-XchA-ParamSet,id-GostR3410-2001-CryptoPro-XchB-ParamSet
    * `gost2012_512`: A,B,C

    A,B,C,D для `gost2012_256` означают соответствующие id-tc26-gost-3410-2012-256-paramSet\* наборы параметров.

2. Создание запроса на сертификат
    * Программно:
        ```bash
        openssl req -utf8 -new -key seckey.pem -out req.csr
        ```

    * Аппаратно:
        ```bash
        openssl req -utf8 -new -keyform engine -key "your_pkcs11_uri" -engine rtengine -out req.csr
        ```

3. Вычисление хеш-функции
    ```bash
    openssl dgst -md_gost94 test_data
    ```

    Поддерживаемые опции:
    * `-md_gost94`
    * `-md_gost12_256`
    * `-md_gost12_512`

4. Вычисление HMAC на основе алгоритмов вычисления хеш-функции ГОСТ
    ```bash
    openssl dgst -md_gost12_256 -mac hmac -macopt hexkey:<32 bytes of key as a string of hexadecimal digits> test_data
    ```

    Возможные алгоритмы совпадают с пунктом 3. Значение ключа в формате `hexkey` задается в виде шестнадцатеричной строки, где каждая пара символов `[0-9a-fA-F]` описывает очередной байт ключа. Строка не имеет какого-либо префикса. Для указания ключа в двоичном формате используйте опцию `key` вместо `hexkey`. Обратите внимание на невозможность передачи с ее помощью нулевых байтов, а также на сложности при передаче не человекочитаемого значения ключа. По возможности используйте `hexkey`, а не `key`.

5. Подпись
    * Программно:
        ```bash
        openssl dgst -sign seckey.pem -out signature test_data
        ```

    * Аппаратно:
        ```bash
        openssl dgst -keyform engine -sign "your_pkcs11_uri" -engine rtengine -out signature test_data
        ```

    Алгоритм хеша будет зависеть от алгоритма ключа.

6. Проверка подписи

    Получить открытый ключ из закрытого можно следующей командой:
    ```bash
    openssl pkey -in seckey.pem -pubout -out pubkey.pem
    ```

    * Программная проверка:
        ```bash
        openssl dgst -verify pubkey.pem -signature signature test_data
        ```

    * Аппаратная проверка:
        ```bash
        openssl dgst -keyform engine -verify "your_pkcs11_uri" -engine rtengine -signature signature test_data
        ```

7. Выработка общего секретного ключа, используя закрытый ключ отправителя и открытый ключ получателя.

    * Программно:
        ```bash
        openssl pkeyutl -derive -inkey seckey.pem -keyform PEM -peerkey pubkey.pem -peerform PEM -pkeyopt ukmhex:1234567812345678 -pkeyopt cipher:gost89 -out res.bin
        ```

    * Аппаратно:
        ```bash
        openssl pkeyutl -derive -inkey "your_pkcs11_uri_1" -keyform ENGINE -peerkey "your_pkcs11_uri_2" -peerform ENGINE -pkeyopt ukmhex:1234567812345678 -pkeyopt cipher:gost89 -out res.bin
        ```

    `ukmhex` -- значение ukm для выработки. 8 байт для выработки общего ключа 28147 (как в примере выше) или 24 байта для выработки двойного ключа Магма/Кузнечик.

    Можно передать большее количество байт, тогда будет использоваться лишь необходимое для шифра количество.

    `cipher` -- задание блочного шифра, в котором будет использоваться выработанный ключ (только для openssl 3.0).

    Поддерживаемые значения шифра:
    * `gost89` - ключ 28147 (используется по умолчанию)
    * `magma`/`magma-kexp15`, `kuznyechik`/`kuznyechik-kexp15` - для выбора схемы KEG (только для openssl 3.0)

8. CMS подпись

    Для создания CMS подписи необходимо иметь сертификат. В тестовых целях в проекте предоставлены настройки для удостоверяющего центра openssl, который позволяет выпускать сертификаты. Используя тестовый конфигурационный файл выполните из папки проекта:
    ```bash
    openssl ca -batch -in req.csr -out cert.cer
    ```

    Затем создайте CMS подпись.
    * Программно:
        ```bash
        openssl cms -sign -binary -nosmimecap -in test_data -out signed_cms -outform PEM -inkey seckey.pem -signer cert.cer
        ```

    * Аппаратно:
        ```bash
        openssl cms -sign -binary -nosmimecap -in test_data -out signed_cms -outform PEM -keyform engine -inkey "your_pkcs11_uri" -engine rtengine -signer cert.cer
        ```

    Используя `-nodetach` можно включить подписываемые данные в состав CMS пакета.  
    Используя `-nocerts` можно не включать сертификат подписанта в состав CMS пакета.

9. Проверка CMS подписи
    ```bash
    openssl cms -verify -binary -in signed_cms -inform PEM -out verified_data -CAfile demoCA/cacert.pem -content test_data
    ```

    Файл, указанный в `-CAfile`, является доверенным сертификатом удостоверяющего центра и используется для проверки сертификата подписанта. В опцию `-content` передается файл с подписанными данными, если он не был включен в состав CMS пакета. Если сертификат подписанта не был включен в CMS пакет, он указывается в опции `-certfile`.

10. CMS зашифрование
    ```bash
    openssl cms -encrypt -binary -gost28147-cfb -in test_data -out encrypted_cms -outform PEM cert.cer
    ```

    Поддерживаются следующие значения режимов и алгоритмов:
    * `gost28147-cfb` - работает в режиме гаммирования с обратной связью с набором параметров Z;
    * `kuznyechik-ctr-acpkm`, `magma-ctr-acpkm` - блочные шифры, работающие в режиме с внутренним преобразованием ключа (только для openssl 3.0);
    * `kuznyechik-ctr-acpkm-omac`, `magma-ctr-acpkm-omac` - блочные шифры, работающие в режиме с внутренним преобразованием ключа и выработкой имитовставки (только для openssl 3.0).

11. CMS расшифрование
    * Программно:
        ```bash
        openssl cms -decrypt -binary -in encrypted_cms -inform PEM -recip cert.cer -inkey seckey.pem -out decrypted_cms_data
        ```

    * Аппаратно:
        ```bash
        openssl cms -decrypt -binary -in encrypted_cms -inform PEM -recip cert.cer -keyform engine -inkey "your_pkcs11_uri" -engine rtengine -out decrypted_cms_data
        ```

12. Запуск SSL/TLS сервера/клиента

    rtengine версии 3.1 и выше, предоставляющий поддержку ГОСТ алгоритмов для OpenSSL 3.0, поддерживает криптонаборы, введенные в ГОСТ Р 1323565.1.020-2020.

    Для использования криптонаборов, основанных только на ГОСТ 28147, требуется добавить в конфигурацию сервера или клиента опцию `-cipher kGOST`, а для использования криптонаборов, основанных только на ГОСТ Р 1323565.1.020-2020 опцию `-cipher kGOST18` (только для openssl 3.0).

    Также возможно задать предпочитаемый криптонабор напрямую из списка, приведенного в мануале openssl.

    * Сервер, программный ключ:
        ```bash
        openssl s_server -key demoCA/private/cakey.pem -cert demoCA/cacert.pem -Verify 7 -CAfile demoCA/cacert.pem -accept 44330 -WWW -purpose any -4
        ```

    * Сервер, аппаратный ключ:
        ```bash
        openssl s_server -keyform engine -key "server_key_pkcs11_uri" -engine rtengine -cert demoCA/cacert.pem -Verify 7 -CAfile demoCA/cacert.pem -accept 44330 -WWW -purpose any -4
        ```

    * Клиент, программный ключ:
        ```bash
        openssl s_client -host 127.0.0.1 -port 44330 -cert cert.cer -key seckey.pem
        ```

    * Клиент, аппаратный ключ:
        ```bash
        openssl s_client -host 127.0.0.1 -port 44330 -cert cert.cer -keyform engine -key "client_key_pkcs11_uri" -engine rtengine
        ```

13. Создание ответа на запрос метки времени
    ```bash
    openssl ts -reply -queryfile request.tsq -out response.tsr
    ```
