/*************************************************************************
* Rutoken                                                                *
* Copyright (c) 2003-2025, Aktiv-Soft JSC. All rights reserved.          *
* Подробная информация:  http://www.rutoken.ru                           *
*------------------------------------------------------------------------*
 * Данный пример демонстрирует работу с сертификатами на токене с помощью *
 * pkicore. Во время выполнения программы в консоль выводится информация  *
 * о найденных сертификатах.                                              *
 *************************************************************************/

#include <common.h>

using namespace std;
using namespace rutoken::pkicore;

pair<X500Dn::RdnId::Type, string> rdnIds[] = { make_pair(X500Dn::RdnId::commonName, "commonName"),
                                               make_pair(X500Dn::RdnId::surname, "surname"),
                                               make_pair(X500Dn::RdnId::givenName, "givenName"),
                                               make_pair(X500Dn::RdnId::title, "title"),
                                               make_pair(X500Dn::RdnId::pseudonym, "pseudonym"),
                                               make_pair(X500Dn::RdnId::emailAddress, "emailAddress"),
                                               make_pair(X500Dn::RdnId::countryName, "countryName"),
                                               make_pair(X500Dn::RdnId::localityName, "localityName"),
                                               make_pair(X500Dn::RdnId::stateOrProvinceName, "stateOrProvinceName"),
                                               make_pair(X500Dn::RdnId::organization, "organization"),
                                               make_pair(X500Dn::RdnId::organizationalUnit, "organizationalUnit"),
                                               make_pair(X500Dn::RdnId::street, "street"),
                                               make_pair(X500Dn::RdnId::ogrn, "ogrn"),
                                               make_pair(X500Dn::RdnId::ogrnip, "ogrnip"),
                                               make_pair(X500Dn::RdnId::snils, "snils"),
                                               make_pair(X500Dn::RdnId::inn, "inn") };

int main() {
    try {
        cout << boolalpha;

        /**********************************************************************
         * Инициализируем pkicore, передав путь до директории с библиотекой    *
         * rtPKCS11ECP.                                                        *
         **********************************************************************/
        rutoken::pkicore::initialize(".");
        SCOPE_EXIT() {
            /**********************************************************************
             * Завершаем работу с pkicore при выходе из текущего блока.            *
             **********************************************************************/
            rutoken::pkicore::deinitialize();
        };

        /**********************************************************************
         * Получаем список подключенных устройств и продолжаем работу с первым *
         * доступным устройством.                                              *
         **********************************************************************/
        auto devices = Pkcs11Device::enumerate();
        if (devices.empty()) {
            throw runtime_error("There must be at least one device connected");
        }

        auto device = move(devices.front());

        /**********************************************************************
         * Получаем список сертификатов на устройстве.                         *
         **********************************************************************/
        auto certs = device.enumerateCerts();
        cout << certs.size() << " certificates have been found\n" << endl;

        /**********************************************************************
         * Выводим информацию о сертификатах.                                  *
         **********************************************************************/
        for (size_t i = 0; i != certs.size(); ++i) {
            auto& cert = certs[i];

            cout << "Certificate " << i << '\n';

            /**********************************************************************
             * Получаем субъект сертификата.                                       *
             **********************************************************************/
            auto subject = cert.getSubject();
            cout << "\tsubject:\n";

            /**********************************************************************
             * Выводим поля субъекта.                                              *
             **********************************************************************/
            for (size_t j = 0; j < arraysize(rdnIds); ++j) {
                if (subject.hasRdn(rdnIds[j].first)) {
                    cout << "\t\t" << rdnIds[j].second << ": " << subject.getRdn(rdnIds[j].first) << '\n';
                }
            }

            /**********************************************************************
             * Является ли сертификат доверенным в рамках текущего устройства.     *
             **********************************************************************/
            cout << "\tisTrusted: " << cert.isTrusted() << '\n';

            cout << endl;
        }
    } catch (const exception& e) {
        cerr << e.what() << endl;
        return 1;
    }

    return 0;
}
