/*************************************************************************
* Rutoken                                                                *
* Copyright (c) 2003-2025, Aktiv-Soft JSC. All rights reserved.          *
* Подробная информация:  http://www.rutoken.ru                           *
*------------------------------------------------------------------------*
 * Данный пример демонстрирует аутентификацию на токене с помощью pkicore.*
 *************************************************************************/

#include <common.h>

using namespace std;
using namespace rutoken::pkicore;

int main() {
    try {
        cout << boolalpha;

        /**********************************************************************
         * Инициализируем pkicore, передав путь до директории с библиотекой    *
         * rtPKCS11ECP.                                                        *
         **********************************************************************/
        rutoken::pkicore::initialize(".");
        SCOPE_EXIT() {
            /**********************************************************************
             * Завершаем работу с pkicore при выходе из текущего блока.            *
             **********************************************************************/
            rutoken::pkicore::deinitialize();
        };

        /**********************************************************************
         * Получаем список подключенных устройств и продолжаем работу с первым *
         * доступным устройством.                                              *
         **********************************************************************/
        auto devices = Pkcs11Device::enumerate();
        if (devices.empty()) {
            throw runtime_error("There must be at least one device connected");
        }

        auto device = move(devices.front());

        /**********************************************************************
         * Проверяем аутентифицированы ли на устройстве.                       *
         **********************************************************************/
        cout << "isLoggedIn: " << device.isLoggedIn() << endl;

        /**********************************************************************
         * Аутентифицируемся на устройстве.                                    *
         **********************************************************************/
        cout << "login" << endl;
        device.login("12345678");

        /**********************************************************************
         * Проверяем аутентифицированы ли на устройстве.                       *
         **********************************************************************/
        cout << "isLoggedIn: " << device.isLoggedIn() << endl;

        /**********************************************************************
         * Сбрасываем права доступа.                                           *
         **********************************************************************/
        cout << "logout" << endl;
        device.logout();

        /**********************************************************************
         * Проверяем аутентифицированы ли на устройстве.                            *
         **********************************************************************/
        cout << "isLoggedIn: " << device.isLoggedIn() << endl;
    } catch (const exception& e) {
        cerr << e.what() << endl;
        return 1;
    }

    return 0;
}
