/*
 * Decompiled with CFR 0.152.
 */
package rtjlib.JCP;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.UnrecoverableKeyException;
import java.util.Date;
import rtjlib.reader.OWNER;
import rtjlib.reader.RESPONSE;
import rtjlib.reader.SECURITY_OPS;
import rtjlib.reader.rtUtil;
import rtjlib.token.Rutoken;
import ru.CryptoPro.JCP.KeyStore.ContainerReaderInterface;
import ru.CryptoPro.JCP.KeyStore.MediaInterface;

public class RutokenContainerReader
implements ContainerReaderInterface {
    private static Rutoken m_fs = null;
    private MediaInterface m_media = null;
    protected String m_folderShort = null;
    protected String m_folderRoot = null;
    protected boolean m_Opened = false;
    protected boolean m_CreateReq = false;
    protected boolean m_CreateWas = false;
    protected boolean m_login = false;
    protected int m_error = 0;

    public RutokenContainerReader(Rutoken rutoken, MediaInterface mediaInterface, String string) {
        this.m_media = mediaInterface;
        this.m_Opened = false;
        this.m_CreateReq = false;
        this.m_CreateWas = false;
        this.m_folderShort = null;
        this.m_folderRoot = string;
        this.m_login = false;
        this.m_error = 0;
        this.setReader(rutoken);
    }

    private void createRequestedFolder() throws IOException, Throwable {
        if (!this.m_Opened || !this.m_CreateReq) {
            return;
        }
        RESPONSE rESPONSE = null;
        try {
            SECURITY_OPS sECURITY_OPS = new SECURITY_OPS(2);
            sECURITY_OPS.addOp((byte)64, (byte)1, (byte)2);
            sECURITY_OPS.addOp((byte)2, (byte)1, (byte)2);
            sECURITY_OPS.addOp((byte)1, (byte)1, (byte)2);
            String string = this.m_folderRoot + this.m_folderShort;
            rESPONSE = m_fs.CreateFile(string, 0, true, sECURITY_OPS);
            this.m_CreateReq = false;
            if (!rESPONSE.isSuccess() && rESPONSE.getSW() != 27273) {
                this.m_Opened = false;
                if (rESPONSE.getSW() == 27010) {
                    throw new IOException("Access deny");
                }
                throw new IOException("Unexpected Error");
            }
        }
        catch (Throwable throwable) {
            this.m_error = -1;
            throw throwable;
        }
        finally {
            if (rESPONSE != null) {
                rESPONSE.clear();
            }
        }
    }

    private short convertFileNum(String string, int n) throws Throwable {
        short s = rtUtil.String2HexShort(rtUtil.CheckPath(string));
        s = (short)(s + (n + 1));
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setReader(Rutoken rutoken) {
        RutokenContainerReader rutokenContainerReader = this;
        synchronized (rutokenContainerReader) {
            m_fs = rutoken;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setMedia(MediaInterface mediaInterface) {
        RutokenContainerReader rutokenContainerReader = this;
        synchronized (rutokenContainerReader) {
            this.m_media = mediaInterface;
        }
    }

    public void close() {
        try {
            if (this.m_error != 0) {
                // empty if block
            }
            this.m_error = 0;
            this.m_Opened = false;
            this.m_CreateReq = false;
            this.m_CreateWas = false;
            if (this.m_login) {
                this.m_login = false;
                m_fs.Logout();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int fileSize(int n) throws IOException {
        RESPONSE rESPONSE = null;
        try {
            String string = rtUtil.Short2String(this.convertFileNum(this.m_folderShort, n));
            string = this.m_folderRoot + this.m_folderShort + "/" + string;
            rESPONSE = m_fs.SelectFile(string);
            if (rESPONSE.isSuccess()) {
                int n2;
                short s = rESPONSE.getTLVShort((byte)-128);
                int n3 = n2 = s << 16 >>> 16;
                return n3;
            }
            try {
                throw new IOException("Error file size");
            }
            catch (Throwable throwable) {
                IOException iOException;
                if (throwable.getClass() != IOException.class) {
                    iOException = new IOException("Unexpected error");
                }
                throw (IOException)iOException;
            }
        }
        finally {
            if (rESPONSE != null) {
                rESPONSE.clear();
            }
        }
    }

    public String folder() {
        return this.m_folderShort;
    }

    public Date getCreationDate() throws IOException {
        return null;
    }

    public MediaInterface getMedia() {
        return this.m_media;
    }

    public boolean login(char[] cArray) throws IOException, UnrecoverableKeyException {
        if (cArray == null || cArray.length == 0) {
            throw new UnrecoverableKeyException("Invalid password");
        }
        try {
            RESPONSE rESPONSE = m_fs.Login(cArray, OWNER.USER);
            if (!rESPONSE.isSuccess()) {
                if ((rESPONSE.getSW() & 0xFFFFFF00) == 25344) {
                    throw new UnrecoverableKeyException("Invalid password");
                }
                throw new UnrecoverableKeyException("Invalid password");
            }
            this.m_login = true;
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            throw unrecoverableKeyException;
        }
        catch (Throwable throwable) {
            IOException iOException;
            if (throwable.getClass() != IOException.class) {
                iOException = new IOException("Unexpected error");
            }
            throw (IOException)iOException;
        }
        return true;
    }

    public byte[] readFile(int n, int n2, int n3) throws IOException {
        RESPONSE rESPONSE = null;
        try {
            byte[] byArray = null;
            String string = rtUtil.Short2String(this.convertFileNum(this.m_folderShort, n));
            string = this.m_folderRoot + this.m_folderShort + "/" + string;
            if (n3 == -1) {
                rESPONSE = m_fs.SelectFile(string);
                if (rESPONSE.isSuccess()) {
                    short s = rESPONSE.getTLVShort((byte)-128);
                    n3 = s << 16 >>> 16;
                    rESPONSE.clear();
                } else {
                    throw new IOException("Error during get file size");
                }
            }
            if (!(rESPONSE = m_fs.ReadFile(string, n2, byArray = new byte[n3], n3)).isSuccess()) {
                if (rESPONSE.getSW() == 27266) {
                    throw new FileNotFoundException();
                }
                throw new IOException("Error during read file");
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Throwable throwable) {
            throw new IOException("Unexpected error");
        }
        finally {
            if (rESPONSE != null) {
                rESPONSE.clear();
            }
        }
    }

    public void removeFile(int n) throws IOException {
        try {
            String string = rtUtil.Short2String(this.convertFileNum(this.m_folderShort, n));
            string = this.m_folderRoot + this.m_folderShort + "/" + string;
            RESPONSE rESPONSE = m_fs.DeleteFile(string, false);
            if (!rESPONSE.isSuccess() && rESPONSE.getSW() != 27266) {
                throw new IOException("Error during deleting file");
            }
        }
        catch (Throwable throwable) {
            IOException iOException;
            if (throwable.getClass() != IOException.class) {
                iOException = new IOException("Unexpected error");
            }
            throw (IOException)iOException;
        }
    }

    public void removeFolder() throws IOException {
        try {
            String string = this.m_folderRoot + this.m_folderShort;
            RESPONSE rESPONSE = m_fs.DeleteFile(string, false);
            if (!rESPONSE.isSuccess() && rESPONSE.getSW() != 27266) {
                throw new IOException("Error during deleting folder");
            }
        }
        catch (Throwable throwable) {
            IOException iOException;
            if (throwable.getClass() != IOException.class) {
                iOException = new IOException("Unexpected error");
            }
            throw (IOException)iOException;
        }
        finally {
            this.close();
        }
    }

    public void storeFile(int n, byte[] byArray, boolean bl) throws IOException {
        RESPONSE rESPONSE = null;
        try {
            this.createRequestedFolder();
            byte[] byArray2 = byArray;
            int n2 = byArray.length;
            String string = rtUtil.Short2String(this.convertFileNum(this.m_folderShort, n));
            string = this.m_folderRoot + this.m_folderShort + "/" + string;
            SECURITY_OPS sECURITY_OPS = new SECURITY_OPS(2);
            sECURITY_OPS.addOp((byte)2, (byte)1, (byte)2);
            sECURITY_OPS.addOp((byte)64, (byte)1, (byte)2);
            if (bl) {
                sECURITY_OPS.addOp((byte)1, (byte)1, (byte)2);
            }
            if (!(rESPONSE = m_fs.CreateFile(string, n2, false, sECURITY_OPS)).isSuccess() && rESPONSE.getSW() != 27273) {
                throw new IOException("Error during create file");
            }
            rESPONSE = m_fs.WriteFile(string, 0, byArray2, n2);
            if (!rESPONSE.isSuccess()) {
                throw new IOException("Error during writing to file");
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Throwable throwable) {
            throw new IOException("Unexpected error");
        }
        finally {
            if (rESPONSE != null) {
                rESPONSE.clear();
            }
        }
    }
}

