/*
 * Decompiled with CFR 0.152.
 */
package rtjlib.token;

import java.util.LinkedList;
import java.util.List;
import rtjlib.reader.APDU;
import rtjlib.reader.DATAFORMAT;
import rtjlib.reader.IJavaReader;
import rtjlib.reader.OWNER;
import rtjlib.reader.RESPONSE;
import rtjlib.reader.SECURITY_OPS;
import rtjlib.reader.rtUtil;

public class Rutoken {
    public static final int MAJOR = 196608;
    public static final int MINOR = 1;
    private IJavaReader m_reader = null;
    private int m_type;
    private DATAFORMAT formatData = DATAFORMAT.LE;
    private boolean bLogin = false;
    private boolean m_bConnected = false;
    private Object m_Security = null;

    public Rutoken() {
        this.m_reader = null;
        this.setDataFormat(DATAFORMAT.LE);
        this.m_bConnected = false;
        this.m_Security = null;
    }

    public Rutoken(String string) throws Throwable {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        Class<?> clazz = null;
        clazz = classLoader.loadClass(string);
        this.m_reader = (IJavaReader)clazz.newInstance();
        this.setDataFormat(DATAFORMAT.LE);
        this.m_bConnected = false;
        this.m_Security = null;
    }

    public Rutoken(IJavaReader iJavaReader) {
        this.m_reader = iJavaReader;
        this.setDataFormat(DATAFORMAT.LE);
        this.m_bConnected = false;
        this.m_Security = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SetReader(IJavaReader iJavaReader) {
        Rutoken rutoken = this;
        synchronized (rutoken) {
            if (this.m_reader != iJavaReader) {
                this.m_reader = iJavaReader;
            }
        }
    }

    protected String CheckPath(String string) throws Throwable {
        return rtUtil.replace(rtUtil.replace(string, "\\", ""), "/", "");
    }

    protected String FilePath2FolderPath(String string) throws Throwable {
        return string.substring(0, string.length() - 4);
    }

    protected byte[] PreparePath(String string, byte[] byArray, DATAFORMAT dATAFORMAT) throws Throwable {
        String string2 = new String(string);
        string2 = rtUtil.replace(rtUtil.replace(string2, "\\", ""), "/", "");
        if (byArray == null) {
            byArray = new byte[string2.length() / 2];
        }
        rtUtil.String2HexByte(string2, byArray);
        if (dATAFORMAT == DATAFORMAT.LE) {
            rtUtil.ByteArray2WordLittleEndian(byArray);
        }
        return byArray;
    }

    protected short Path2Id(String string) throws Throwable {
        return rtUtil.String2HexShort(new String(string.substring(string.length() - 4)));
    }

    public DATAFORMAT getDataFormat() {
        return this.formatData;
    }

    private void setDataFormat(DATAFORMAT dATAFORMAT) {
        this.formatData = dATAFORMAT;
    }

    private void clean(byte[] byArray, boolean bl) {
        if ((this.m_Security != null || bl) && byArray != null) {
            rtUtil.set(byArray, (byte)0);
        }
    }

    private void clean(APDU aPDU, boolean bl) {
        if ((this.m_Security != null || bl) && aPDU != null) {
            aPDU.clear();
        }
    }

    private void clean(RESPONSE rESPONSE, boolean bl) {
        if ((this.m_Security != null || bl) && rESPONSE != null) {
            rESPONSE.clear();
        }
    }

    protected short getFileSizeOwn(RESPONSE rESPONSE) throws Throwable {
        return rESPONSE.getTLVShort((byte)-128);
    }

    public void SetSecurity(Object object) {
        this.m_Security = object;
    }

    public RESPONSE SelectFile(String string, DATAFORMAT dATAFORMAT) throws Throwable {
        boolean bl = false;
        byte[] byArray = this.PreparePath(string, null, dATAFORMAT);
        if (byArray.length == 0) {
            byArray = this.PreparePath("3f00", null, dATAFORMAT);
            bl = true;
        }
        byte[] byArray2 = new byte[5 + byArray.length];
        byArray2[0] = 0;
        byArray2[1] = -92;
        byArray2[2] = !bl ? 8 : 0;
        byArray2[3] = 4;
        byArray2[4] = (byte)byArray.length;
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[5 + i] = byArray[i];
        }
        APDU aPDU = new APDU(byArray2);
        RESPONSE rESPONSE = this.m_reader.SendAPDU(aPDU, dATAFORMAT);
        this.clean(byArray2, false);
        this.clean(byArray, false);
        this.clean(aPDU, false);
        return rESPONSE;
    }

    public RESPONSE SelectFile(String string) throws Throwable {
        try {
            boolean bl = false;
            byte[] byArray = this.PreparePath(string, null, this.getDataFormat());
            if (byArray.length == 0) {
                byArray = this.PreparePath("3f00", null, this.getDataFormat());
                bl = true;
            }
            byte[] byArray2 = new byte[5 + byArray.length];
            byArray2[0] = 0;
            byArray2[1] = -92;
            byArray2[2] = !bl ? 8 : 0;
            byArray2[3] = 4;
            byArray2[4] = (byte)byArray.length;
            for (int i = 0; i < byArray.length; ++i) {
                byArray2[5 + i] = byArray[i];
            }
            APDU aPDU = new APDU(byArray2);
            RESPONSE rESPONSE = this.m_reader.SendAPDU(aPDU, this.getDataFormat());
            this.clean(byArray2, false);
            this.clean(byArray, false);
            this.clean(aPDU, false);
            return rESPONSE;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw throwable;
        }
    }

    protected RESPONSE SelectNext() throws Throwable {
        byte[] byArray = new byte[]{0, 0, 0, 0};
        byArray[0] = 0;
        byArray[1] = -92;
        byArray[2] = 0;
        byArray[3] = 4;
        APDU aPDU = new APDU(byArray);
        RESPONSE rESPONSE = this.m_reader.SendAPDU(aPDU, this.getDataFormat());
        this.clean(byArray, false);
        this.clean(aPDU, false);
        return rESPONSE;
    }

    protected RESPONSE SelectNext(short s) throws Throwable {
        byte[] byArray = new byte[]{0, 0, 0, 0, 0, 0, 0};
        byArray[0] = 0;
        byArray[1] = -92;
        byArray[2] = 0;
        byArray[3] = 6;
        byArray[4] = 2;
        byArray[5] = rtUtil.Byte0(s, this.getDataFormat());
        byArray[6] = rtUtil.Byte1(s, this.getDataFormat());
        APDU aPDU = new APDU(byArray);
        RESPONSE rESPONSE = this.m_reader.SendAPDU(aPDU, this.getDataFormat());
        this.clean(byArray, false);
        this.clean(aPDU, false);
        return rESPONSE;
    }

    protected RESPONSE SelectParent() throws Throwable {
        byte[] byArray = new byte[]{0, 0, 0, 0};
        byArray[0] = 0;
        byArray[1] = -92;
        byArray[2] = 3;
        byArray[3] = 4;
        APDU aPDU = new APDU(byArray);
        RESPONSE rESPONSE = this.m_reader.SendAPDU(aPDU, this.getDataFormat());
        this.clean(byArray, false);
        this.clean(aPDU, false);
        return rESPONSE;
    }

    protected RESPONSE SelectRec(String string) throws Throwable {
        short s = 16128;
        short s2 = 0;
        RESPONSE rESPONSE = this.SelectNext();
        while (true) {
            if (rESPONSE.isSuccess()) {
                s2 = rESPONSE.getTLVShort((byte)-126);
                s = rESPONSE.getTLVShort((byte)-125);
                if (s2 == 56) {
                    string = string + rtUtil.Short2String(s) + '/';
                    rESPONSE = this.SelectRec(string);
                    string = string.length() > 5 ? string.substring(0, string.length() - 5) : string.substring(0, string.length() - 1);
                }
            } else {
                if (rESPONSE.getSW() != 27266 || (rESPONSE = this.SelectParent()).isSuccess()) break;
                throw new Exception("[SelectRec] PARENT NOT FOUND!\n");
            }
            rESPONSE = this.SelectNext(s);
        }
        return rESPONSE;
    }

    protected RESPONSE SelectAddRec(String string, List list, boolean bl, boolean bl2, NestedLevel nestedLevel) throws Throwable {
        short s = 16128;
        short s2 = 0;
        RESPONSE rESPONSE = this.SelectNext();
        while (true) {
            if (rESPONSE.isSuccess()) {
                s2 = rESPONSE.getTLVShort((byte)-126);
                s = rESPONSE.getTLVShort((byte)-125);
                if (s2 == 56) {
                    string = string + rtUtil.Short2String(s) + '/';
                    if (bl2) {
                        list.add(rtUtil.Short2String(s));
                    } else {
                        list.add(string);
                    }
                    if (nestedLevel != null && nestedLevel.level == 0) {
                        rESPONSE = this.SelectParent();
                        if (!rESPONSE.isSuccess()) {
                            throw new Exception("[SelectRec] PARENT NOT FOUND!\n");
                        }
                        if (string.length() > 5) {
                            string = string.substring(0, string.length() - 5);
                        }
                    } else {
                        if (nestedLevel != null) {
                            --nestedLevel.level;
                        }
                        rESPONSE = this.SelectAddRec(string, list, bl, bl2, nestedLevel);
                        if (nestedLevel != null) {
                            ++nestedLevel.level;
                        }
                        string = string.length() > 5 ? string.substring(0, string.length() - 5) : string.substring(0, string.length() - 1);
                    }
                } else if (!bl && bl2) {
                    list.add(rtUtil.Short2String(s));
                } else if (!bl && !bl2) {
                    list.add(string + rtUtil.Short2String(s));
                }
            } else {
                if (rESPONSE.getSW() != 27266 || (rESPONSE = this.SelectParent()).isSuccess()) break;
                throw new Exception("[SelectRec] PARENT NOT FOUND!\n");
            }
            rESPONSE = this.SelectNext(s);
        }
        return rESPONSE;
    }

    public RESPONSE SelectNestedRec(String string) throws Throwable {
        boolean bl = false;
        try {
            this.m_reader.beginExclusive();
            bl = true;
            String string2 = this.CheckPath(string) + '/';
            RESPONSE rESPONSE = this.SelectFile(string);
            RESPONSE rESPONSE2 = rESPONSE = this.SelectRec(string2);
            return rESPONSE2;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (bl) {
                this.m_reader.endExclusive();
            }
        }
    }

    public RESPONSE SelectNestedAddRec(String string, LinkedList linkedList, boolean bl, int n) throws Throwable {
        boolean bl2 = false;
        try {
            this.m_reader.beginExclusive();
            bl2 = true;
            NestedLevel nestedLevel = new NestedLevel(n);
            String string2 = this.CheckPath(string) + '/';
            RESPONSE rESPONSE = this.SelectFile(string);
            RESPONSE rESPONSE2 = rESPONSE = this.SelectAddRec(string2, linkedList, true, bl, nestedLevel);
            return rESPONSE2;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (bl2) {
                this.m_reader.endExclusive();
            }
        }
    }

    public RESPONSE CreateFile(String string, int n, boolean bl, SECURITY_OPS sECURITY_OPS) throws Throwable {
        boolean bl2 = false;
        try {
            Object object;
            byte[] byArray = new byte[56];
            byArray[0] = 98;
            byArray[1] = 54;
            byArray[2] = -128;
            byArray[3] = 2;
            n = !bl ? n : 0;
            byArray[4] = rtUtil.Byte0(n, this.getDataFormat());
            byArray[5] = rtUtil.Byte1(n, this.getDataFormat());
            byArray[6] = -126;
            byArray[7] = 2;
            short s = !bl ? (short)1 : 56;
            byArray[8] = rtUtil.Byte0(s, this.getDataFormat());
            byArray[9] = rtUtil.Byte1(s, this.getDataFormat());
            byArray[10] = -125;
            byArray[11] = 2;
            short s2 = this.Path2Id(this.CheckPath(string));
            byArray[12] = rtUtil.Byte0(s2, this.getDataFormat());
            byArray[13] = rtUtil.Byte1(s2, this.getDataFormat());
            byArray[14] = -122;
            byArray[15] = 40;
            if (sECURITY_OPS == null) {
                sECURITY_OPS = !bl ? SECURITY_OPS.getDefaultFileOps() : SECURITY_OPS.getDefaultFolderOps();
            }
            byte[] byArray2 = new byte[]{sECURITY_OPS.access, sECURITY_OPS.getOp((int)0).condition, sECURITY_OPS.getOp((int)1).condition, sECURITY_OPS.getOp((int)2).condition, sECURITY_OPS.getOp((int)3).condition, sECURITY_OPS.getOp((int)4).condition, sECURITY_OPS.getOp((int)5).condition, sECURITY_OPS.getOp((int)6).condition, sECURITY_OPS.getOp((int)0).owner, 0, 0, 0, sECURITY_OPS.getOp((int)1).owner, 0, 0, 0, sECURITY_OPS.getOp((int)2).owner, 0, 0, 0, sECURITY_OPS.getOp((int)3).owner, 0, 0, 0, sECURITY_OPS.getOp((int)4).owner, 0, 0, 0, sECURITY_OPS.getOp((int)5).owner, 0, 0, 0, sECURITY_OPS.getOp((int)6).owner, 0, 0, 0, sECURITY_OPS.getOp((int)7).owner, 0, 0, 0};
            for (int i = 0; i < byArray2.length; ++i) {
                byArray[16 + i] = byArray2[i];
            }
            byte[] byArray3 = new byte[5 + byArray.length];
            byArray3[0] = 0;
            byArray3[1] = -32;
            byArray3[2] = 0;
            byArray3[3] = 0;
            byArray3[4] = (byte)byArray.length;
            for (int i = 0; i < byArray.length; ++i) {
                byArray3[5 + i] = byArray[i];
            }
            this.m_reader.beginExclusive();
            bl2 = true;
            RESPONSE rESPONSE = this.SelectFile(this.FilePath2FolderPath(this.CheckPath(string)));
            if (rESPONSE.isSuccess()) {
                object = new APDU(byArray3);
                rESPONSE = this.m_reader.SendAPDU((APDU)object, this.getDataFormat());
                this.clean((APDU)object, false);
            }
            this.clean(byArray3, false);
            this.clean(byArray, false);
            object = rESPONSE;
            return object;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (bl2) {
                this.m_reader.endExclusive();
            }
        }
    }

    public RESPONSE DeleteFile(String string, boolean bl) throws Throwable {
        boolean bl2 = false;
        try {
            Object object;
            byte[] byArray = new byte[7];
            byArray[0] = 0;
            byArray[1] = -28;
            byArray[2] = 0;
            byArray[3] = 0;
            byArray[4] = 2;
            short s = this.Path2Id(this.CheckPath(string));
            byArray[5] = rtUtil.Byte0(s, this.getDataFormat());
            byArray[6] = rtUtil.Byte1(s, this.getDataFormat());
            this.m_reader.beginExclusive();
            bl2 = true;
            RESPONSE rESPONSE = this.SelectFile(this.FilePath2FolderPath(this.CheckPath(string)));
            if (rESPONSE.isSuccess()) {
                object = new APDU(byArray);
                rESPONSE = this.m_reader.SendAPDU((APDU)object, this.getDataFormat());
                this.clean((APDU)object, false);
            }
            this.clean(byArray, false);
            object = rESPONSE;
            return object;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (bl2) {
                this.m_reader.endExclusive();
            }
        }
    }

    public RESPONSE WriteFile(String string, int n, byte[] byArray, int n2) throws Throwable {
        boolean bl = false;
        try {
            int n3;
            if (byArray.length < n2 || n2 <= 0) {
                RESPONSE rESPONSE = new RESPONSE(27264);
                return rESPONSE;
            }
            this.m_reader.beginExclusive();
            bl = true;
            RESPONSE rESPONSE = this.SelectFile(this.CheckPath(string));
            if (!rESPONSE.isSuccess()) {
                RESPONSE rESPONSE2 = rESPONSE;
                return rESPONSE2;
            }
            for (int i = 0; i < n2; i += n3) {
                if (this.m_Security != null) {
                    rESPONSE.clear();
                }
                n3 = n2 - i > 255 ? 255 : n2 - i;
                byte[] byArray2 = new byte[5 + n3];
                byArray2[0] = 0;
                byArray2[1] = -42;
                byArray2[2] = (byte)(n + i >> 8 & 0x7F);
                byArray2[3] = (byte)(n + i & 0xFF);
                byArray2[4] = (byte)n3;
                for (int j = 0; j < n3; ++j) {
                    byArray2[5 + j] = byArray[i + j];
                }
                APDU aPDU = new APDU(byArray2);
                rESPONSE = this.m_reader.SendAPDU(aPDU, this.getDataFormat());
                this.clean(byArray2, false);
                this.clean(aPDU, false);
                if (!rESPONSE.isSuccess()) break;
            }
            RESPONSE rESPONSE3 = rESPONSE;
            return rESPONSE3;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (bl) {
                this.m_reader.endExclusive();
            }
        }
    }

    public RESPONSE ReadFile(String string, int n, byte[] byArray, int n2) throws Throwable {
        boolean bl = false;
        try {
            int n3;
            if (byArray.length < n2 || n2 <= 0) {
                RESPONSE rESPONSE = new RESPONSE((short)(27648 + (short)(n2 & 0xFF)));
                return rESPONSE;
            }
            this.m_reader.beginExclusive();
            bl = true;
            RESPONSE rESPONSE = this.SelectFile(this.CheckPath(string));
            if (!rESPONSE.isSuccess()) {
                RESPONSE rESPONSE2 = rESPONSE;
                return rESPONSE2;
            }
            for (int i = 0; i < n2; i += n3) {
                if (this.m_Security != null) {
                    rESPONSE.clear();
                }
                n3 = n2 - i > 255 ? 255 : n2 - i;
                byte[] byArray2 = new byte[]{0, -80, (byte)(n + i >> 8 & 0x7F), (byte)(n + i & 0xFF), (byte)n3};
                APDU aPDU = new APDU(byArray2);
                rESPONSE = this.m_reader.SendAPDU(aPDU, this.getDataFormat());
                this.clean(byArray2, false);
                this.clean(aPDU, false);
                if (!rESPONSE.isSuccess()) break;
                for (int j = 0; j < rESPONSE.getAnswerSize(); ++j) {
                    byArray[i + j] = rESPONSE.getAnswer()[j];
                }
            }
            RESPONSE rESPONSE3 = rESPONSE;
            return rESPONSE3;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (bl) {
                this.m_reader.endExclusive();
            }
        }
    }

    public short GetFileSize(String string) throws Throwable {
        RESPONSE rESPONSE = this.SelectFile(this.CheckPath(string));
        return rESPONSE.isSuccess() ? rESPONSE.getTLVShort((byte)-128) : (short)-1;
    }

    public int GetFreeMemory() throws Throwable {
        boolean bl = false;
        try {
            byte[] byArray = new byte[]{0, 0, 0, 0, 0};
            byArray[0] = 0;
            byArray[1] = -54;
            byArray[2] = 1;
            byArray[3] = -118;
            byArray[4] = 4;
            this.m_reader.beginExclusive();
            bl = true;
            APDU aPDU = new APDU(byArray);
            RESPONSE rESPONSE = this.m_reader.SendAPDU(aPDU, this.getDataFormat());
            int n = rESPONSE.getAnswerSize() == 2 ? rESPONSE.getAnswerShort() << 16 >>> 16 : rESPONSE.getAnswerInt();
            this.clean(byArray, false);
            this.clean(aPDU, false);
            this.clean(rESPONSE, false);
            int n2 = n;
            return n2;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (bl) {
                this.m_reader.endExclusive();
            }
        }
    }

    public byte GetFreeTries(OWNER oWNER) throws Throwable {
        int n = oWNER == OWNER.ADMIN ? 1 : 2;
        byte[] byArray = new byte[]{0, 0, 0, 0};
        byArray[0] = 0;
        byArray[1] = 32;
        byArray[2] = 0;
        byArray[3] = (byte)n;
        APDU aPDU = new APDU(byArray);
        RESPONSE rESPONSE = this.m_reader.SendAPDU(aPDU, this.getDataFormat());
        this.clean(byArray, false);
        this.clean(aPDU, false);
        return (byte)(rESPONSE.getSW2() & 0xF);
    }

    public int GetSerialNumber() throws Throwable {
        byte[] byArray = new byte[]{0, 0, 0, 0, 0};
        byArray[0] = 0;
        byArray[1] = -54;
        byArray[2] = 1;
        byArray[3] = -127;
        byArray[4] = 4;
        APDU aPDU = new APDU(byArray);
        RESPONSE rESPONSE = this.m_reader.SendAPDU(aPDU, this.getDataFormat());
        this.clean(byArray, false);
        this.clean(aPDU, false);
        return rESPONSE.getAnswerInt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RESPONSE ConnectPCSC(String string, String string2) throws Throwable {
        Rutoken rutoken = this;
        synchronized (rutoken) {
            if (this.m_bConnected) {
                this.DisconnectPCSC(true);
            }
            if (string == null) {
                string = "Aktiv Co. ruToken 0";
            }
            if (string2 == null) {
                string2 = "T=0";
            }
            if (string.substring(0, string.length() - 1).equals("Aktiv Co. ruToken ")) {
                this.setDataFormat(DATAFORMAT.LE);
            } else {
                this.setDataFormat(DATAFORMAT.BE);
            }
            RESPONSE rESPONSE = this.m_reader.ConnectPCSC(string, string2);
            if (rESPONSE.isSuccess()) {
                this.m_bConnected = true;
            }
            return rESPONSE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RESPONSE DisconnectPCSC(boolean bl) throws Throwable {
        Rutoken rutoken = this;
        synchronized (rutoken) {
            if (bl && this.bLogin) {
                this.Logout();
            }
            RESPONSE rESPONSE = this.m_reader.DisconnectPCSC();
            this.m_bConnected = this.m_reader.getConnectState();
            return rESPONSE;
        }
    }

    public boolean getConnectState() {
        return this.m_reader == null ? false : this.m_reader.getConnectState();
    }

    public RESPONSE Login(String string, OWNER oWNER) throws Throwable {
        RESPONSE rESPONSE;
        byte[] byArray = null;
        char[] cArray = null;
        APDU aPDU = null;
        try {
            RESPONSE rESPONSE2;
            int n;
            int n2 = oWNER == OWNER.ADMIN ? 1 : 2;
            cArray = string.toCharArray();
            byArray = new byte[cArray.length + 5];
            byArray[0] = 0;
            byArray[1] = 32;
            byArray[2] = 0;
            byArray[3] = (byte)n2;
            byArray[4] = (byte)cArray.length;
            for (n = 0; n < cArray.length; ++n) {
                byArray[5 + n] = (byte)(cArray[n] & 0xFF);
            }
            n = 0;
            while (true) {
                if ((rESPONSE2 = this.m_reader.SendAPDU(aPDU = new APDU(byArray), this.getDataFormat())).isSuccess()) {
                    this.bLogin = true;
                    break;
                }
                if (rESPONSE2.getSW1() != 111 || rESPONSE2.getSW2() != -122 || n != 0) break;
                this.Logout();
                ++n;
            }
            rESPONSE = rESPONSE2;
            Object var11_11 = null;
            this.clean(byArray, false);
            this.clean(aPDU, false);
        }
        catch (Throwable throwable) {
            try {
                throw throwable;
            }
            catch (Throwable throwable2) {
                Object var11_12 = null;
                this.clean(byArray, false);
                this.clean(aPDU, false);
                rtUtil.set(cArray, '\u0000');
                throw throwable2;
            }
        }
        rtUtil.set(cArray, '\u0000');
        return rESPONSE;
    }

    public RESPONSE Login(byte[] byArray, OWNER oWNER) throws Throwable {
        byte[] byArray2 = null;
        APDU aPDU = null;
        try {
            RESPONSE rESPONSE;
            int n;
            int n2 = oWNER == OWNER.ADMIN ? 1 : 2;
            byArray2 = new byte[byArray.length + 5];
            byArray2[0] = 0;
            byArray2[1] = 32;
            byArray2[2] = 0;
            byArray2[3] = (byte)n2;
            byArray2[4] = (byte)byArray.length;
            for (n = 0; n < byArray.length; ++n) {
                byArray2[5 + n] = byArray[n];
            }
            n = 0;
            while (true) {
                if ((rESPONSE = this.m_reader.SendAPDU(aPDU = new APDU(byArray2), this.getDataFormat())).isSuccess()) {
                    this.bLogin = true;
                    break;
                }
                if (rESPONSE.getSW1() != 111 || rESPONSE.getSW2() != -122 || n != 0) break;
                this.Logout();
                ++n;
            }
            RESPONSE rESPONSE2 = rESPONSE;
            this.clean(byArray2, false);
            this.clean(aPDU, false);
            return rESPONSE2;
        }
        catch (Throwable throwable) {
            try {
                throw throwable;
            }
            catch (Throwable throwable2) {
                this.clean(byArray2, false);
                this.clean(aPDU, false);
                throw throwable2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RESPONSE Login(char[] cArray, OWNER oWNER) throws Throwable {
        RESPONSE rESPONSE;
        block6: {
            byte[] byArray = new byte[cArray.length];
            for (int i = 0; i < cArray.length; ++i) {
                byArray[i] = (byte)(cArray[i] & 0xFF);
            }
            try {
                rESPONSE = this.Login(byArray, oWNER);
                Object var6_6 = null;
                if (this.m_Security == null) break block6;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (this.m_Security != null) {
                    for (int i = 0; i < byArray.length; ++i) {
                        byArray[i] = 0;
                    }
                }
                throw throwable;
            }
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = 0;
            }
        }
        return rESPONSE;
    }

    public RESPONSE Logout() throws Throwable {
        byte[] byArray = new byte[]{0, 0, 0, 0};
        byArray[0] = -128;
        byArray[1] = 64;
        byArray[2] = 0;
        byArray[3] = 0;
        APDU aPDU = new APDU(byArray);
        RESPONSE rESPONSE = this.m_reader.SendAPDU(aPDU, this.getDataFormat());
        if (rESPONSE.isSuccess()) {
            this.bLogin = false;
        }
        this.clean(byArray, false);
        this.clean(aPDU, false);
        return rESPONSE;
    }

    class NestedLevel {
        public int level = 0;

        public NestedLevel(int n) {
            this.level = n;
        }
    }
}

