/*
 * Decompiled with CFR 0.152.
 */
package rtjlib.JCP;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.UnrecoverableKeyException;
import java.util.Date;
import rtjlib.reader.Owner;
import rtjlib.reader.Response;
import rtjlib.reader.rtUtil;
import rtjlib.token.RutokenBase;
import ru.CryptoPro.JCP.KeyStore.ContainerReaderInterface;
import ru.CryptoPro.JCP.KeyStore.MediaInterface;

public final class RutokenContainerReader
implements ContainerReaderInterface {
    private static RutokenBase m_fs = null;
    private MediaInterface m_media = null;
    protected String m_folderShort = null;
    protected String m_folderRoot = null;
    protected boolean m_folderOpened = false;
    protected boolean m_folderCreateRequestExist = false;
    protected boolean m_login = false;

    public RutokenContainerReader(RutokenBase rutokenBase, MediaInterface mediaInterface, String string) {
        this.m_media = mediaInterface;
        this.m_folderOpened = false;
        this.m_folderCreateRequestExist = false;
        this.m_folderShort = null;
        this.m_folderRoot = string;
        this.m_login = false;
        this.setReader(rutokenBase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRequestedFolder() throws IOException, Exception {
        if (!this.m_folderOpened || !this.m_folderCreateRequestExist) {
            return;
        }
        Response response = null;
        try {
            String string = this.m_folderRoot + this.m_folderShort;
            response = m_fs.createFile(string, 0, true, true);
            this.m_folderCreateRequestExist = false;
            if (!response.isSuccess() && response.getSW() != 27273) {
                this.m_folderOpened = false;
                if (response.getSW() == 27010) {
                    throw new IOException("Access deny");
                }
                throw new IOException("Unexpected Error");
            }
        }
        finally {
            if (response != null) {
                response.clear();
            }
        }
    }

    private short convertFileNum(String string, int n) throws Exception {
        short s = Short.parseShort(rtUtil.checkPath(string), 16);
        s = (short)(s + (n + 1));
        return s;
    }

    protected synchronized void setReader(RutokenBase rutokenBase) {
        m_fs = rutokenBase;
    }

    protected synchronized void setMedia(MediaInterface mediaInterface) {
        this.m_media = mediaInterface;
    }

    public void close() {
        try {
            this.m_folderOpened = false;
            this.m_folderCreateRequestExist = false;
            if (this.m_login) {
                this.m_login = false;
                m_fs.logout();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int fileSize(int n) throws IOException {
        Response response = null;
        try {
            String string = rtUtil.toHexString(this.convertFileNum(this.m_folderShort, n));
            string = this.m_folderRoot + this.m_folderShort + "/" + string;
            response = m_fs.selectFile(string);
            if (response.isSuccess()) {
                short s = response.getTLVShort((byte)-128, RutokenContainerReader.m_fs.TAG_FILE_LEN_0x80_ByteOrder);
                return s;
            }
            try {
                throw new IOException("Error file size");
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new IOException("Unexpected error");
            }
        }
        finally {
            if (response != null) {
                response.clear();
            }
        }
    }

    public String folder() {
        return this.m_folderShort;
    }

    public Date getCreationDate() throws IOException {
        return null;
    }

    public MediaInterface getMedia() {
        return this.m_media;
    }

    public boolean login(char[] cArray) throws IOException, UnrecoverableKeyException {
        if (cArray == null || cArray.length == 0) {
            throw new UnrecoverableKeyException("Invalid password");
        }
        try {
            Response response = m_fs.login(cArray, Owner.USER);
            if (!response.isSuccess()) {
                if ((response.getSW() & 0xFFFFFF00) == 25344) {
                    throw new UnrecoverableKeyException("Invalid password");
                }
                throw new UnrecoverableKeyException("Invalid password");
            }
            this.m_login = true;
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            throw unrecoverableKeyException;
        }
        catch (Exception exception) {
            throw new IOException("Unexpected error");
        }
        return true;
    }

    public byte[] readFile(int n, int n2, int n3) throws IOException {
        Response response = null;
        try {
            byte[] byArray = null;
            String string = rtUtil.toHexString(this.convertFileNum(this.m_folderShort, n));
            string = this.m_folderRoot + this.m_folderShort + "/" + string;
            if (n3 == -1) {
                response = m_fs.selectFile(string);
                if (response.isSuccess()) {
                    n3 = response.getTLVShort((byte)-128, RutokenContainerReader.m_fs.TAG_FILE_LEN_0x80_ByteOrder);
                    response.clear();
                } else {
                    throw new IOException("Error during get file size");
                }
            }
            if (!(response = m_fs.readFile(string, n2, byArray = new byte[n3], n3)).isSuccess()) {
                if (response.getSW() == 27266) {
                    throw new FileNotFoundException();
                }
                throw new IOException("Error during read file");
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException("Unexpected error");
        }
        finally {
            if (response != null) {
                response.clear();
            }
        }
    }

    public void removeFile(int n) throws IOException {
        try {
            String string = this.m_folderRoot + this.m_folderShort + "/" + rtUtil.toHexString(this.convertFileNum(this.m_folderShort, n));
            Response response = m_fs.deleteFile(string);
            if (!response.isSuccess() && response.getSW() != 27266) {
                throw new IOException("Error during deleting file");
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException("Unexpected error");
        }
    }

    public void removeFolder() throws IOException {
        try {
            String string = this.m_folderRoot + this.m_folderShort;
            Response response = m_fs.deleteFile(string);
            if (!response.isSuccess() && response.getSW() != 27266 && response.getSW() != 27010) {
                throw new IOException("Error during deleting folder");
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException("Unexpected error");
        }
        finally {
            this.close();
        }
    }

    public void storeFile(int n, byte[] byArray, boolean bl) throws IOException {
        Response response = null;
        try {
            this.createRequestedFolder();
            byte[] byArray2 = byArray;
            int n2 = byArray.length;
            String string = rtUtil.toHexString(this.convertFileNum(this.m_folderShort, n));
            string = this.m_folderRoot + this.m_folderShort + "/" + string;
            response = m_fs.createFile(string, n2, false, bl);
            if (!response.isSuccess() && response.getSW() != 27273) {
                throw new IOException("Error during create file");
            }
            response = m_fs.writeFile(string, 0, byArray2, n2);
            if (!response.isSuccess()) {
                throw new IOException("Error during writing to file");
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException("Unexpected error");
        }
        finally {
            if (response != null) {
                response.clear();
            }
        }
    }
}

