/*
 * Decompiled with CFR 0.152.
 */
package rtjlib.reader;

import java.nio.ByteOrder;
import java.util.Arrays;

public final class Response {
    private short SW;
    private byte[] answerAPDU;
    private int answerSize;
    private byte[] saveAPDU;
    private ByteOrder formatData;
    public static final byte TAG_FILEBODYSIZE_0x80 = -128;
    public static final byte TAG_FILEBODYHEADERSIZE_0x81 = -127;
    public static final byte TAG_SECATTR_0x86 = -122;
    public static final byte TAG_DESCRIPTOR_0x82 = -126;
    public static final byte TAG_ID_0x83 = -125;
    public static final byte TAG_LCSInteger_0x8A = -118;
    public static final short swSUCCESS = -28672;

    public Response() {
        this.setResponse((short)27013, null, 0, null, ByteOrder.LITTLE_ENDIAN, false);
    }

    public Response(short s) {
        this.setResponse(s, null, 0, null);
    }

    public short getSW() {
        return this.SW;
    }

    public byte getSW1() {
        return (byte)(this.SW >> 8 & 0xFF);
    }

    public byte getSW2() {
        return (byte)(this.SW & 0xFF);
    }

    public Response setSW(short s) {
        this.setResponse(s, null, 0, null);
        return this;
    }

    public byte[] getAnswer() {
        return this.answerAPDU;
    }

    public int getAnswerSize() {
        return this.answerSize;
    }

    private void setAnswer(byte[] byArray, int n, boolean bl) {
        this.answerAPDU = bl ? (byte[])byArray.clone() : byArray;
        this.answerSize = n;
    }

    public ByteOrder getFormat() {
        return this.formatData;
    }

    public void setFormat(ByteOrder byteOrder) {
        this.formatData = byteOrder;
    }

    private void setAPDU(byte[] byArray, boolean bl) {
        this.saveAPDU = null;
        if (byArray != null) {
            this.saveAPDU = bl ? (byte[])byArray.clone() : byArray;
        }
    }

    private void setResponse(short s, byte[] byArray, int n, byte[] byArray2) {
        this.SW = s;
        this.setAnswer(byArray, n, false);
        this.setAPDU(byArray2, false);
    }

    public void setResponse(short s, byte[] byArray, int n, byte[] byArray2, ByteOrder byteOrder, boolean bl) {
        this.SW = s;
        this.setAnswer(byArray, n, bl);
        this.setAPDU(byArray2, bl);
        this.formatData = byteOrder;
    }

    public boolean isSuccess() {
        return this.SW == -28672;
    }

    public void clear() {
        Arrays.fill(this.answerAPDU, (byte)0);
        if (this.saveAPDU != null) {
            Arrays.fill(this.saveAPDU, (byte)0);
        }
    }

    public int getAnswerInt() {
        if (this.getFormat() == ByteOrder.LITTLE_ENDIAN) {
            return this.answerSize != 4 ? -1 : this.answerAPDU[3] << 24 & 0xFF000000 | this.answerAPDU[2] << 16 & 0xFF0000 | this.answerAPDU[1] << 8 & 0xFF00 | this.answerAPDU[0] & 0xFF;
        }
        return this.answerSize != 4 ? -1 : this.answerAPDU[0] << 24 & 0xFF000000 | this.answerAPDU[1] << 16 & 0xFF0000 | this.answerAPDU[2] << 8 & 0xFF00 | this.answerAPDU[3] & 0xFF;
    }

    public short getAnswerShort() {
        if (this.getFormat() == ByteOrder.LITTLE_ENDIAN) {
            return (short)((short)this.answerAPDU[1] << 8 & 0xFF00 | (short)this.answerAPDU[0] & 0xFF);
        }
        return (short)((short)this.answerAPDU[0] << 8 & 0xFF00 | (short)this.answerAPDU[1] & 0xFF);
    }

    public short getTLVShort(byte by, ByteOrder byteOrder) throws Exception {
        byte[] byArray = this.getAnswer();
        if (this.getAnswerSize() <= 2 || byArray[0] != 98 || byArray[1] <= 2) {
            return -1;
        }
        for (int i = 2; i < this.getAnswerSize(); i += byArray[i + 1] + 2) {
            if (byArray[i] != by) continue;
            if (byArray[i + 1] != 2) break;
            if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                return (short)(((short)byArray[i + 2] & 0xFF) + ((short)byArray[i + 3] << 8));
            }
            return (short)(((short)byArray[i + 3] & 0xFF) + ((short)byArray[i + 2] << 8));
        }
        return -1;
    }

    public byte getTLVByte(byte by) throws Exception {
        byte[] byArray = this.getAnswer();
        if (this.getAnswerSize() <= 2 || byArray[0] != 98 || byArray[1] <= 2) {
            return -1;
        }
        for (int i = 2; i < this.getAnswerSize(); i += byArray[i + 1] + 2) {
            if (byArray[i] != by) continue;
            if (byArray[i + 1] != 1) break;
            return byArray[i + 2];
        }
        return -1;
    }

    public byte[] getTLVByteArray(byte by) throws Exception {
        byte[] byArray = this.getAnswer();
        if (this.getAnswerSize() <= 2 || byArray[0] != 98 || byArray[1] <= 2) {
            return null;
        }
        for (int i = 2; i < this.getAnswerSize(); i += byArray[i + 1] + 2) {
            if (byArray[i] != by) continue;
            int n = byArray[i + 1];
            byte[] byArray2 = new byte[n];
            for (int j = 0; j < n; ++j) {
                byArray2[j] = byArray[i + 2 + j];
            }
            return byArray2;
        }
        return null;
    }
}

