/*
 * Decompiled with CFR 0.152.
 */
package rtjlib.reader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.LinkedList;

public class rtUtil {
    public static String toHexString(int n) {
        return Integer.toHexString(0x10000 | n).substring(1).toUpperCase();
    }

    public static byte[] hexStringToByteArray(String string) {
        int n = string.length();
        byte[] byArray = new byte[n / 2];
        for (int i = 0; i < n; i += 2) {
            byArray[i / 2] = (byte)((Character.digit(string.charAt(i), 16) << 4) + Character.digit(string.charAt(i + 1), 16));
        }
        return byArray;
    }

    public static String checkPath(String string) throws Exception {
        return string.replaceAll("\\\\\\\\|/", "");
    }

    public static String filePath2FolderPath(String string) throws Exception {
        return string.substring(0, string.length() - 4);
    }

    public static byte[] preparePath(String string, ByteOrder byteOrder) throws Exception {
        String string2 = rtUtil.checkPath(string);
        byte[] byArray = rtUtil.hexStringToByteArray(string2);
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            rtUtil.byteArray2WordLittleEndian(byArray);
        }
        return byArray;
    }

    public static short path2Id(String string) throws Exception {
        return Short.parseShort(new String(string.substring(string.length() - 4)), 16);
    }

    public static byte[] byteArray2WordLittleEndian(byte[] byArray) {
        for (int i = 0; i < byArray.length; i += 2) {
            byte by = byArray[i];
            byArray[i] = byArray[i + 1];
            byArray[i + 1] = by;
        }
        return byArray;
    }

    public static byte getLoByte(int n, ByteOrder byteOrder) {
        return byteOrder == ByteOrder.BIG_ENDIAN ? (byte)(n & 0xFF) : (byte)(n >> 8 & 0xFF);
    }

    public static byte getHiByte(int n, ByteOrder byteOrder) {
        return byteOrder == ByteOrder.BIG_ENDIAN ? (byte)(n >> 8 & 0xFF) : (byte)(n & 0xFF);
    }

    public static void multiString2ListString(char[] cArray, LinkedList[] linkedListArray, String string) {
        if (linkedListArray == null) {
            return;
        }
        if (cArray == null || cArray.length == 0) {
            if (linkedListArray[0] == null) {
                linkedListArray[0] = new LinkedList();
            }
            linkedListArray[0].clear();
            return;
        }
        String string2 = null;
        if (linkedListArray[0] == null) {
            linkedListArray[0] = new LinkedList();
        }
        linkedListArray[0].clear();
        int n = 0;
        while (cArray[n] != '\u0000') {
            int n2 = 0;
            while (cArray[n + n2] != '\u0000') {
                ++n2;
            }
            string2 = new String(cArray, n, n2);
            if (string == null || string2.indexOf(string) != -1) {
                linkedListArray[0].add(string2);
            }
            n = n + n2 + 1;
        }
    }

    public static boolean cmpMultiString(char[] cArray, char[] cArray2) {
        if (cArray == null || cArray2 == null) {
            return false;
        }
        if (cArray[0] == '\u0000' && cArray2[0] == '\u0000') {
            return true;
        }
        int n = cArray.length <= cArray2.length ? cArray.length : cArray2.length;
        int n2 = 0;
        while (cArray[n2] != '\u0000') {
            if (n2 >= n || cArray[n2] != cArray2[n2]) {
                return false;
            }
            if (cArray[++n2] != '\u0000' || cArray2[n2] != '\u0000') continue;
            ++n2;
        }
        return cArray[n2] == cArray2[n2];
    }

    public static char[] copyMultiString(char[] cArray, char[] cArray2) {
        if (cArray == null) {
            return null;
        }
        int n = 0;
        while (cArray[n] != '\u0000') {
            n = cArray[n + 1] != '\u0000' ? n + 1 : n + 2;
        }
        if (cArray2 == null || cArray2.length < ++n) {
            cArray2 = new char[n];
        }
        n = 0;
        while (cArray[n] != '\u0000') {
            while (cArray[n] != '\u0000') {
                cArray2[n] = cArray[n];
                ++n;
            }
            cArray2[n] = cArray[n];
            ++n;
        }
        cArray2[n] = cArray[n];
        return cArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean doEmptyAndDelete(String string, boolean bl) {
        File file;
        FileOutputStream fileOutputStream;
        block16: {
            fileOutputStream = null;
            file = new File(string);
            if (file.exists() && file.isFile()) break block16;
            boolean bl2 = false;
            Object var6_7 = null;
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return bl2;
        }
        if (bl) {
            fileOutputStream = new FileOutputStream(file);
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            fileOutputStream = null;
        }
        boolean bl3 = file.delete();
        Object var6_8 = null;
        try {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl3;
        catch (Exception exception) {
            try {
                Object var6_9 = null;
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (Exception exception3) {}
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2) throws IOException {
        if (!file2.exists()) {
            file2.createNewFile();
        }
        long l = file.length();
        FileChannel fileChannel = new FileInputStream(file).getChannel();
        try {
            FileChannel fileChannel2 = new FileOutputStream(file2).getChannel();
            try {
                for (long i = 0L; i < l; i += fileChannel.transferTo(i, l - i, fileChannel2)) {
                }
            }
            finally {
                fileChannel2.close();
            }
        }
        finally {
            fileChannel.close();
        }
    }

    public static class Enum {
        protected short _enumValue;

        protected Enum(short s) {
            this._enumValue = s;
        }

        public short Value() {
            return this._enumValue;
        }
    }
}

