/*
 * Decompiled with CFR 0.152.
 */
package rtjlib.readerImpl;

import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.LinkedList;
import rtjlib.nativeAPI;
import rtjlib.reader.APDU;
import rtjlib.reader.IJavaReader;
import rtjlib.reader.Response;

public class nativeWinJavaReader
implements IJavaReader {
    private static boolean m_dllLoad = false;
    private long m_hContext = 0L;
    private boolean m_bConnected = false;
    private long m_hCard = 0L;
    private int m_dwActiveProtocol = 0;
    private static LinkedList m_connectedTerminals = new LinkedList();
    private int m_index = -1;
    private static boolean[] m_inExclusive = null;
    private boolean m_bCatchExclusive = false;

    public nativeWinJavaReader() {
        m_dllLoad = false;
    }

    public Response ConnectPCSC(String string, String string2, byte[] byArray) throws Exception {
        try {
            Response response = new Response();
            long[] lArray = new long[]{0L};
            if (!m_dllLoad) {
                nativeAPI.loadLibrary();
            }
            m_dllLoad = true;
            if (this.m_bConnected) {
                this.DisconnectPCSC();
            }
            int n = nativeAPI.SCardEstablishContext((int)0, (long)0L, (long)0L, (long[])lArray);
            this.m_hContext = lArray[0];
            if (string == null) {
                string = "Aktiv Co. ruToken 0";
            }
            if (string2 == null) {
                string2 = "T=0";
            }
            int n2 = 0;
            if (string2.toUpperCase().indexOf("T=0") != -1) {
                n2 |= 1;
            }
            if (string2.toUpperCase().indexOf("T=1") != -1) {
                n2 |= 2;
            }
            if (string2.toUpperCase().indexOf("RAW") != -1) {
                n2 |= 4;
            }
            long[] lArray2 = new long[]{0L};
            int[] nArray = new int[]{0};
            byArray = nativeAPI.SCardConnect((long)this.m_hContext, (char[])string.toCharArray(), (int)2, (int)n2, (long[])lArray2, (int[])nArray);
            this.m_hCard = lArray2[0];
            this.m_dwActiveProtocol = nArray[0];
            this.m_bConnected = true;
            this.m_index = m_connectedTerminals.indexOf(string);
            if (this.m_index == -1) {
                m_connectedTerminals.addLast(string);
                boolean[] blArray = new boolean[m_connectedTerminals.size()];
                for (int i = 0; m_inExclusive != null && i < m_inExclusive.length; ++i) {
                    blArray[i] = m_inExclusive[i];
                }
                m_inExclusive = blArray;
                this.m_index = m_connectedTerminals.indexOf(string);
                nativeWinJavaReader.m_inExclusive[this.m_index] = false;
                this.m_bCatchExclusive = false;
            }
            response.setSW((short)-28672);
            return response;
        }
        catch (Exception exception) {
            if (this.m_hContext != 0L) {
                nativeAPI.SCardReleaseContext((long)this.m_hContext);
                this.m_hContext = 0L;
            }
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getAtr(String string, String string2) throws Exception {
        byte[] byArray;
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        try {
            byte[] byArray2;
            if (!m_dllLoad) {
                nativeAPI.loadLibrary();
            }
            m_dllLoad = true;
            int n = nativeAPI.SCardEstablishContext((int)0, (long)0L, (long)0L, (long[])lArray);
            if (string == null) {
                string = "Aktiv Co. ruToken 0";
            }
            if (string2 == null) {
                string2 = "T=0";
            }
            int n2 = 0;
            if (string2.toUpperCase().indexOf("T=0") != -1) {
                n2 |= 1;
            }
            if (string2.toUpperCase().indexOf("T=1") != -1) {
                n2 |= 2;
            }
            if (string2.toUpperCase().indexOf("RAW") != -1) {
                n2 |= 4;
            }
            int[] nArray = new int[]{0};
            byArray = byArray2 = nativeAPI.SCardConnect((long)lArray[0], (char[])string.toCharArray(), (int)2, (int)n2, (long[])lArray2, (int[])nArray);
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            block11: {
                Object var10_10 = null;
                if (lArray2[0] != 0L) {
                    nativeAPI.SCardDisconnect((long)lArray2[0], (int)0);
                }
                if (lArray[0] == 0L) break block11;
                nativeAPI.SCardReleaseContext((long)lArray[0]);
            }
            throw throwable;
        }
        if (lArray2[0] != 0L) {
            nativeAPI.SCardDisconnect((long)lArray2[0], (int)0);
        }
        if (lArray[0] != 0L) {
            nativeAPI.SCardReleaseContext((long)lArray[0]);
        }
        return byArray;
    }

    public Response DisconnectPCSC() throws Exception {
        if (this.m_hCard == 0L) {
            throw new IllegalStateException("Card has been disconnected");
        }
        Response response = new Response();
        if (this.m_bCatchExclusive) {
            this.endExclusive();
        }
        if (this.m_hCard != 0L && this.m_bConnected) {
            nativeAPI.SCardDisconnect((long)this.m_hCard, (int)0);
            this.m_bConnected = false;
            this.m_hCard = 0L;
            this.m_dwActiveProtocol = 0;
        }
        if (this.m_hContext != 0L && !this.m_bConnected) {
            nativeAPI.SCardReleaseContext((long)this.m_hContext);
            this.m_hContext = 0L;
        }
        response.setSW((short)-28672);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response SendAPDU(APDU aPDU, ByteOrder byteOrder) throws Exception {
        byte[] byArray = new byte[1024];
        if (this.m_hCard == 0L) {
            throw new IllegalStateException("Card has been disconnected");
        }
        Response response = new Response();
        try {
            Object object;
            if (this.m_hCard != 0L && this.m_bConnected) {
                object = new long[]{0L};
                long[] lArray = new long[]{};
                int[] nArray = new int[]{byArray.length};
                nativeAPI.getSCARDIOREQUEST((int)this.m_dwActiveProtocol, (long[])object);
                nativeAPI.SCardTransmit((long)this.m_hCard, (long)object[0], (byte[])aPDU.command(), (int)aPDU.command().length, (long[])lArray, (byte[])byArray, (int[])nArray);
                byte by = byArray[nArray[0] - 2];
                byte by2 = byArray[nArray[0] - 1];
                short s = (short)((short)by << 8 & 0xFF00 | (short)by2 & 0xFF);
                response.setResponse(s, byArray, nArray[0] - 2, null, byteOrder, true);
            }
            if (!this.m_bConnected) {
                throw new IllegalStateException("Card has been disconnected");
            }
            object = response;
            return object;
        }
        finally {
            Arrays.fill(byArray, (byte)0);
        }
    }

    public boolean getConnectState() {
        return this.m_bConnected;
    }

    public boolean beginExclusive() throws Exception {
        if (this.m_hCard == 0L) {
            throw new IllegalStateException("Card has been disconnected");
        }
        if (this.m_hCard != 0L && this.m_bConnected) {
            nativeAPI.SCardBeginTransaction((long)this.m_hCard);
            nativeWinJavaReader.m_inExclusive[this.m_index] = true;
            this.m_bCatchExclusive = true;
            return true;
        }
        throw new IllegalStateException("Card has been disconnected");
    }

    public boolean endExclusive() throws Exception {
        if (this.m_hCard == 0L) {
            throw new IllegalStateException("Card has been disconnected");
        }
        if (this.m_hCard != 0L && this.m_bConnected) {
            nativeWinJavaReader.m_inExclusive[this.m_index] = false;
            this.m_bCatchExclusive = false;
            nativeAPI.SCardEndTransaction((long)this.m_hCard, (int)0);
            return true;
        }
        throw new IllegalStateException("Card has been disconnected");
    }

    public void clearBeginExclusive() throws Exception {
    }

    public void clearEndExclusive() throws Exception {
    }

    public static char[] getListReadersDefaultContext(char[] cArray) {
        return nativeWinJavaReader.getListReadersByContext(cArray, null);
    }

    public static char[] getListReadersCurrentContext(char[] cArray) {
        long[] lArray = new long[]{0L};
        return nativeWinJavaReader.getListReadersByContext(cArray, lArray);
    }

    public static char[] getListReadersByContext(char[] cArray, long[] lArray) {
        try {
            int[] nArray = new int[]{cArray == null ? 0 : cArray.length};
            if (cArray == null) {
                cArray = nativeWinJavaReader.listReaders(cArray, nArray, lArray);
            } else if (nativeWinJavaReader.listReaders(cArray, nArray, lArray) == null && nativeWinJavaReader.listReaders(cArray = new char[nArray[0]], nArray, lArray) == null) {
                throw new IOException("Can't read list of readers\n");
            }
        }
        catch (Exception exception) {
            cArray = null;
        }
        return cArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static char[] listReaders(char[] cArray, int[] nArray, long[] lArray) throws Exception {
        char[] cArray2 = cArray;
        int[] nArray2 = new int[]{cArray2 != null ? cArray2.length : 0};
        long l = 0L;
        boolean bl = false;
        int n = 0;
        try {
            try {
                if (!m_dllLoad) {
                    nativeAPI.loadLibrary();
                }
                m_dllLoad = true;
                if (lArray != null && lArray[0] == 0L) {
                    nativeAPI.SCardEstablishContext((int)0, (long)0L, (long)0L, (long[])lArray);
                    bl = true;
                }
                long l2 = l = lArray == null ? 0L : lArray[0];
                if (cArray == null) {
                    n = nativeAPI.SCardListReaders((long)l, null, null, (int[])nArray2);
                    cArray2 = new char[nArray2[0]];
                }
                n = nativeAPI.SCardListReaders((long)l, null, (char[])cArray2, (int[])nArray2);
                nArray[0] = nArray2[0];
                if (n == -2146435064) {
                    cArray2 = null;
                } else if (n != 0) {
                    throw new IOException("Can't read list of readers\n");
                }
                Object var11_8 = null;
                if (!bl) return cArray2;
                if (l == 0L) return cArray2;
            }
            catch (Exception exception) {
                cArray2 = null;
                nArray[0] = nArray2[0];
                throw exception;
            }
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            if (!bl) throw throwable;
            if (l == 0L) throw throwable;
            nativeAPI.SCardReleaseContext((long)l);
            l = 0L;
            lArray[0] = 0L;
            throw throwable;
        }
        nativeAPI.SCardReleaseContext((long)l);
        l = 0L;
        lArray[0] = 0L;
        return cArray2;
    }
}

