/*
 * Decompiled with CFR 0.152.
 */
package rtjlib.token;

import java.io.IOException;
import java.nio.ByteOrder;
import rtjlib.reader.APDU;
import rtjlib.reader.Owner;
import rtjlib.reader.Response;
import rtjlib.reader.rtUtil;
import rtjlib.token.RutokenBase;

public class Rutoken
extends RutokenBase {
    public Rutoken() {
        this.mainTokenByteOrder = ByteOrder.BIG_ENDIAN;
        this.selectFolderIDByteOrder = ByteOrder.LITTLE_ENDIAN;
        this.TAG_DECSR_0x82_ByteOrder = ByteOrder.LITTLE_ENDIAN;
        this.TAG_FILE_ID_0x83_ByteOrder = ByteOrder.BIG_ENDIAN;
        this.TAG_FILE_LEN_0x80_ByteOrder = ByteOrder.BIG_ENDIAN;
        this.cryptoProRootPath = "1000/1003/";
    }

    public Response selectFile(String string) throws Exception {
        boolean bl = false;
        byte[] byArray = rtUtil.preparePath(string, this.mainTokenByteOrder);
        if (byArray.length == 0) {
            byArray = rtUtil.preparePath("3f00", this.mainTokenByteOrder);
            bl = true;
        }
        byte[] byArray2 = new byte[6 + byArray.length];
        byArray2[0] = 0;
        byArray2[1] = -92;
        byArray2[2] = !bl ? 8 : 0;
        byArray2[3] = 4;
        byArray2[4] = (byte)byArray.length;
        System.arraycopy(byArray, 0, byArray2, 5, byArray.length);
        byArray2[5 + byArray.length] = -1;
        APDU aPDU = new APDU(byArray2);
        Response response = this.reader.SendAPDU(aPDU, this.mainTokenByteOrder);
        return response;
    }

    protected Response selectNext() throws Exception {
        byte[] byArray = new byte[]{0, 0, 0, 0, 0};
        byArray[0] = 0;
        byArray[1] = -92;
        byArray[2] = 0;
        byArray[3] = 4;
        byArray[4] = -1;
        APDU aPDU = new APDU(byArray);
        Response response = this.reader.SendAPDU(aPDU, this.mainTokenByteOrder);
        return response;
    }

    protected Response selectNext(short s) throws Exception {
        byte[] byArray = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        byArray[0] = 0;
        byArray[1] = -92;
        byArray[2] = 0;
        byArray[3] = 6;
        byArray[4] = 2;
        byArray[5] = rtUtil.getHiByte(s, this.mainTokenByteOrder);
        byArray[6] = rtUtil.getLoByte(s, this.mainTokenByteOrder);
        byArray[7] = -1;
        APDU aPDU = new APDU(byArray);
        Response response = this.reader.SendAPDU(aPDU, this.mainTokenByteOrder);
        return response;
    }

    protected Response selectParent() throws Exception {
        byte[] byArray = new byte[]{0, 0, 0, 0, 0};
        byArray[0] = 0;
        byArray[1] = -92;
        byArray[2] = 3;
        byArray[3] = 4;
        byArray[4] = -1;
        APDU aPDU = new APDU(byArray);
        Response response = this.reader.SendAPDU(aPDU, this.mainTokenByteOrder);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response createFile(String string, int n, boolean bl, boolean bl2) throws Exception {
        try {
            Object object;
            byte by = 67;
            byte by2 = 2;
            if (!bl2 && !bl) {
                by = 66;
                by2 = 0;
            }
            int n2 = !bl ? n : 0;
            short s = rtUtil.path2Id(rtUtil.checkPath(string));
            int n3 = !bl ? 1 : 56;
            byte[] byArray = new byte[]{98, 29, -126, 2, rtUtil.getHiByte(n3, this.TAG_DECSR_0x82_ByteOrder), rtUtil.getLoByte(n3, this.TAG_DECSR_0x82_ByteOrder), -128, 2, rtUtil.getHiByte(n2, this.TAG_FILE_LEN_0x80_ByteOrder), rtUtil.getLoByte(n2, this.TAG_FILE_LEN_0x80_ByteOrder), -125, 2, rtUtil.getHiByte(s, this.TAG_FILE_ID_0x83_ByteOrder), rtUtil.getLoByte(s, this.TAG_FILE_ID_0x83_ByteOrder), -122, 15, by, by2, 2, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0};
            byte[] byArray2 = new byte[5 + byArray.length];
            byArray2[0] = 0;
            byArray2[1] = -32;
            byArray2[2] = 0;
            byArray2[3] = 0;
            byArray2[4] = (byte)byArray.length;
            System.arraycopy(byArray, 0, byArray2, 5, byArray.length);
            this.reader.beginExclusive();
            Response response = this.selectFile(rtUtil.filePath2FolderPath(rtUtil.checkPath(string)));
            if (response.isSuccess()) {
                object = new APDU(byArray2);
                response = this.reader.SendAPDU((APDU)object, this.mainTokenByteOrder);
            }
            object = response;
            return object;
        }
        finally {
            this.reader.endExclusive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response deleteFile(String string) throws Exception {
        try {
            Object object;
            byte[] byArray = new byte[7];
            byArray[0] = 0;
            byArray[1] = -28;
            byArray[2] = 0;
            byArray[3] = 0;
            byArray[4] = 2;
            short s = rtUtil.path2Id(rtUtil.checkPath(string));
            byArray[5] = rtUtil.getHiByte(s, this.mainTokenByteOrder);
            byArray[6] = rtUtil.getLoByte(s, this.mainTokenByteOrder);
            this.reader.beginExclusive();
            Response response = this.selectFile(rtUtil.filePath2FolderPath(rtUtil.checkPath(string)));
            if (response.isSuccess()) {
                object = new APDU(byArray);
                response = this.reader.SendAPDU((APDU)object, this.mainTokenByteOrder);
            }
            object = response;
            return object;
        }
        finally {
            this.reader.endExclusive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response writeFile(String string, int n, byte[] byArray, int n2) throws Exception {
        try {
            int n3;
            int n4;
            if (byArray.length < n2 || n2 <= 0) {
                Response response = new Response(27264);
                return response;
            }
            this.reader.beginExclusive();
            Response response = this.selectFile(rtUtil.checkPath(string));
            if (!response.isSuccess()) {
                Response response2 = response;
                return response2;
            }
            short s = response.getTLVShort((byte)-128, this.TAG_FILE_LEN_0x80_ByteOrder);
            byte[] byArray2 = response.getTLVByteArray((byte)-122);
            if (null == byArray2 || 0 == byArray2.length || -1 == s) {
                throw new IOException("Error during writing to file: FCP is invalid");
            }
            if (n2 > s - n) {
                response = this.deleteFile(string);
                if (!response.isSuccess()) {
                    Response response3 = response;
                    return response3;
                }
                n4 = 0;
                if (1 == (byArray2[0] & 1)) {
                    n4 = 1;
                }
                if (!(response = this.createFile(string, n2 + n, false, n4 != 0)).isSuccess()) {
                    Response response4 = response;
                    return response4;
                }
            }
            for (n4 = 0; n4 < n2; n4 += n3) {
                response.clear();
                n3 = n2 - n4 > 255 ? 255 : n2 - n4;
                byte[] byArray3 = new byte[5 + n3];
                byArray3[0] = 0;
                byArray3[1] = -42;
                byArray3[2] = (byte)(n + n4 >> 8 & 0x7F);
                byArray3[3] = (byte)(n + n4 & 0xFF);
                byArray3[4] = (byte)n3;
                for (int i = 0; i < n3; ++i) {
                    byArray3[5 + i] = byArray[n4 + i];
                }
                APDU aPDU = new APDU(byArray3);
                response = this.reader.SendAPDU(aPDU, this.mainTokenByteOrder);
                if (!response.isSuccess()) break;
            }
            Response response5 = response;
            return response5;
        }
        finally {
            this.reader.endExclusive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFreeMemory() throws Exception {
        try {
            int n;
            byte[] byArray = new byte[]{0, 0, 0, 0, 0};
            byArray[0] = 0;
            byArray[1] = -54;
            byArray[2] = 1;
            byArray[3] = -118;
            byArray[4] = 4;
            this.reader.beginExclusive();
            APDU aPDU = new APDU(byArray);
            Response response = this.reader.SendAPDU(aPDU, this.mainTokenByteOrder);
            int n2 = n = response.getAnswerSize() == 2 ? response.getAnswerShort() : response.getAnswerInt();
            return n2;
        }
        finally {
            this.reader.endExclusive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response login(char[] cArray, Owner owner) throws Exception {
        try {
            Response response;
            byte[] byArray = new byte[cArray.length];
            for (int i = 0; i < cArray.length; ++i) {
                byArray[i] = (byte)(cArray[i] & 0xFF);
            }
            int n = owner == Owner.ADMIN ? 1 : 2;
            byte[] byArray2 = new byte[byArray.length + 5];
            byArray2[0] = 0;
            byArray2[1] = 32;
            byArray2[2] = 0;
            byArray2[3] = (byte)n;
            byArray2[4] = (byte)byArray.length;
            System.arraycopy(byArray, 0, byArray2, 5, byArray.length);
            this.reader.beginExclusive();
            int n2 = 0;
            while (true) {
                APDU aPDU;
                if ((response = this.reader.SendAPDU(aPDU = new APDU(byArray2), this.mainTokenByteOrder)).isSuccess()) {
                    this.isLoggedIn = true;
                    break;
                }
                if (response.getSW1() != 111 || response.getSW2() != -122 || n2 != 0) break;
                this.logout();
                ++n2;
            }
            Response response2 = response;
            return response2;
        }
        finally {
            this.reader.endExclusive();
        }
    }

    public Response logout() throws Exception {
        byte[] byArray = new byte[]{0, 0, 0, 0};
        byArray[0] = -128;
        byArray[1] = 64;
        APDU aPDU = new APDU(byArray);
        Response response = this.reader.SendAPDU(aPDU, this.mainTokenByteOrder);
        if (response.isSuccess()) {
            this.isLoggedIn = false;
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response readFile(String string, int n, byte[] byArray, int n2) throws Exception {
        try {
            int n3;
            if (byArray.length < n2 || n2 <= 0) {
                Response response = new Response((short)(27648 + (short)(n2 & 0xFF)));
                return response;
            }
            this.reader.beginExclusive();
            Response response = this.selectFile(rtUtil.checkPath(string));
            if (!response.isSuccess()) {
                Response response2 = response;
                return response2;
            }
            for (int i = 0; i < n2; i += n3) {
                response.clear();
                n3 = n2 - i > 255 ? 255 : n2 - i;
                byte[] byArray2 = new byte[]{0, -80, (byte)(n + i >> 8 & 0x7F), (byte)(n + i & 0xFF), (byte)n3};
                APDU aPDU = new APDU(byArray2);
                response = this.reader.SendAPDU(aPDU, this.mainTokenByteOrder);
                if (!response.isSuccess()) break;
                System.arraycopy(response.getAnswer(), 0, byArray, i, response.getAnswerSize());
            }
            Response response3 = response;
            return response3;
        }
        finally {
            this.reader.endExclusive();
        }
    }

    public int getSerialNumber() throws Exception {
        byte[] byArray = new byte[]{0, 0, 0, 0, 0};
        byArray[0] = 0;
        byArray[1] = -54;
        byArray[2] = 1;
        byArray[3] = -127;
        byArray[4] = 8;
        APDU aPDU = new APDU(byArray);
        Response response = this.reader.SendAPDU(aPDU, this.mainTokenByteOrder);
        return response.getAnswerInt() & 0xF;
    }
}

