/*
 * Decompiled with CFR 0.152.
 */
package rtjlib.token;

import java.io.IOException;
import java.nio.ByteOrder;
import java.util.LinkedList;
import java.util.List;
import rtjlib.reader.IJavaReader;
import rtjlib.reader.Owner;
import rtjlib.reader.Response;
import rtjlib.reader.rtUtil;

public abstract class RutokenBase {
    public static final String[] jcpFoldersNames = new String[]{"0a00", "0b00", "0c00", "0d00", "0e00", "0f00", "1000", "1100", "1200", "1300", "1400", "1500", "1600", "1700", "1800"};
    public static final String folderSeparator = "/";
    public static final short errNoRigths = 27010;
    public static final short errFileAlreadyExist = 27273;
    public static final short errFileNotFound = 27266;
    public static final short errUnsuccessfulAuth = 25344;
    public static final short errWrongInput = 27264;
    protected IJavaReader reader = null;
    protected ByteOrder mainTokenByteOrder = ByteOrder.LITTLE_ENDIAN;
    protected ByteOrder selectFolderIDByteOrder = ByteOrder.LITTLE_ENDIAN;
    public ByteOrder TAG_DECSR_0x82_ByteOrder;
    public ByteOrder TAG_FILE_ID_0x83_ByteOrder;
    public ByteOrder TAG_FILE_LEN_0x80_ByteOrder;
    protected boolean isLoggedIn = false;
    private boolean isConnected = false;
    public String cryptoProRootPath;

    public RutokenBase() {
        this.reader = null;
        this.mainTokenByteOrder = ByteOrder.LITTLE_ENDIAN;
        this.isLoggedIn = false;
        this.isConnected = false;
    }

    public RutokenBase(String string) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        Class<?> clazz = classLoader.loadClass(string);
        this.reader = (IJavaReader)clazz.newInstance();
        this.mainTokenByteOrder = ByteOrder.LITTLE_ENDIAN;
        this.isLoggedIn = false;
        this.isConnected = false;
    }

    public RutokenBase(IJavaReader iJavaReader) {
    }

    public synchronized void setReader(IJavaReader iJavaReader) {
        if (this.reader != iJavaReader) {
            this.reader = iJavaReader;
        }
    }

    public synchronized Response connectPCSC(String string, String string2) throws Exception {
        byte[] byArray;
        Response response;
        if (this.isConnected) {
            this.disconnectPCSC(true);
        }
        if (string == null) {
            string = "Aktiv Co. ruToken 0";
        }
        if (string2 == null) {
            string2 = "T=0";
        }
        if ((response = this.reader.ConnectPCSC(string, string2, byArray = null)).isSuccess()) {
            this.isConnected = true;
        }
        return response;
    }

    public boolean getConnectState() {
        return this.reader == null ? false : this.reader.getConnectState();
    }

    public synchronized Response disconnectPCSC(boolean bl) throws Exception {
        if (bl && this.isLoggedIn) {
            this.logout();
        }
        Response response = this.reader.DisconnectPCSC();
        this.isConnected = this.reader.getConnectState();
        return response;
    }

    public abstract Response selectFile(String var1) throws Exception;

    public abstract Response login(char[] var1, Owner var2) throws Exception;

    public abstract Response logout() throws Exception;

    protected abstract Response selectNext() throws Exception;

    protected abstract Response selectNext(short var1) throws Exception;

    protected abstract Response selectParent() throws Exception;

    protected Response selectRecursive(String string) throws Exception {
        short s = 16128;
        Response response = this.selectNext();
        while (true) {
            if (response.isSuccess()) {
                short s2 = response.getTLVShort((byte)-126, this.TAG_DECSR_0x82_ByteOrder);
                s = response.getTLVShort((byte)-125, this.TAG_FILE_ID_0x83_ByteOrder);
                if (s2 == 56) {
                    string = string + rtUtil.toHexString(s) + '/';
                    response = this.selectRecursive(string);
                    string = string.length() > 5 ? string.substring(0, string.length() - 5) : string.substring(0, string.length() - 1);
                }
            } else {
                if (response.getSW() != 27010 || (response = this.selectParent()).isSuccess()) break;
                throw new IOException("[selectRecursive] PARENT NOT FOUND!");
            }
            response = this.selectNext(s);
        }
        return response;
    }

    protected Response getListSelectRecursive(String string, List list, boolean bl, boolean bl2, NestedLevel nestedLevel) throws Exception {
        short s = 16128;
        short s2 = 0;
        Response response = this.selectNext();
        while (true) {
            if (response.isSuccess()) {
                s2 = response.getTLVShort((byte)-126, this.TAG_DECSR_0x82_ByteOrder);
                s = response.getTLVShort((byte)-125, this.TAG_FILE_ID_0x83_ByteOrder);
                if (s2 == 56) {
                    response = this.selectNext();
                    if (response.getSW() == 27266) {
                        response = this.selectParent();
                        response = this.selectNext(s);
                        continue;
                    }
                    string = string + rtUtil.toHexString(s) + '/';
                    if (bl2) {
                        list.add(rtUtil.toHexString(s));
                    } else {
                        list.add(string);
                    }
                    if (nestedLevel != null && nestedLevel.level == 0) {
                        response = this.selectParent();
                        if (!response.isSuccess()) {
                            throw new Exception("[getListSelectRecursive] PARENT NOT FOUND!\n");
                        }
                        if (string.length() > 5) {
                            string = string.substring(0, string.length() - 5);
                        }
                    } else {
                        if (nestedLevel != null) {
                            --nestedLevel.level;
                        }
                        response = this.getListSelectRecursive(string, list, bl, bl2, nestedLevel);
                        if (nestedLevel != null) {
                            ++nestedLevel.level;
                        }
                        string = string.length() > 5 ? string.substring(0, string.length() - 5) : string.substring(0, string.length() - 1);
                    }
                } else if (!bl && bl2) {
                    list.add(rtUtil.toHexString(s));
                } else if (!bl && !bl2) {
                    list.add(string + rtUtil.toHexString(s));
                }
            } else {
                if (response.getSW() != 27266 || (response = this.selectParent()).isSuccess()) break;
                throw new Exception("[getListSelectRecursive] PARENT NOT FOUND!\n");
            }
            response = this.selectNext(s);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response getListSelectNestedRecursive(String string, LinkedList linkedList, boolean bl, int n) throws Exception {
        try {
            this.reader.beginExclusive();
            NestedLevel nestedLevel = new NestedLevel(n);
            String string2 = rtUtil.checkPath(string) + '/';
            Response response = this.selectFile(string);
            Response response2 = response = this.getListSelectRecursive(string2, linkedList, true, bl, nestedLevel);
            return response2;
        }
        finally {
            this.reader.endExclusive();
        }
    }

    public abstract Response createFile(String var1, int var2, boolean var3, boolean var4) throws Exception;

    public abstract Response deleteFile(String var1) throws Exception;

    public abstract Response writeFile(String var1, int var2, byte[] var3, int var4) throws Exception;

    public abstract Response readFile(String var1, int var2, byte[] var3, int var4) throws Exception;

    public abstract int getFreeMemory() throws Exception;

    public abstract int getSerialNumber() throws Exception;

    protected static class FcpConst {
        public static final byte RT_FCP_TAG = 98;
        public static final byte RT_FCP_FILE_LEN = -128;
        public static final byte RT_FCP_DESCR = -126;
        public static final byte RT_FCP_FILE_ID = -125;
        public static final byte RT_FCP_SEC_ATTR = -122;

        protected FcpConst() {
        }
    }

    class NestedLevel {
        public int level = 0;

        public NestedLevel(int n) {
            this.level = n;
        }
    }
}

