#!/usr/bin/env bash

set -eu

# Параметры домена
FREEIPA_SERVER="ipa.rtkn.test"
FREEIPA_SERVER_IP="172.16.112.20"
DOMAIN="rtkn.test"
FREEIPA_ADMIN="admin"
FREEIPA_ADMIN_PASSWORD="Eklmn1516"

# Проверка на наличие root-прав
[[ "$(whoami)" != "root" ]] && \
    echo "Скрипт должен быть запущен с root-правами" && \
    exit 1

# Проверка на корректный hostname
[[ "$(hostname -s)" == "localhost" ]] && \
    echo "Недопустимо использовать localhost в качестве hostname" && \
    echo "Измените его при помощи вызова команды 'hostnamectl set-hostname <hostname>'" && \
    exit 1

[[ "$(hostname -s)" =~ [A-Z] ]] && \
    echo "Недопустимо наличие символов в верхнем регистре в hostname" && \
    echo "Измените его при помощи вызова команды 'hostnamectl set-hostname <hostname>'" && \
    exit 1

set -x

# Установка необходимых пакетов
apt-get update
DEBIAN_FRONTEND=noninteractive apt-get install -q -y astra-freeipa-client

# Изменение hostname машины
hostnamectl set-hostname "$(hostname -s).$DOMAIN"

# Настройка разрешения имён
MACHINE_IP=$(hostname -I | grep -Eo '^([0-9]+\.){3}[0-9]+')
sed -i "s/127.0.1.1.*/$MACHINE_IP $(hostname -s).$DOMAIN/" /etc/hosts
echo "$FREEIPA_SERVER_IP $FREEIPA_SERVER ${FREEIPA_SERVER%%.*}" >> /etc/hosts

# Настройка сетевого соединения
CON_NAME="$(nmcli -t -f NAME c show --active | head -n 1 -)"
nmcli con mod "$CON_NAME" ipv4.dns "$FREEIPA_SERVER_IP"
nmcli con mod "$CON_NAME" ipv4.ignore-auto-dns yes
nmcli con down "$CON_NAME"; nmcli con up "$CON_NAME"

# Ввод клиента в домен
astra-freeipa-client -d "$DOMAIN" -u "$FREEIPA_ADMIN" -p "$FREEIPA_ADMIN_PASSWORD" -y --par "--force-join"

set +x

# Напоминание о необходимости перезагрузить систему
echo "Перезагрузите систему"