#!/usr/bin/env bash

set -eu

# Параметры домена
SERVER="ipa.test.test"
SERVER_IP="172.16.115.30"
DOMAIN="test.test"
ADMIN_USERNAME="login"
ADMIN_PASSWORD="password"

export PATH=$PATH:/sbin:/usr/sbin/

# Проверка на наличие root-прав
[[ "$(whoami)" != "root" ]] && \
    echo "Скрипт должен быть запущен с root-правами" && \
    exit 1

# Проверка на корректный hostname
[[ "$(hostname -s)" == "localhost" ]] && \
    echo "Недопустимо использовать localhost в качестве hostname" && \
    echo "Измените его при помощи вызова команды 'hostnamectl set-hostname <hostname>'" && \
    exit 1

[[ "$(hostname -s)" =~ [A-Z] ]] && \
    echo "Недопустимо наличие символов в верхнем регистре в hostname" && \
    echo "Измените его при помощи вызова команды 'hostnamectl set-hostname <hostname>'" && \
    exit 1

set -x

# Установка необходимых пакетов
apt-get update
apt-get install -y freeipa-client zip

# Изменение hostname машины
hostnamectl set-hostname "$(hostname -s).$DOMAIN"

# Настройка сетевого соединения
sed -i "s/etcnet-alt,//" /etc/NetworkManager/NetworkManager.conf
systemctl restart NetworkManager

## Настройка сетевого соединения специфичная для Alt Linux 8.4
if [[ "$(cat /etc/system-release)" == "*ALT 8*" ]]
then
    OLD_CON_NAME="$(nmcli -t -f NAME c show --active | head -n 1 -)"
    nmcli con down "$OLD_CON_NAME"
fi

NEW_CON_NAME="$(nmcli -t -f NAME c show --active | head -n 1 -)"
nmcli con mod "$NEW_CON_NAME" ipv4.dns "$SERVER_IP,8.8.8.8"
nmcli con mod "$NEW_CON_NAME" ipv4.ignore-auto-dns yes
nmcli con mod "$NEW_CON_NAME" autoconnect yes
nmcli con down "$NEW_CON_NAME" || true; nmcli con up "$NEW_CON_NAME"

# Ввод клиента в домен
ipa-client-install --mkhomedir --force-join --no-nisdomain -p "$ADMIN_USERNAME" \
-w "$ADMIN_PASSWORD" --server "$SERVER" --domain "$DOMAIN" -U

set +x

# Напоминание о необходимости перезагрузить систему
echo "Перезагрузите систему"
