#!/usr/bin/env bash

set -eu

# Параметры домена
SERVER="ipa.test.test"
SERVER_IP="172.16.112.10"
DOMAIN="test.test"
ADMIN_USERNAME="login"
ADMIN_PASSWORD="password"

# Проверка на наличие root-прав
[[ "$(whoami)" != "root" ]] && \
    echo "Скрипт должен быть запущен с root-правами" && \
    exit 1

# Проверка на корректный hostname
[[ "$(hostname -s)" == "localhost" ]] && \
    echo "Недопустимо использовать localhost в качестве hostname" && \
    echo "Измените его при помощи вызова команды 'hostnamectl set-hostname <hostname>'" && \
    exit 1

[[ "$(hostname -s)" =~ [A-Z] ]] && \
    echo "Недопустимо наличие символов в верхнем регистре в hostname" && \
    echo "Измените его при помощи вызова команды 'hostnamectl set-hostname <hostname>'" && \
    exit 1

set -x

# Установка необходимых пакетов
dnf install -y ipa-client

# Изменение hostname машины
hostnamectl set-hostname "$(hostname -s).$DOMAIN"

# Настройка сетевого соединения
CON_NAME="$(nmcli -t -f NAME c show --active | head -n 1 -)"
nmcli con mod "$CON_NAME" ipv4.dns "$SERVER_IP,8.8.8.8"
nmcli con mod "$CON_NAME" ipv4.ignore-auto-dns yes
nmcli con down "$CON_NAME"; nmcli con up "$CON_NAME"

# Ввод клиента в домен
ipa-client-install --mkhomedir --force-join --no-nisdomain -p "$ADMIN_USERNAME" \
-w "$ADMIN_PASSWORD" --server "$SERVER" --domain "$DOMAIN" -U

set +x

# Напоминание о необходимости перезагрузить систему
echo "Перезагрузите систему"
