<?php
/*
Plugin Name: Rutoken Web
Plugin URI: http://www.rutoken.com
Description: This plugin enables rutoken web hardware authentication in wordpress
Author: 
Version: 1.0
Revision: 1
Author URI: http://www.rutoken.com
*/

add_action ('init', 'rutoken_init');
add_action('login_form', 'rutoken_login_form');
add_filter('authenticate', 'rutoken_authenticate', 10, 3);
add_action('wp_footer', 'rutoken_wp_footer');
add_action('admin_footer', 'rutoken_wp_footer');
add_action('profile_personal_options', 'rutoken_profile_personal_options');
add_action('edit_user_profile', 'rutoken_edit_user_profile');
//============================================================================ 
$params = array();
$params['rutoken_url'] = site_url('wp-content/plugins/rutoken/');
$params['image_yes_attach_text'] = '<img border="0" id="image_attach" alt="' . __('Привязан'). '" src="'
	. $params['rutoken_url'].'plugged-16x16.png">&nbsp;' 
	. __('Привязан');
$params['image_not_attach_text'] = '<img border="0" id="image_attach" alt="' . __('Не привязан'). '" src="' . 
	$params['rutoken_url'].'unplugged-16x16.png">&nbsp;' . __('Не привязан');
//============================================================================
function rutoken_init()
{
	load_plugin_textdomain('rutoken', false, 'rutoken');

	if (get_option('rutoken_allow_disabled') === false)
		update_option('rutoken_allow_disabled', 1);
	
	if (get_option('rutoken_user_managment') === false)
		update_option('rutoken_user_managment', 1);
		
	session_start();
}


function rutoken_wp_footer()
{
	global $params;
    $params['promo'] = 'wordpress';
    $params['rutoken_url'] = site_url('wp-content/plugins/rutoken/');
    $params['user_logged'] = is_user_logged_in();
    if ($params['user_logged'])
    {
        $user = wp_get_current_user();
        $params['logout_url'] = site_url('wp-login.php?action=logout');
        $is_admin = current_user_can('level_8');
        if (get_option('rutoken_user_managment') || $is_admin)
	        $params['attach_url'] = $params['rutoken_url'].'ajax.php?user_id='.$user->ID;

        // localized strings
		$params['str_attach_ask'] = __('Обнаружен Рутокен Web. Выполнить привязку к аккаунту?','rutoken');
		$params['str_attach_success'] = __('Подключенный Рутокен Web привязан к аккаунту','rutoken');
		$params['str_attach_failed'] = __('Ошибка привязки Рутокен Web к аккаунту','rutoken');
		$params['str_reattach_success'] = __('Привязка Рутокен Web с аккаунтом удалена','rutoken');
		$params['str_reattach_failed'] = __('Ошибка удаления привязки Рутокен Web','rutoken');
		$params['rutoken_confirm_remove'] = __('Удалить связь с Рутокен Web?','rutoken');
		$params['rutoken_confirm_delete'] = __('Удалить ключ с USB-токена?','rutoken');
		$params['rutoken_confirm_rename'] = __('Переписать ключ USB-токена для аккаунта?','rutoken');
		$params['rutoken_confirm_iskey'] = __('На USB-токене существует ключ для этого логина. Удалить?','rutoken');

        include_once('rutoken_integrate.inc.php');
        echo Rutoken_GetIntegrationScript($params);
    }
}


function rutoken_authenticate($user, $username, $password)
{
	$user = new WP_User(sanitize_user(isset($_POST['log']) ? $_POST['log'] : null));

	if ($user == null) {
		$_SESSION['random_text'] = '';
		return null;
	}		
	
	$rutoken_authorization = get_user_meta($user->ID, "rutoken_authorization", true);	
	
	if ($rutoken_authorization == 2){
		remove_filter('authenticate', 'wp_authenticate_username_password', 20, 3);
	}
	$type_action = (int)$_POST['token_repair'];
	
	if ((isset($type_action) && (1 == $type_action)) || (0 < $rutoken_authorization))
	{
		require_once('crypto/token.php');
		
		if (isset($type_action) && (1 == $type_action)){
			$x_pkey = get_user_meta($user->ID, "r_xkey", true);//??
			$y_pkey = get_user_meta($user->ID, "r_ykey", true);//??
		} else {
			$x_pkey = get_user_meta($user->ID, "user_xkey", true);//??
			$y_pkey = get_user_meta($user->ID, "user_ykey", true);//??				
		}

		$r_ecp = substr($password,0,64);
		$s_ecp = substr($password,64);
			
		$rand_num = $_SESSION['random_text'];
                      
		if (token_verify($rand_num, $x_pkey, $y_pkey, $r_ecp, $s_ecp)) {
			return $user;			
		} 
	}	
	else {
		$_SESSION['random_text'] = '';
		if ($rutoken_authorization == 0){
			remove_action('authenticate', 'rutoken_authenticate', 1, 3);
			do_action("wp_signon", array('', ''));
			return null;
		}
	}
	return new WP_Error( 'incorrect_password', sprintf( __( '<strong>Ошибка</strong>: Введенный пароль для пользователя <strong>%1$s</strong> неверен. <a onclick="switch_author();" style="cursor: pointer;">Воспользуйтесь Рутокен Web для входа в аккаунт.</a>' ),
		$username ) );
	//return null;
}

function rutoken_login_form()
{
	global $params;
    $promo = get_option('rutoken_promo');
    if (empty($promo))
	    $params['promo'] = 'wordpress';  
    else if (strpos($promo, ":") === FALSE)
		$params['promo'] = $promo;  
	else
		$params['rutoken_promo_url'] = $promo; 

    $params['rutoken_url'] = site_url('wp-content/plugins/rutoken/');
    $params['user_logged'] = false;
    $params['loginname_path'] = '"user_login"';
	$params ['password_path'] = '"user_pass"';
	$params ['hidden_path'] = '["user_pass","rememberme"]';
	$params ['button_enter'] = '"' . __('Log In') .'"';
	$params ['loginform_name'] = '["loginform"]';
	// путь для генерации случайной последовательности
	$params['url_random'] = $params['rutoken_url'].'ajax.php?action=random';
    $params['image_xoffset'] = '-5px';
    $params['image_yoffset'] = '-12px';
    $params['loginname_width_offset'] = 30;

    // localized strings
    $params['str_unplugged'] = __('Не подключен Рутокен Web','rutoken');
    $params['str_plugged'] = __('Рутокен Web подключен','rutoken');
	$params['str_not_install'] = __('Не установлен модуль поддержки Рутокен Web','rutoken');
	$params ['str_error_pin'] = __('Введен ошибочный PIN код.','rutoken');
    $params ['rutoken_repair_label'] = __('Восстановить доступ?','rutoken');

    include_once('rutoken_integrate.inc.php');
    echo Rutoken_GetIntegrationScript($params);

}


function  rutoken_edit_user_profile()
{
	global $params;

    $user = new WP_User($_GET['user_id']);
    
	$params['user_rutoken_id'] = $user->ID;
	$params ['user_login'] = $user->user_login;
	$params ['com_rutoken_url'] = site_url('wp-content/plugins/rutoken/').'ajax.php?user_id='.$user->ID;
	
    echo '<h3>'.__('Аутентификация Рутокен Web','rutoken').'</h3>'."\n";
    echo '<table class="form-table">'."\n";
    echo '<tr>'."\n";
// Тип аутентификации
	$rutoken_authorization = get_user_meta($user->ID, "rutoken_authorization", true);
	echo '	<th><label for="paramsrutoken_authoriz">'.__('Тип аутентификации','rutoken').'</label></th>'."\n";
	echo '	<td><select onchange="select_rutoken_authoriz();return false;" id="paramsrutoken_authoriz" name="paramsrutoken_authoriz" class="">';
	echo '<option value="0" ' . ($rutoken_authorization == 0 ? 'selected="selected"' : '') .'>Стандартная аутентификация</option><option value="1"' . ($rutoken_authorization == 1 ? 'selected="selected"' : '') .'>Смешанная аутентификация</option><option value="2" ' . ($rutoken_authorization == 2 ? 'selected="selected"' : '') .'>Аутентификация по Рутокен Web</option></select></td>'."\n";
	echo '<tr>'."\n";
	echo '</tr>'."\n";
	// Привязан / не привязан
	// Кнопки привязать и отключить
	echo '	<th><label for="">'.__('Привязка к Рутокен Web','rutoken').'</label></th>'."\n";
	echo ' <td>' . ( $rutoken_authorization != null ? $params['image_yes_attach_text'] : $params['image_not_attach_text']) . '</td>' ."\n";
	echo '<tr>'."\n";
	echo '</tr>'."\n";
	echo '	<th></th><td>';
	
	echo '<button onclick="rutoken_attach_key_to_account(' .($rutoken_authorization != null ? '1' : '') .');return false;" id="attach_button" class="button">Привязать USB-токен</button>
	<button onclick="rutoken_remove_key_to_account();return false;" id="reattach_button" class="button"' .($rutoken_authorization != null ? '' : ' style="display:none" ' ) . '>Отключить USB-токен</button>
	</td>'."\n";
    echo '</tr>'."\n";
    echo '</table>'."\n";
}


function  rutoken_profile_personal_options()
{
	global $params;
	
    $user = wp_get_current_user();
    $is_admin = current_user_can('level_8');
    if ($is_admin && false)
    {
	    $_GET['user_id'] = $user->ID;
	    rutoken_edit_user_profile();
    }
    else
    {
		$params['user_rutoken_id'] = $user->ID;
		$params ['user_login'] = $user->user_login;
		$params ['com_rutoken_url'] = site_url('wp-content/plugins/rutoken/').'ajax.php?user_id='.$user->ID;
	
        echo '<h3>'.__('Аутентификация Рутокен Web','rutoken').'</h3>'."\n";
        echo '<table class="form-table">'."\n";
        echo '<tr>'."\n";
		// Тип аутентификации
		$rutoken_authorization = get_user_meta($user->ID, "rutoken_authorization", true);
		echo '	<th><label for="paramsrutoken_authoriz">'.__('Тип аутентификации','rutoken').'</label></th>'."\n";
        echo '	<td><select onchange="select_rutoken_authoriz();return false;" id="paramsrutoken_authoriz" name="paramsrutoken_authoriz" class="">';
		echo '<option value="0" ' . ($rutoken_authorization == 0 ? 'selected="selected"' : '') .'>Стандартная аутентификация</option><option value="1"' . ($rutoken_authorization == 1 ? 'selected="selected"' : '') .'>Смешанная аутентификация</option><option value="2" ' . ($rutoken_authorization == 2 ? 'selected="selected"' : '') .'>Аутентификация по Рутокен Web</option></select></td>'."\n";
		echo '<tr>'."\n";
		echo '</tr>'."\n";
		// Привязан / не привязан
		// Кнопки привязать и отключить
		echo '	<th><label for="">'.__('Привязка к Рутокен Web','rutoken').'</label></th>'."\n";
		echo ' <td>' . ( $rutoken_authorization != null ? $params['image_yes_attach_text'] : $params['image_not_attach_text']) . '</td>' ."\n";
		echo '<tr>'."\n";
		echo '</tr>'."\n";
		echo '	<th></th><td>';
		
		echo '<button onclick="rutoken_attach_key_to_account(' .($rutoken_authorization != null ? '1' : '') .');return false;" id="attach_button" class="button">Привязать USB-токен</button>
		<button onclick="rutoken_remove_key_to_account();return false;" id="reattach_button" class="button"' .($rutoken_authorization != null ? '' : ' style="display:none" ' ) . '>Отключить USB-токен</button>
		</td>'."\n";
		echo '</tr>'."\n";
        echo '</table>'."\n";
    }
}
?>