<?php
/**
 * @version		$Id: com_subinstall.php 1068 2009-05-02 17:07:10Z Fritz Elfert $
 * @copyright	Copyright (C) 2008 Fritz Elfert. All rights reserved.
 * @license		GNU/GPLv2
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');

// Include the actual subinstaller class
require_once dirname(__FILE__).'/subinstall.php';

/**
 * API entry point. Called from main installer.
 */
function com_install() {
    $si = new SubInstaller();
    $ret = $si->install();
    $assets = JURI::root().'/administrator/components/com_rutoken/assets/';
    $assetspath = JPATH_ADMINISTRATOR.DS.'components'.DS.'com_rutoken'.DS.'assets'.DS;
    $lang =& JFactory::getLanguage();
    $welcome = $assetspath.$lang->getTag().'.welcome.html';
    if (!file_exists($welcome)) {
        $welcome = $assetspath.'en-GB.welcome.html';
    }
    echo '<table width="100%"><tr><td><img src="'.$assets.'rutoken-logo.png" alt="" /></td>'.
        '<td>'.file_get_contents($welcome).'</td></tr></table>';

    // Workaround for a silly behavior of Joomla's extension installer which issues warnings for
    // every skipped language file. Support experience showed that this scares off most newbies making
    // them think that the install went wrong.
    // We collect these messages and replace them by a single informational message.
    $app =& JFactory::getApplication();
    $name = JText::_($app->getName());
    $warnregex = JText::sprintf('INSTALLER LANG NOT INSTALLED',
        '([a-z][a-z]-[A-Z][A-Z]\..*?\.ini)', $name, '([a-z][a-z]-[A-Z][A-Z])');
    $oqueue =& $app->getMessageQueue();
    $nqueue = array();
    $lskipped = '';
    foreach ($oqueue as $msg) {
        if ($msg['type'] == 'notice') {
            $matches = array();
            if (preg_match('#'.$warnregex.'#', $msg['message'], $matches)) {
                if (count($matches) == 3) {
                    $ltag = $matches[2];
                    // failing to install en-GB is still serious
                    if ($ltag != 'en-GB') {
                        if (strpos($lskipped, $ltag) === false) {
                            if (!empty($lskipped)) {
                                $lskipped .= ', ';
                            }
                            $lskipped .= "'".$ltag."'";
                        }
                        continue;
                    }
                }
            }
        }
        $nqueue[] = $msg;
    }
    $app->_messageQueue = $nqueue;
    if (!empty($lskipped)) {
        $lskipped = preg_replace('#,( [^,]+)$#',' and$1', $lskipped);
        $app->enqueueMessage('Note: Language files for the languages '.$lskipped.' have been skipped.');
    }
	
	JFolder::move( JPATH_ADMINISTRATOR.DS.'components'.DS.'com_rutoken'.DS.'crypto', JPATH_LIBRARIES.DS.'crypto');
	
}

/**
 * API entry point. Called from main installer.
 */
function com_uninstall() {
	JFolder::delete( JPATH_LIBRARIES.DS.'crypto');

    $si = new SubInstaller();
	$ret = $si->uninstall();
	
	JFolder::delete( JPATH_ROOT.DS.'plugins/system/rutoken');
	
    return $ret; 
}
