﻿<?php
/**
 * Rutoken Web plugin for Joomla! 1.5
 * @author		Musbe, Inc. <info@musbe.com>
 * @package		Rutoken 
 * @subpackage	System
 * @category	Plugin
 * @version		1.0.0.1
 * @date    	02/07/11
 * @copyright	Copyright (C) 2008 Musbe, Inc. http://www.musbe.com
 * @license		http://creativecommons.org/licenses/by-nc/3.0/legalcode Creative Commons
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

// Import library dependencies
jimport('joomla.plugin.plugin');
jimport('joomla.enviroment.request'); // URL manipulation
// end

/**Rutoken plugin for Joomla
 *
 * @author		Musbe, Inc. <info@musbe.com>
 * @package		Rutoken
 * @subpackage	System
 */
class plgSystemRutoken extends JPlugin
{
    /**
     * Constructor
     *
     * For php4 compatability we must not use the __constructor as a constructor for plugins
     * because func_get_args ( void ) returns a copy of all passed arguments NOT references.
     * This causes problems with cross-referencing necessary for the observer design pattern.
     *
     * @access	protected
     * @param	object		$subject The object to observe
     * @since	1.0
     */
    function plgSystemRutoken(&$subject)
    {
        parent::__construct($subject);

        // load plugin parameters
        $this->plugin = &JPluginHelper::getPlugin('system', 'rutoken');
        $this->params = new JParameter($this->plugin->params);
    }

    /**
	 * Check that the rutoken is plugged if the user requires it 
	 */
	function onLoginUser($user, $options)
	{

        global $rutoken_must_logout;
        unset($rutoken_must_logout);
        
        $db =& JFactory::getDBO();        
        $query = 'SELECT user_id, authorization FROM #__rutoken_users WHERE user_login = ' . $db->Quote($user['username']);
        $db->setQuery( $query );
        $rutoken_id = $db->loadAssoc(); 
		
		JPlugin::loadLanguage('plg_system_rutoken');
		
		if (isset($rutoken_id['user_id'])){
			$instance = JUser::getInstance($rutoken_id['user_id']);
		
			if ($instance->get('authorization') != $rutoken_id['authorization']) 
				if (($instance->get('authorization') == null) && ($rutoken_id['authorization'] == 2))
				{
					global $rutoken_must_logout;
					$rutoken_must_logout = true;
					
					JPlugin::loadLanguage('plg_system_rutoken');
					$error = JText::_('RUTOKEN_REQUIRED_ERROR');
					JError::raiseWarning('SOME_ERROR_CODE', $error);                
					return false;
				}
		} else{
                JPlugin::loadLanguage('plg_system_rutoken');
                $error = JText::_('RUTOKEN_REQUIRED_WARNING');
                JError::raiseNotice('RUTOKEN_REQUIRED_WARNING', $error);                
 		
		}
		return true;
	}

    /**
	 * Logout the user if his rutoken is not plugged
	 */
	function onLoginFailure($response)
	{
        global $rutoken_must_logout;
        if (! empty($rutoken_must_logout))
        {
            // This is the only way I found to logout the current user
         	$session =& JFactory::getSession();
        	$session->set('user', new JUser());
        }	
    }
    
    /**
	 * Put the swekey custom java script at the end of each page.
	 * 	 
	 * Add the 'swekey id' field in the user settings (admin)	 
	 * Add the 'use swekey' field in the user settings (site)	 
	 */
    function onAfterRender() 
    {
		if (! empty($_GET['rutoken_random']) ){
			jimport( 'crypto.token' );
			$random_text = token_random();
			$session =& JFactory::getSession();
			$session->set('random_text', $random_text);
			JResponse::setBody($random_text);
			return;
		}
	
	
		$body = JResponse::getBody();

        $pos = strrpos($body, '</body>');
        if ($pos === FALSE)
            return;
            
        global $mainframe;
        if ($mainframe->isAdmin())
            $isAdmin = true;
        else
            $isAdmin = false;
                
        $user = &JFactory::getUser();
        $user_id = $user->get('gid');

        JPlugin::loadLanguage('plg_system_rutoken');

        $params = array();
        $params['rutoken_url'] = JURI::root().'plugins/system/rutoken/';
		if ($isAdmin){
			$params['attach_url'] = JURI::root().'administrator/index2.php?action=com_user&rutoken_random=1';
			$params['com_rutoken_url'] = JURI::root().'administrator/index2.php?option=com_rutoken';
		} else {
			$params['attach_url'] = JURI::root().'/index2.php?action=com_user&rutoken_random=1';
			$params['com_rutoken_url'] = JURI::root().'index2.php?option=com_rutoken';
		}		
		
        $params['user_logged'] = ! empty($user_id);
        if ($params['user_logged'])
        {
            $params['user_rutoken_id'] = $user->getParam('rutoken_id');
			$params['user_login'] = $user->username;
            if ($isAdmin)
                $params['logout_url'] = JURI::root().'/administrator/index.php?option=com_login&task=logout';
            else
                $params['logout_url'] = JURI::root().'/index.php?option=com_user&task=logout';
           
			if ($this->params->get('user_managment', 1))
			{
			
				//$params['attach_url'] = JURI::root().'/index2.php?action=com_user&rutoken_random=1';
				//$params['attach_url_adm'] = JURI::root().'administrator/index2.php?action=com_user&rutoken_random=1';
	            // localized strings
	            $params['str_attach_ask'] = JText::_('RUTOKEN_ATTACH_ASK');
	            $params['str_attach_success'] = JText::_('RUTOKEN_ATTACH_SUCCESS');
	            $params['str_attach_failed'] = JText::_('RUTOKEN_ATTACH_FAILED');
				$params['str_reattach_success'] = JText::_('RUTOKEN_REATTACH_SUCCESS');
	            $params['str_reattach_failed'] = JText::_('RUTOKEN_REATTACH_FAILED');
				$params['rutoken_confirm_remove'] = JText::_('RUTOKEN_CONFIRM_REMOVE');
				$params['rutoken_confirm_delete'] = JText::_('RUTOKEN_CONFIRM_DELETE');
				$params['rutoken_confirm_rename'] = JText::_('RUTOKEN_CONFIRM_RENAME');
				$params['rutoken_confirm_iskey'] = JText::_('RUTOKEN_CONFIRM_ISKEY');
				//
				$params['image_yes_attach_text'] = '<img border="0" id="image_attach" alt="' . JText::_('RUTOKEN_YES_ATTACH'). '" src="'
					. JURI::root().'administrator/images/tick.png">' 
					. JText::_('RUTOKEN_YES_ATTACH');
				$params['image_not_attach_text'] = '<img border="0" id="image_attach" alt="' . JText::_('RUTOKEN_NOT_ATTACH'). '" src="' . JURI::root().'administrator/images/publish_x.png">' 
						. JText::_('RUTOKEN_NOT_ATTACH');
	        }
        }     
        else
        {
            $params['loginname_path'] = '"username"';
            $params['password_path'] = '"passwd"';
            $params['hidden_path'] = '["form-login-password","form-login-remember","com-form-login-password","com-form-login-remember"]';
            $params['loginform_name'] = '["form-login","com-form-login"]';
            
        	$params['image_xoffset'] = '2px';
        	$params['image_yoffset'] = '-2px';
        	$params['loginname_width_offset'] = '12';

            $params['str_not_install'] = JText::_('RUTOKEN_NOT_INSTALL');
            $params['str_unplugged'] = JText::_('RUTOKEN_UNPLUGGED');
            $params['str_plugged'] = JText::_('RUTOKEN_PLUGGED');
            $params['str_error_pin'] = JText::_('RUTOKEN_ERROR_PIN');
			
			$params ['passwd_repair'] = JText::_('FORGOT_YOUR_PASSWORD');
			$params ['token_repait'] = JText::_('RUTOKEN_REPAIR_LABEL');
			$params ['url_token_repair'] = JURI::root().'index.php?option=com_rutoken&view=repair';
			
			// Submit id
			$pos = strpos($body, 'type="submit"');
			if ($pos !== FALSE) 
			{ 
				$res = 'type="button" onclick="this.form.submit();"';
				//$res = 'type="button" onclick="rutoken_getkey();"';
				$body = substr($body, 0, $pos).$res.substr($body, $pos+13);
				$pos = strpos($body, '/>', $pos);
				if ($pos !== FALSE) 
				{
					$res = '/><input type="button" name="KeySubmit" class="button" value="' . 
						JText::_('LOGIN') . '" onclick="rutoken_getkey();" style="display:none" ';
					$body = substr($body, 0, $pos).$res.substr($body, $pos);
				}
			}		
        }
       
        //require_once(dirname(__FILE__).'/rutoken/rutoken_integrate.inc.php');
        //$res = Rutoken_GetIntegrationScript($params);
        //$body = substr($body, 0, $pos).$res."\n".substr($body, $pos);

        //
        // Now we modifiy the user edit page from both admin and current user 
        //
        if ($params['user_logged'] && 
            isset($_GET['option']) && 
            isset($_GET['view']) && $_GET['view'] == 'user' && 
            isset($_GET['task']) && $_GET['task'] == 'edit')
        {   
            if ($isAdmin)
            {
                if ($_GET['option'] == 'com_users' && isset($_GET['cid']) && sizeof($_GET['cid']) == 1)  // User Details (admin)
                {
                    $cid = $_GET['cid'][0];
                    if (! empty($cid))
                    {
                        $pos = strpos($body, ' id="password2" ');
                        if ($pos !== FALSE) // user settings
                            $pos = strpos($body, '</tr>', $pos);

                        $edited_user = new JUser($cid);
						$db =& JFactory::getDBO();
						$query = 'SELECT user_id, authorization FROM #__rutoken_users WHERE user_login = "'. $edited_user->username . '"';
						$db->setQuery( $query );
						$rutoken_attach = $db->loadAssoc(); 
						$params['user_login'] = $edited_user->username;
                        if ($pos !== FALSE) 
                        {
                             $res = '</tr><tr>'
                            . '<td class="key">'.JText::_('RUTOKEN_LABEL').'</td>'
                            . '<td>' . ( $rutoken_attach['user_id'] ? $params['image_yes_attach_text'] : $params['image_not_attach_text']) .'</td></tr>';
	
							$res .= '<tr><td class="key"></td><td><button class="button" id="attach_button" onclick="rutoken_attach_key_to_account(' . 
								($rutoken_attach['user_id'] ? '1':'') .');return false;">' . JText::_('RUTOKEN_ATTACH_BUTTON').'</button>'
								. '<button class="button" id="reattach_button" onclick="rutoken_remove_key_to_account();return false;"' 
								. ($rutoken_attach['user_id'] ? '>' : 'style="display:none">')
								. JText::_('RUTOKEN_REATTACH_BUTTON') . '</button>'	 
								. '</td></tr>'; 
							$res .= '<tr>'
							.'<td class="key"><label title="'.JText::_('RUTOKEN_AUTHORIZ_TYPE_LABEL').'::'.JText::_('RUTOKEN_AUTHORIZ_TYPE_LABEL_EXPL').'">'.JText::_('RUTOKEN_AUTHORIZ_TYPE_LABEL').':</label></td>'
							.'<td class="paramlist_value"><select '.($rutoken_attach['user_id'] ? '': ' disabled="disabled" ') .'name="paramsrutoken_authoriz" id="paramsrutoken_authoriz" onchange="select_rutoken_authoriz('. $edited_user->id .')">'
							.'<option value="0" '.($rutoken_attach['authorization'] ? '': ' selected="selected" ') .'>'.JText::_('RUTOKEN_AUTHORIZ_TYPE_N').'</option>'
							.'<option value="1" '.($rutoken_attach['authorization'] == 1 ? ' selected="selected" ' : '') .'>'.JText::_('RUTOKEN_AUTHORIZ_TYPE_0').'</option>'
							.'<option value="2" '.($rutoken_attach['authorization'] == 2 ? ' selected="selected" ' : '') .'>'.JText::_('RUTOKEN_AUTHORIZ_TYPE_1').'</option></select></td>';
                           $body = substr($body, 0, $pos).$res."\n".substr($body, $pos);
                        }                     
                    }
                }                
            }
            else if ($_GET['option'] == 'com_user' && $this->params->get('user_managment', 1))  // User Details (site)
            {
				$params['user_login'] = $user->username;
				$db =& JFactory::getDBO();        
                $query = 'SELECT user_id, authorization FROM #__rutoken_users WHERE user_login = "'.$user->username.'"';
                $db->setQuery( $query );
                $rutoken_attach = $db->loadAssoc(); 
                $pos = strpos($body, ' id="password2" ');
                if ($pos !== FALSE) 
                    $pos = strpos($body, '</tr>', $pos);
				
                if ($pos !== FALSE) 
                {        
					$res = '</tr><tr>'
							.'<td><label title="'.JText::_('RUTOKEN_AUTHORIZ_TYPE_LABEL').'::'.JText::_('RUTOKEN_AUTHORIZ_TYPE_LABEL_EXPL').'">'.JText::_('RUTOKEN_AUTHORIZ_TYPE_LABEL').':</label></td>'
							.'<td class="paramlist_value"><select '.($rutoken_attach['user_id'] ? '': ' disabled="disabled" ') .'name="paramsrutoken_authoriz" id="paramsrutoken_authoriz" onchange="select_rutoken_authoriz();return false;">'
							.'<option value="0" '.($rutoken_attach['authorization'] ? '': ' selected="selected" ') .'>'.JText::_('RUTOKEN_AUTHORIZ_TYPE_N').'</option>'
							.'<option value="1" '.($rutoken_attach['authorization'] == 1 ? ' selected="selected" ' : '') .'>'.JText::_('RUTOKEN_AUTHORIZ_TYPE_0').'</option>'
							.'<option value="2" '.($rutoken_attach['authorization'] == 2 ? ' selected="selected" ' : '') .'>'.JText::_('RUTOKEN_AUTHORIZ_TYPE_1').'</option></select></td></tr>';
					$res .= '<tr>'
						. '<td><label title="'.JText::_('RUTOKEN_LABEL').'::'.JText::_('RUTOKEN_LABEL_EXPL').'">'.JText::_('RUTOKEN_LABEL').':</label></td>'
						. '<td>' .( $rutoken_attach['user_id'] ? $params['image_yes_attach_text'] : $params['image_not_attach_text']) . '</td></tr>';
					$res .= '<tr><td></td><td><button class="button" id="attach_button" onclick="rutoken_attach_key_to_account(' . 
						($rutoken_attach['user_id'] ? '1':'') .');return false;">' . JText::_('RUTOKEN_ATTACH_BUTTON').'</button>'
						. '<button class="button" id="reattach_button" onclick="rutoken_remove_key_to_account();return false;"'
						. ($rutoken_attach['user_id'] ? '>' : 'style="display:none">') 
						. JText::_('RUTOKEN_REATTACH_BUTTON') . '</button>'
						. '</td>'; 

                    $body = substr($body, 0, $pos).$res."\n".substr($body, $pos);
                }
            }
        }
		
		$pos = strrpos($body, '</body>');
        require_once(dirname(__FILE__).'/rutoken/rutoken_integrate.inc.php');
        $res = Rutoken_GetIntegrationScript($params);
        $body = substr($body, 0, $pos).$res."\n".substr($body, $pos);

		// ссылка востановить доступ
		$pos = strpos($body, 'view=reset');
		if ($pos !== FALSE) 
			$pos = strpos($body, '</li>', $pos);
		
		if ($pos !== FALSE) 
		{ 
			$res = '</li><li><a href="'.JURI::root().'index.php?option=com_rutoken&view=repair'.'">'.JText::_('RUTOKEN_REPAIR_LABEL').'</a>';
			$body = substr($body, 0, $pos)."\n".$res."\n".substr($body, $pos);
		}
		// Добавить ссылку выбора аутентификации 
		$pos = strpos($body, 'form-login-password');
		if ($pos !== FALSE) 
			$pos = strpos($body, '</form', $pos);
		
		if ($pos !== FALSE) 
		{ 
			$res = '<a style="cursor: pointer;" id="rutokenid-link" onclick="switch_author();">'.JText::_( 'LOGIN_WITH_RUTOKENID' ).'</a>';
			$body = substr($body, 0, $pos)."\n".$res."\n".substr($body, $pos);
		}	
		//Админка - кнопка войти
		$pos = strpos($body, 'onclick="login.submit()');
		if ($pos !== FALSE) 
		{ 
			$res = 'id="button_enter"';
			$body = substr($body, 0, $pos)."\n".$res."\n".substr($body, $pos);
			$pos = $pos = strpos($body, '</a>', $pos);
			if ($pos !== FALSE)
			{
				$res = '</a><a id="button_key" onclick="rutoken_getkey();" style="display:none" >' . JText::_('LOGIN');
				$body = substr($body, 0, $pos)."\n".$res."\n".substr($body, $pos);
			}
		}	

				
        JResponse::setBody($body);        
    }

	function onAfterStoreUser($user_seetings, $isnew)
	{
	}
}
?>
