var g_RutokenPlugin = null;
var rutoken_http = createObject();
var rutoken_random_text = '';
var tsign = null;
var ukey = null;
var user = null;
var hostname_str = '';
// -------------------------------------------------------------------
function createObject() {
	var request_type;
	var browser = navigator.appName;
	if (browser == "Microsoft Internet Explorer") {
		request_type = new ActiveXObject("Microsoft.XMLHTTP");
	} else {
		request_type = new XMLHttpRequest();
	}
	return request_type;
}
// -------------------------------------------------------------------
/**
 * Создать Объект работы с Рутокеном, если он не создан
 * 
 * @return Возвращает указатель на созаданый объект
 */
function Rutoken_Plugin() {
	try {
		
		g_RutokenPlugin = document.getElementById("cryptoPlugin");
		if (g_RutokenPlugin != null)
			return g_RutokenPlugin;
		
		var x = document.createElement('object');
		x.setAttribute('type', 'application/x-rutoken');
		x.setAttribute('id', 'cryptoPlugin');
		x.setAttribute('width', '0');
		x.setAttribute('height', '0');
		x.style.dislay = 'none';

		if (document.body != null) {
			try {
				document.body.appendChild(x);
			} catch (e) {
				document.body.insertBefore(x, document.body.firstChild);
			}
		}

		g_RutokenPlugin = document.getElementById("cryptoPlugin");
		return g_RutokenPlugin;

	} catch (e) {
		alert("Rutoken_Plugin " + e);
		g_RutokenPlugin = null;
	}
	return null;
}

// -------------------------------------------------------------------
/**
 * Проверка установки плагина для работы с Rutoken Web
 * 
 * @return Возвращает true если плагин установлен
 */
function Rutoken_Installed() {
	if (Rutoken_Plugin() != null)
		return true;
	else
		return false;
}

// -------------------------------------------------------------------
/**
 * 
 * @return Возаращает true если плагин работы с Rutoken web загружен
 */
function Rutoken_Loaded() {
	try {
		if (!Rutoken_Installed())
			return false;
	} catch (e) {
		return false;
	}
	return true;
}

// -------------------------------------------------------------------
//
/**
 * Проверить наличие и работоспособность устройства Rutoken. 
 * 
 * @return true - токен подключен, false - не подключен
 */
function Rutoken_IsPresent() {
	try {
		if (Rutoken_Plugin().rtwIsTokenPresentAndOK())
			return true;
	} catch (e) {
		return false;
	}
}

// -------------------------------------------------------------------
/**
 * Запрос PIN-кода
 * 
 * @return
 */
function Rutoken_GetPin() {
	if (!Rutoken_Plugin().rtwIsUserLoggedIn()) {
		Rutoken_Plugin().rtwUserLoginDlg();
	}
}
/**
 * Подписать сообщение
 * 
 * @param token_sign	- объект хранения подписи
 * @param token_login	- имя контейнера хранения ключей
 * @param random_text	- сообщение
 * @return
 */
function Rutoken_SingKey(user_in, url_random, tsign_in){
	var current_user = '';
	logstr=user;
	tsign = tsign_in;
	user = user_in;
	if (logstr=="none"){
		alert("Выберите учетную запись на токене.");
	}else{
		if ((current_user==logstr)&&(rutoken_random_text!="")){
			Rutoken_Reply();	
		}else{
			current_user=logstr;
			nocache = Math.random();
			rutoken_http.open('get', url_random+'&nocache='+nocache);
			rutoken_http.onreadystatechange = Rutoken_Reply;
			rutoken_http.send(null);
		}
	}
}
/**
 * Запрос случайной последовательности
 * @param url_random
 */
function Rutoken_GetRandomHash(url_random){
	var nocache = Math.random();
	rutoken_http.open('get', url_random +'&nocache='+nocache);
	rutoken_http.onreadystatechange = Rutoken_Reply;
	rutoken_http.send(null);
}
/**
 * 
 * @return
 */
function Rutoken_Reply()
{
	if (rutoken_http.readyState == 4){ 
		if (rutoken_http.readyState == 4){ 
			rutoken_random_text = rutoken_http.responseText.substring(0,64);
			Rutoken_Sing();
		}
	}
}
/**
 * Подписать сообщение 
 *
 * @return
 */
function Rutoken_Sing(){
	try {		
		if (!Rutoken_Plugin().rtwIsUserLoggedIn()) {
			Rutoken_Plugin().rtwUserLoginDlg();
		}
		if (Rutoken_Plugin().rtwIsUserLoggedIn()) {
			// Подписываем
			tsign.value = Rutoken_Plugin().rtwSign(user, rutoken_random_text);
			// Отключаем пользовательский режим
			Rutoken_Plugin().rtwLogout();
			if (tsign.value) {
				if (document.getElementById('com-form-login'))
					tform = document.getElementById('com-form-login');
				if (document.getElementById('form-login'))
					tform = document.getElementById('form-login');
				tform.submit();
				return true;
			}
			else
				return false;
		} else {
			alert(RUTOKEN_STR_ERROR_PIN);
			return false;
		}
	} catch (e) {
		Rutoken_Plugin().rtwLogout();
		return false;
	}	
}
/**
 * Генерация пары ключей
 * 
 * @param ulogin	- Логин ползователя
 * @return
 */
function Rutoken_GetKey(ulogin)
{
	try
	{
		if (Rutoken_Plugin().rtwIsUserLoggedIn()) {	
			var key = Rutoken_Plugin().rtwGenKeyPair(ulogin + '#%#' + hostname_str);
			var rkey = Rutoken_Plugin().rtwGetPublicKey('repair key');
			if (key){
				var xkey = key.substring(0,64);
				var ykey = key.substring(64);
				if (rkey){
					var rxkey = rkey.substring(0,64);
					var rykey = rkey.substring(64);
					var key_url = "&user_xkey="+xkey+"&user_ykey="+ykey+"&r_xkey="+rxkey+"&r_ykey="+rykey;
					return key_url;
				}
			}
		}
		return false;
	} catch (e) {
		Rutoken_Plugin().rtwLogout();
		return false;
	}
}
/**
 * Формирование ключей при восстановлении
 *
 */
function Rutoken_Repair(user, url_repair, tsign_in, ukey_in)
{
	var current_user="";
	logstr=user;
	tsign = tsign_in;
	ukey = ukey_in;
	if (logstr=="none"){
		alert(input_login);
	}else{
		if ((current_user==logstr)&&(rutoken_random_text!="")){
			Rutoken_ReplyRepair;	
		}else{
			current_user=logstr;
			nocache = Math.random();
			rutoken_http.open('get', url_repair+'&nocache='+nocache);
			rutoken_http.onreadystatechange = Rutoken_ReplyRepair;
			rutoken_http.send(null);
		}
	}
}
/**
 * 
 * @return
 */
function Rutoken_ReplyRepair()
{
	if (rutoken_http.readyState == 4){ 
		if (rutoken_http.readyState == 4){ 
			rutoken_random_text = rutoken_http.responseText.substring(0,64);
			Rutoken_SingRepair();
		}
	}
}
/**
 * 
 * @return
 */
function Rutoken_SingRepair()
{
	if (!Rutoken_Plugin().valid){
		alert('Не установлен плагин для работы с токеном');
		return;
	}
	usr_key = ukey.value.replace(/-/g, "")
	tsign.value = Rutoken_Plugin().rtwRepair(usr_key, rutoken_random_text);
	if (tsign.value){
			ukey.value="key";
			tform = document.getElementById('com-form-login');
			
			tform.submit();
	} else {
		alert("Ошибка при создании подписи.");
	}
}
/**
 * Удаление контейнера
 * @return
 */
function Rutoken_Remove(ulogin)
{
	try{
		if (Rutoken_Plugin().rtwIsUserLoggedIn()) {	
			var r = Rutoken_Plugin().rtwDestroyContainer(ulogin + '#%#' + hostname_str);
			if (r)
				return true;			
		}
		return false;
	}
	catch(e){
		Rutoken_Plugin().rtwLogout();
		return false;
	}
}
/**
 * Поиск контейнера
 * @return
 */
function Rutoken_Search(ulogin)
{
	var login = ulogin + '#%#' + hostname_str;
	for ( var i = 0; i < Rutoken_Plugin().rtwGetNumberOfContainers(); i++) {
		if (login == Rutoken_Plugin().rtwGetContainerName(i))
			return true;	
	}
	return false;
}
/**
 * Закрыть пользовательский режим
 * @return
 */
function Rutoken_Logout()
{
	Rutoken_Plugin().rtwLogout();
}