/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.crypto;

import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.ExemptionMechanism;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import ru.rutoken.crypto.CipherConst;
import ru.rutoken.crypto.CipherInterface;
import ru.rutoken.jrt11.impl.GostCipher11;
import ru.rutoken.security.Cleanable;
import ru.rutoken.security.Cleaner;
import ru.rutoken.security.spec.ParamRandom;
import ru.rutoken.tools.Arrays;

public class Cipher
implements CipherConst,
Cleanable {
    public static final char SEPARATOR = '/';
    public static final String STR_SEPARATOR = "/";
    protected final CipherInterface implementation;
    protected String transformation;
    protected byte[] tempArray;

    public Cipher(CipherInterface cipherInterface) {
        this.implementation = cipherInterface;
    }

    public static Cipher getInstance(String string) throws NoSuchAlgorithmException, NoSuchPaddingException {
        String[] stringArray = Cipher.getTransformation(string);
        if (stringArray == null) {
            throw new NoSuchAlgorithmException();
        }
        if (!"rt11GOST28147".equalsIgnoreCase(stringArray[0])) {
            throw new NoSuchAlgorithmException();
        }
        GostCipher11 gostCipher11 = new GostCipher11();
        if (stringArray.length > 1 && stringArray[1] != null) {
            gostCipher11.setMode(Cipher.getMode(stringArray[1]));
        }
        if (stringArray.length > 2 && stringArray[2] != null) {
            gostCipher11.setPadding(Cipher.getPadding(stringArray[2]));
        }
        return new Cipher(gostCipher11);
    }

    public static Cipher getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
        return Cipher.getInstance(string);
    }

    public static Cipher getInstance(String string, Provider provider) throws NoSuchAlgorithmException, NoSuchPaddingException {
        return Cipher.getInstance(string);
    }

    public Provider getProvider() {
        return null;
    }

    public String getAlgorithm() {
        return this.implementation.getAlgorithmName();
    }

    public int getBlockSize() {
        return this.implementation.getBlockSize();
    }

    public void clean() {
        if (this.tempArray != null) {
            Arrays.clean(this.tempArray);
            this.tempArray = null;
        }
        Cleaner.clean(this.implementation);
    }

    public static String[] splitTransformation(String string) throws NoSuchAlgorithmException {
        int n;
        if (string == null || string.length() == 0) {
            throw new NoSuchAlgorithmException("No transformation given");
        }
        int n2 = string.length();
        int n3 = string.indexOf(47);
        int n4 = n = n3 == -1 ? -1 : string.indexOf(47, n3 + 1);
        if (n != -1 && string.indexOf(47, n + 1) != -1) {
            throw new NoSuchAlgorithmException("Unknown format:" + string);
        }
        String[] stringArray = new String[3];
        if (n3 == -1) {
            stringArray[0] = string;
            stringArray[1] = "";
            stringArray[2] = "";
        } else {
            stringArray[0] = string.substring(0, n3);
            if (n == -1) {
                stringArray[1] = string.substring(n3 + 1, n2);
                stringArray[2] = "";
            } else {
                stringArray[1] = string.substring(n3 + 1, n);
                stringArray[2] = string.substring(n + 1, n2);
            }
        }
        return stringArray;
    }

    public static String[] getTransformation(String string) throws NoSuchAlgorithmException {
        String[] stringArray = Cipher.splitTransformation(string);
        if (stringArray[1] == null || stringArray[1].length() == 0) {
            stringArray[1] = "CFB";
        }
        if (stringArray[2] == null || stringArray[2].length() == 0) {
            stringArray[2] = "NO_PADDING";
        }
        return stringArray;
    }

    public int getOutputSize(int n) {
        return this.implementation.getOutputSize(n);
    }

    public byte[] getIV() {
        return this.implementation.getIV();
    }

    public AlgorithmParameters getParameters() {
        return null;
    }

    public ExemptionMechanism getExemptionMechanism() {
        return null;
    }

    public void init(int n, Key key) throws InvalidKeyException {
        try {
            this.init(n, key, (AlgorithmParameterSpec)null, null);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException);
        }
    }

    public void init(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.init(n, key, (AlgorithmParameterSpec)null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException);
        }
    }

    public void init(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.init(n, key, algorithmParameterSpec, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.implementation.setOperationMode(n);
        if (algorithmParameterSpec != null) {
            this.implementation.setParameter(algorithmParameterSpec);
        }
        if (secureRandom != null) {
            ParamRandom paramRandom = null;
            try {
                paramRandom = new ParamRandom(secureRandom);
                this.implementation.setParameter(paramRandom);
            }
            finally {
                if (paramRandom != null) {
                    Cleaner.clean(paramRandom);
                }
            }
        }
        this.implementation.init(key);
    }

    public void init(int n, Key key, AlgorithmParameters algorithmParameters) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.init(n, key, algorithmParameters, null);
    }

    public void init(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.init(n, key, (AlgorithmParameterSpec)null, secureRandom);
    }

    public void init(int n, Certificate certificate) throws InvalidKeyException {
        this.init(n, certificate, null);
    }

    public void init(int n, Certificate certificate, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.init(n, (Key)certificate.getPublicKey(), (AlgorithmParameterSpec)null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException);
        }
    }

    public byte[] update(byte[] byArray) {
        return this.update(byArray, 0, byArray.length);
    }

    public byte[] update(byte[] byArray, int n, int n2) {
        int n3;
        byte[] byArray2 = new byte[this.implementation.getOutputSize(n2)];
        try {
            n3 = this.implementation.update(byArray, n, n2, byArray2, 0);
        }
        catch (ShortBufferException shortBufferException) {
            throw new ProviderException(shortBufferException);
        }
        if (n3 != byArray2.length) {
            byte[] byArray3 = new byte[n3];
            System.arraycopy(byArray2, 0, byArray3, 0, n3);
            byArray2 = byArray3;
        }
        return byArray2;
    }

    public int update(byte[] byArray, int n, int n2, byte[] byArray2) throws ShortBufferException {
        return this.implementation.update(byArray, n, n2, byArray2, 0);
    }

    public int update(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        return this.implementation.update(byArray, n, n2, byArray2, n3);
    }

    public int update(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws ShortBufferException {
        if (byteBuffer == null || byteBuffer2 == null) {
            throw new IllegalArgumentException("Buffers must not be null");
        }
        if (byteBuffer == byteBuffer2) {
            throw new IllegalArgumentException("Input and output buffers must not be the same object, consider using buffer.duplicate()");
        }
        if (byteBuffer2.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        try {
            return this.bufferCrypt(byteBuffer, byteBuffer2, true);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new ProviderException("Internal error in update()");
        }
        catch (BadPaddingException badPaddingException) {
            throw new ProviderException("Internal error in update()");
        }
    }

    private int bufferCrypt(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, boolean bl) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int n;
        byte[] byArray;
        int n2;
        if (byteBuffer == null || byteBuffer2 == null) {
            throw new NullPointerException("Input and output buffers must not be null");
        }
        int n3 = byteBuffer.position();
        int n4 = byteBuffer.limit();
        if (bl && n2 == 0) {
            return 0;
        }
        int n5 = this.implementation.getOutputSize(n2);
        if (byteBuffer2.remaining() < n5) {
            throw new ShortBufferException("Need at least " + n5 + " bytes of space in output buffer");
        }
        boolean bl2 = byteBuffer.hasArray();
        boolean bl3 = byteBuffer2.hasArray();
        if (bl2 && bl3) {
            byte[] byArray2 = byteBuffer.array();
            int n6 = byteBuffer.arrayOffset() + n3;
            byte[] byArray3 = byteBuffer2.array();
            int n7 = byteBuffer2.position();
            int n8 = byteBuffer2.arrayOffset() + n7;
            int n9 = bl ? this.implementation.update(byArray2, n6, n2, byArray3, n8) : this.doFinal(byArray2, n6, n2, byArray3, n8);
            byteBuffer.position(n4);
            byteBuffer2.position(n7 + n9);
            return n9;
        }
        if (!bl2 && bl3) {
            int n10;
            int n11 = byteBuffer2.position();
            byte[] byArray4 = byteBuffer2.array();
            int n12 = byteBuffer2.arrayOffset() + n11;
            byte[] byArray5 = new byte[Arrays.getTempArraySize(n2)];
            int n13 = 0;
            for (n2 = n4 - n3; n2 > 0; n2 -= n10) {
                n10 = Math.min(n2, byArray5.length);
                byteBuffer.get(byArray5, 0, n10);
                int n14 = bl || n2 != n10 ? this.implementation.update(byArray5, 0, n10, byArray4, n12) : this.doFinal(byArray5, 0, n10, byArray4, n12);
                n13 += n14;
                n12 += n14;
            }
            byteBuffer2.position(n11 + n13);
            return n13;
        }
        if (bl2) {
            byArray = byteBuffer.array();
            n = byteBuffer.arrayOffset() + n3;
        } else {
            byArray = new byte[Arrays.getTempArraySize(n2)];
            n = 0;
        }
        byte[] byArray6 = new byte[Arrays.getTempArraySize(n5)];
        int n15 = byArray6.length;
        int n16 = 0;
        boolean bl4 = false;
        while (n2 > 0) {
            int n17 = Math.min(n2, n15);
            if (!bl2 && !bl4) {
                byteBuffer.get(byArray, 0, n17);
                n = 0;
            }
            try {
                int n18 = bl || n2 != n17 ? this.implementation.update(byArray, n, n17, byArray6, 0) : this.doFinal(byArray, n, n17, byArray6, 0);
                bl4 = false;
                n += n17;
                n2 -= n17;
                byteBuffer2.put(byArray6, 0, n18);
                n16 += n18;
            }
            catch (ShortBufferException shortBufferException) {
                if (bl4) {
                    throw (ProviderException)new ProviderException("Could not determine buffer size").initCause(shortBufferException);
                }
                bl4 = true;
                int n19 = this.implementation.getOutputSize(n17);
                byArray6 = new byte[n19];
            }
        }
        byteBuffer.position(n4);
        return n16;
    }

    public byte[] doFinal() throws IllegalBlockSizeException, BadPaddingException {
        byte[] byArray = new byte[this.implementation.getOutputSize(0)];
        int n = 0;
        try {
            n = this.implementation.doFinal(byArray, 0);
        }
        catch (ShortBufferException shortBufferException) {
            throw new ProviderException(shortBufferException);
        }
        if (n != byArray.length) {
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            byArray = byArray2;
        }
        this.implementation.reset();
        return byArray;
    }

    public int doFinal(byte[] byArray, int n) throws IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        int n2 = this.implementation.doFinal(byArray, n);
        this.implementation.reset();
        return n2;
    }

    public byte[] doFinal(byte[] byArray) throws IllegalBlockSizeException, BadPaddingException {
        int n;
        int n2;
        int n3 = this.implementation.getOutputSize(byArray.length);
        byte[] byArray2 = new byte[n3];
        try {
            n2 = this.implementation.update(byArray, 0, byArray.length, byArray2, 0);
            n = this.implementation.doFinal(byArray2, n2);
        }
        catch (ShortBufferException shortBufferException) {
            throw new ProviderException(shortBufferException);
        }
        if (n3 != n2 + n) {
            byte[] byArray3 = new byte[n2 + n];
            System.arraycopy(byArray2, 0, byArray3, 0, byArray3.length);
            byArray2 = byArray3;
        }
        this.implementation.reset();
        return byArray2;
    }

    public byte[] doFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        int n3;
        int n4;
        int n5 = this.implementation.getOutputSize(n2);
        byte[] byArray2 = new byte[n5];
        try {
            n4 = this.implementation.update(byArray, n, n2, byArray2, 0);
            n3 = this.implementation.doFinal(byArray2, n4);
        }
        catch (ShortBufferException shortBufferException) {
            throw new ProviderException(shortBufferException);
        }
        if (n5 != n3 + n4) {
            byte[] byArray3 = new byte[n3 + n4];
            System.arraycopy(byArray2, 0, byArray3, 0, byArray3.length);
            byArray2 = byArray3;
        }
        this.implementation.reset();
        return byArray2;
    }

    public int doFinal(byte[] byArray, int n, int n2, byte[] byArray2) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int n3 = this.implementation.update(byArray, n, n2, byArray2, 0);
        int n4 = this.implementation.doFinal(byArray2, n3);
        this.implementation.reset();
        return n3 + n4;
    }

    public int doFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int n4 = this.implementation.update(byArray, n, n2, byArray2, n3);
        int n5 = this.implementation.doFinal(byArray2, n3 + n4);
        this.implementation.reset();
        return n4 + n5;
    }

    public int doFinal(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (byteBuffer == null || byteBuffer2 == null) {
            throw new IllegalArgumentException("Buffers must not be null");
        }
        if (byteBuffer == byteBuffer2) {
            throw new IllegalArgumentException("Input and output buffers must not be the same object, consider using buffer.duplicate()");
        }
        if (byteBuffer2.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        int n = this.bufferCrypt(byteBuffer, byteBuffer2, false);
        this.implementation.reset();
        return n;
    }

    public byte[] wrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        return this.implementation.wrap(key);
    }

    public Key unwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        return this.implementation.unwrap(byArray, string, n);
    }

    public static int getMaxAllowedKeyLength(String string) throws NoSuchAlgorithmException {
        return Integer.MAX_VALUE;
    }

    public static AlgorithmParameterSpec getMaxAllowedParameterSpec(String string) throws NoSuchAlgorithmException {
        return null;
    }

    public static int getMode(String string) {
        for (int i = 0; i < MODES.length; ++i) {
            if (!string.equals(MODES[i])) continue;
            return i;
        }
        throw new IllegalArgumentException();
    }

    public static String getMode(int n) {
        if (n < 0 || n > MODES.length) {
            throw new IllegalArgumentException();
        }
        return MODES[n];
    }

    public static int getPadding(String string) {
        for (int i = 0; i < PADDINGS.length; ++i) {
            if (!string.equals(PADDINGS[i])) continue;
            return i;
        }
        throw new IllegalArgumentException();
    }

    public static String getPadding(int n) {
        if (n < 0 || n > PADDINGS.length) {
            throw new IllegalArgumentException();
        }
        return PADDINGS[n];
    }
}

