/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;
import ru.rutoken.crypto.KeyGenInterface;
import ru.rutoken.jrt11.impl.GostKeyGen11;
import ru.rutoken.security.Cleanable;
import ru.rutoken.security.Cleaner;
import ru.rutoken.security.spec.ParamKeySize;
import ru.rutoken.security.spec.ParamRandom;
import ru.rutoken.security.spec.gost.CryptParamFactory;

public class KeyGenerator
implements Cleanable {
    public static final char SEPARATOR = '/';
    public static final String STR_SEPARATOR = "/";
    protected final KeyGenInterface implementation;

    public KeyGenerator(KeyGenInterface keyGenInterface) {
        this.implementation = keyGenInterface;
    }

    public static KeyGenerator getInstance(String string) throws NoSuchAlgorithmException {
        Object object;
        String string2 = null;
        if (string.indexOf(47) != -1) {
            object = string.split(STR_SEPARATOR);
            string = object[0];
            string2 = object[1];
        }
        if (!"rt11GOST28147".equalsIgnoreCase(string)) {
            throw new NoSuchAlgorithmException();
        }
        object = new GostKeyGen11();
        if (string2 != null) {
            try {
                object.setParameter(CryptParamFactory.getInstance(string2));
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                NoSuchAlgorithmException noSuchAlgorithmException = new NoSuchAlgorithmException();
                noSuchAlgorithmException.initCause(invalidAlgorithmParameterException);
                throw noSuchAlgorithmException;
            }
        }
        return new KeyGenerator((KeyGenInterface)object);
    }

    public static KeyGenerator getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        return KeyGenerator.getInstance(string);
    }

    public static KeyGenerator getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        return KeyGenerator.getInstance(string);
    }

    public Provider getProvider() {
        return null;
    }

    public String getAlgorithm() {
        return this.implementation.getAlgorithmName();
    }

    public void clean() {
        Cleaner.clean(this.implementation);
    }

    public void init(SecureRandom secureRandom) {
        try {
            this.implementation.setParameter(new ParamRandom(secureRandom));
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new ProviderException(invalidAlgorithmParameterException);
        }
    }

    public void init(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.implementation.setParameter(algorithmParameterSpec);
    }

    public void init(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.implementation.setParameter(new ParamRandom(secureRandom));
        this.implementation.setParameter(algorithmParameterSpec);
    }

    public void init(int n) {
        try {
            this.implementation.setParameter(new ParamKeySize(n));
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new ProviderException(invalidAlgorithmParameterException);
        }
    }

    public void init(int n, SecureRandom secureRandom) {
        try {
            this.implementation.setParameter(new ParamRandom(secureRandom));
            this.implementation.setParameter(new ParamKeySize(n));
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new ProviderException(invalidAlgorithmParameterException);
        }
    }

    public SecretKey generateKey() {
        return this.implementation.generateKey();
    }

    public String toString() {
        return this.implementation.toString();
    }
}

