/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.jrt11;

import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import ru.rutoken.jrt11.Config;
import ru.rutoken.jrt11.TokenException;
import ru.rutoken.jrt11.level11.Context;
import ru.rutoken.jrt11.level11.P11Exception;
import ru.rutoken.jrt11.level11.Session;
import ru.rutoken.jrt11.level11.Token;
import ru.rutoken.security.Cleanable;
import ru.rutoken.security.spec.ParamPin;
import ru.rutoken.tools.Arrays;

public class SessionFactory
implements AlgorithmParameterSpec,
Cleanable {
    protected Config config = null;
    protected Context context = null;
    protected Token token = null;
    protected Session session = null;
    protected char[] pin = null;
    protected static ArrayList<Session> sessionList = new ArrayList();

    public SessionFactory() {
    }

    public SessionFactory(AlgorithmParameterSpec algorithmParameterSpec) {
        this.setParameter(algorithmParameterSpec);
    }

    public void reset() {
        this.clean();
        this.pin = null;
        this.session = null;
        this.token = null;
        this.context = null;
        this.config = null;
    }

    public boolean setParameter(AlgorithmParameterSpec algorithmParameterSpec) {
        boolean bl = true;
        if (algorithmParameterSpec instanceof ParamPin) {
            this.pin = ((ParamPin)algorithmParameterSpec).getPin();
        } else if (algorithmParameterSpec instanceof Session) {
            this.session = (Session)algorithmParameterSpec;
        } else if (algorithmParameterSpec instanceof Token) {
            this.token = (Token)algorithmParameterSpec;
        } else if (algorithmParameterSpec instanceof Context) {
            this.context = (Context)algorithmParameterSpec;
        } else if (algorithmParameterSpec instanceof Config) {
            this.config = (Config)algorithmParameterSpec;
        } else {
            bl = false;
        }
        return bl;
    }

    public AlgorithmParameterSpec getSession() {
        try {
            Session session = this.session;
            if (session == null) {
                Token token = (Token)this.getToken();
                session = token.createSession();
            }
            if (this.pin != null) {
                session.login(this.pin);
            }
            return session;
        }
        catch (P11Exception p11Exception) {
            throw new TokenException(p11Exception);
        }
    }

    public AlgorithmParameterSpec getToken() {
        try {
            Token token = this.token;
            if (token == null) {
                Context context = (Context)this.getContext();
                token = context.getToken();
            }
            if (this.pin != null) {
                token.setPin(this.pin);
            }
            return token;
        }
        catch (P11Exception p11Exception) {
            throw new TokenException(p11Exception);
        }
    }

    public AlgorithmParameterSpec getContext() {
        try {
            return this.context == null ? new Context(this.config) : this.context;
        }
        catch (P11Exception p11Exception) {
            throw new TokenException(p11Exception);
        }
    }

    public void clean() {
        if (this.pin != null) {
            Arrays.clean(this.pin);
            this.pin = null;
        }
    }

    public static synchronized void addSession(Session session) {
    }

    public static synchronized void removeSession(Session session) {
    }

    public static synchronized void closeAll() {
    }
}

