/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.jrt11.impl;

import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import ru.rutoken.security.Cleanable;
import ru.rutoken.security.Cleaner;
import ru.rutoken.security.DigestInterface;

public class DigestWrapper
implements DigestInterface,
Cleanable {
    public final String ALGORITHM;
    protected final MessageDigest digest;

    public DigestWrapper(String string) throws NoSuchAlgorithmException {
        this.ALGORITHM = string;
        this.digest = MessageDigest.getInstance(this.ALGORITHM);
    }

    public String getAlgorithmName() {
        return this.ALGORITHM;
    }

    public int getDigestLength() {
        return 0;
    }

    public long getProcessedLength() {
        return 0L;
    }

    public AlgorithmParameterSpec getParameter() {
        return null;
    }

    public void setParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
    }

    public void reset() {
        this.digest.reset();
    }

    public void update(byte[] byArray, int n, int n2) {
        this.digest.update(byArray, n, n2);
    }

    public void doFinal(byte[] byArray, int n) {
        byte[] byArray2 = this.digest.digest();
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
    }

    public void clean() {
        Cleaner.clean(this.digest);
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            return new DigestWrapper(this.ALGORITHM);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            CloneNotSupportedException cloneNotSupportedException = new CloneNotSupportedException(noSuchAlgorithmException.toString());
            cloneNotSupportedException.initCause(noSuchAlgorithmException);
            throw cloneNotSupportedException;
        }
    }
}

