/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.jrt11.impl;

import java.security.InvalidAlgorithmParameterException;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import ru.rutoken.jrt11.SessionFactory;
import ru.rutoken.jrt11.TokenException;
import ru.rutoken.jrt11.level11.Const11;
import ru.rutoken.jrt11.level11.Mechanism;
import ru.rutoken.jrt11.level11.P11Exception;
import ru.rutoken.jrt11.level11.Session;
import ru.rutoken.security.Cleanable;
import ru.rutoken.security.DigestInterface;

public class GostDigest11
implements DigestInterface,
Const11,
Cleanable {
    public static final String ALGORITHM_NAME = "rtGOST3411";
    public static final int DIGEST_LENGTH = 32;
    protected long processedLength = 0L;
    protected Session session;
    protected SessionFactory sessionFactory = new SessionFactory();
    protected AlgorithmParameterSpec algorithmParameter;
    protected boolean needReset = true;

    public GostDigest11() {
        this.reset();
    }

    public void clean() {
        this.processedLength = 0L;
        this.algorithmParameter = null;
    }

    public String getAlgorithmName() {
        return ALGORITHM_NAME;
    }

    public int getDigestLength() {
        return 32;
    }

    public long getProcessedLength() {
        return this.processedLength;
    }

    public void reset() {
        try {
            if (this.needReset) {
                if (this.session == null) {
                    this.session = (Session)this.sessionFactory.getSession();
                }
                this.session.digestReset(Mechanism.DIGEST_GOST3411);
                this.needReset = false;
            }
            this.processedLength = 0L;
            this.algorithmParameter = null;
        }
        catch (P11Exception p11Exception) {
            throw new ProviderException(p11Exception.toString(), p11Exception);
        }
    }

    public AlgorithmParameterSpec getParameter() {
        return this.algorithmParameter;
    }

    public void setParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (this.sessionFactory.setParameter(algorithmParameterSpec)) {
            try {
                if (this.session != null) {
                    this.session.close();
                }
                this.session = (Session)this.sessionFactory.getSession();
            }
            catch (P11Exception p11Exception) {
                throw new TokenException(p11Exception);
            }
        } else {
            this.algorithmParameter = algorithmParameterSpec;
        }
    }

    public void update(byte[] byArray, int n, int n2) {
        if (this.session == null) {
            throw new IllegalStateException();
        }
        try {
            this.needReset = true;
            this.session.digestUpdate(byArray, n, n2);
            this.processedLength += (long)n2;
        }
        catch (P11Exception p11Exception) {
            throw new ProviderException(p11Exception);
        }
    }

    public void doFinal(byte[] byArray, int n) {
        if (this.session == null) {
            throw new IllegalStateException();
        }
        try {
            if (n == 0) {
                this.session.digestDigest(byArray);
            } else {
                byte[] byArray2 = new byte[32];
                this.session.digestDigest(byArray2);
                System.arraycopy(byArray2, 0, byArray, n, 32);
            }
            this.needReset = true;
            this.reset();
        }
        catch (P11Exception p11Exception) {
            throw new ProviderException(p11Exception);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

