/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.jrt11.impl;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import ru.rutoken.crypto.CipherKeyInterface;
import ru.rutoken.crypto.MacInterface;
import ru.rutoken.crypto.SecretKeyInterface;
import ru.rutoken.crypto.SpecSecretKey;
import ru.rutoken.jrt11.TokenException;
import ru.rutoken.jrt11.impl.Rt11CipherKey;
import ru.rutoken.jrt11.impl.Rt11SecretKey;
import ru.rutoken.security.Cleanable;
import ru.rutoken.security.Cleaner;

public class GostMac11
implements MacInterface,
Cleanable {
    public static final String ALGORITHM_NAME = "rt11GOST28147";
    public static final int MAC_LENGTH = 4;
    protected long processedLength = 0L;
    protected AlgorithmParameterSpec algorithmParameter;
    protected CipherKeyInterface secret;
    protected CipherKeyInterface saved;

    public String getAlgorithmName() {
        return ALGORITHM_NAME;
    }

    public int getValueLength() {
        return 4;
    }

    public long getProcessedLength() {
        return this.processedLength;
    }

    public AlgorithmParameterSpec getParameter() {
        return this.algorithmParameter;
    }

    public void setParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.algorithmParameter = algorithmParameterSpec;
    }

    public void reset() {
        if (this.secret != null) {
            Cleaner.clean(this.secret);
            this.secret = null;
        }
        try {
            this.secret = (CipherKeyInterface)this.saved.clone();
            this.secret.macInit(this);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new TokenException(cloneNotSupportedException);
        }
        this.processedLength = 0L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(Key key) throws InvalidKeyException {
        if (!(key instanceof SpecSecretKey)) throw new InvalidKeyException();
        SecretKeyInterface secretKeyInterface = ((SpecSecretKey)key).getImpl();
        if (!(secretKeyInterface instanceof Rt11SecretKey)) throw new InvalidKeyException();
        try {
            if (this.saved != null) {
                Cleaner.clean(this.saved);
                this.saved = null;
            }
            if (this.secret != null) {
                Cleaner.clean(this.secret);
                this.secret = null;
            }
            this.saved = new Rt11CipherKey((Rt11SecretKey)secretKeyInterface);
            this.reset();
            return;
        }
        catch (Exception exception) {
            throw new TokenException(exception);
        }
    }

    public void update(byte[] byArray, int n, int n2) {
        this.secret.macUpdate(byArray, n, n2);
        this.processedLength += (long)n2;
    }

    public void doFinal(byte[] byArray, int n) {
        this.secret.macFinal(byArray, n);
    }

    public void clean() {
        this.processedLength = 0L;
        this.algorithmParameter = null;
        if (this.secret != null) {
            Cleaner.clean(this.secret);
            this.secret = null;
        }
        if (this.saved != null) {
            Cleaner.clean(this.saved);
            this.saved = null;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

