/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.jrt11.impl;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Random;
import ru.rutoken.jrt11.SessionFactory;
import ru.rutoken.jrt11.level11.AttributeList;
import ru.rutoken.jrt11.level11.Mechanism;
import ru.rutoken.jrt11.level11.P11Exception;
import ru.rutoken.jrt11.level11.Session;
import ru.rutoken.jrt11.level11.TokenObj;
import ru.rutoken.security.Cleanable;
import ru.rutoken.security.PairGeneratorInterface;
import ru.rutoken.security.spec.ParamAlias;
import ru.rutoken.security.spec.ParamID;
import ru.rutoken.security.spec.ParamKeySize;
import ru.rutoken.tools.Hex;

public abstract class PairGenerator11
implements PairGeneratorInterface,
Cleanable {
    protected SessionFactory sessionFactory = new SessionFactory();
    protected AlgorithmParameterSpec algorithmParameter;
    protected String id;
    protected String alias;
    protected int keySize;

    public AlgorithmParameterSpec getParameter() {
        return this.algorithmParameter;
    }

    public void setParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (!this.sessionFactory.setParameter(algorithmParameterSpec)) {
            if (algorithmParameterSpec instanceof ParamKeySize) {
                this.keySize = ((ParamKeySize)algorithmParameterSpec).getKeySize();
            } else if (algorithmParameterSpec instanceof ParamID) {
                this.id = ((ParamID)algorithmParameterSpec).getId();
            } else if (algorithmParameterSpec instanceof ParamAlias) {
                this.alias = ((ParamAlias)algorithmParameterSpec).getAlias();
            } else {
                this.algorithmParameter = algorithmParameterSpec;
            }
        }
    }

    public void clean() {
        this.algorithmParameter = null;
        this.alias = null;
        this.id = null;
        this.keySize = 0;
    }

    public KeyPair generateKeyPair() throws ProviderException {
        try {
            if (this.id == null) {
                this.id = PairGenerator11.createRandomId();
            }
            Session session = (Session)this.sessionFactory.getSession();
            AttributeList attributeList = this.getPublicPattern();
            AttributeList attributeList2 = this.getPrivatePattern();
            Mechanism mechanism = this.getMechanism();
            TokenObj[] tokenObjArray = session.genKeyPair(mechanism, attributeList, attributeList2);
            this.id = null;
            this.alias = null;
            return this.generateKeyPair(tokenObjArray);
        }
        catch (P11Exception p11Exception) {
            throw new ProviderException(p11Exception.getMessage(), p11Exception);
        }
    }

    public static String createRandomId() {
        Random random = new Random();
        random.setSeed(System.currentTimeMillis());
        char[] cArray = new char[16];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = Hex.DIGITS[random.nextInt(16)];
        }
        return new String(cArray);
    }

    protected abstract Mechanism getMechanism();

    protected abstract AttributeList getPublicPattern();

    protected abstract AttributeList getPrivatePattern();

    protected abstract KeyPair generateKeyPair(TokenObj[] var1) throws P11Exception;
}

