/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.jrt11.impl;

import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import ru.rutoken.crypto.SecretKeyInterface;
import ru.rutoken.jrt11.TokenException;
import ru.rutoken.jrt11.level11.Attribute;
import ru.rutoken.jrt11.level11.AttributeList;
import ru.rutoken.jrt11.level11.Const11;
import ru.rutoken.jrt11.level11.P11Exception;
import ru.rutoken.jrt11.level11.Session;
import ru.rutoken.jrt11.level11.TokenObj;
import ru.rutoken.security.Cleaner;
import ru.rutoken.security.spec.gost.CryptParamFactory;
import ru.rutoken.security.spec.gost.CryptParamInterface;
import ru.rutoken.tools.Arrays;

public class Rt11SecretKey
implements SecretKeyInterface,
Const11 {
    public static final int SECRET_KEY_LENGTH = 32;
    public static final AttributeList CREATE_ATTRIBUTES = new AttributeList(new Attribute[]{Attribute.CLASS_SECRET_KEY, Attribute.TOKEN_FALSE, Attribute.PRIVATE_FALSE, Attribute.KEY_TYPE_GOST28147, Attribute.ENCRYPT_TRUE, Attribute.DECRYPT_TRUE, Attribute.ID_EMPTY, Attribute.LABEL_EMPTY});
    protected TokenObj tokenObject = null;
    protected byte[] value = new byte[32];
    protected CryptParamInterface parameter = CryptParamFactory.getInstance();

    public Rt11SecretKey(TokenObj tokenObj, byte[] byArray) throws P11Exception {
        this.tokenObject = tokenObj;
        this.value = (byte[])byArray.clone();
    }

    public Rt11SecretKey(Rt11SecretKey rt11SecretKey) throws P11Exception {
        this.value = (byte[])rt11SecretKey.value.clone();
        this.tokenObject = Rt11SecretKey.cloneTokenObject(rt11SecretKey.tokenObject, this.value);
    }

    public Rt11SecretKey(Session session, String string, String string2, byte[] byArray, CryptParamInterface cryptParamInterface) throws P11Exception {
        this(session.createObject(Rt11SecretKey.getPlaceAttributes(string, string2, byArray, cryptParamInterface)), byArray);
    }

    public static Rt11SecretKey create(Session session, String string, String string2, byte[] byArray, CryptParamInterface cryptParamInterface) throws TokenException {
        try {
            AttributeList attributeList = Rt11SecretKey.getPlaceAttributes(string, string2, byArray, cryptParamInterface);
            TokenObj tokenObj = session.createObject(attributeList);
            return new Rt11SecretKey(tokenObj, byArray);
        }
        catch (P11Exception p11Exception) {
            throw new TokenException(p11Exception);
        }
    }

    public void delete() {
        try {
            this.tokenObject.delete();
        }
        catch (P11Exception p11Exception) {
            throw new TokenException(p11Exception);
        }
    }

    protected TokenObj getObject() {
        return this.tokenObject;
    }

    public String getId() {
        String string = null;
        try {
            string = new String((byte[])this.tokenObject.getAttributeValue(258L));
        }
        catch (P11Exception p11Exception) {
            // empty catch block
        }
        return string;
    }

    public String getAlias() {
        String string = null;
        try {
            string = new String((byte[])this.tokenObject.getAttributeValue(3L));
        }
        catch (P11Exception p11Exception) {
            // empty catch block
        }
        return string;
    }

    public String getAlgorithmName() {
        return "rt11GOST28147";
    }

    public static AttributeList getPlaceAttributes(String string, String string2, byte[] byArray, CryptParamInterface cryptParamInterface) {
        AttributeList attributeList = Rt11SecretKey.getCreatePattern(string, string2, cryptParamInterface);
        return attributeList.add(new Attribute(17L, byArray));
    }

    public static AttributeList getCreatePattern(String string, String string2, CryptParamInterface cryptParamInterface) {
        AttributeList attributeList = new AttributeList(CREATE_ATTRIBUTES);
        attributeList.setValue(592L, cryptParamInterface.getEncodedOID());
        if (string != null) {
            attributeList.setValue(258L, string);
        }
        if (string2 != null) {
            attributeList.setValue(3L, string2);
        }
        return attributeList;
    }

    public AlgorithmParameterSpec getParameter() {
        return CryptParamFactory.getInstance();
    }

    public void setParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (!CryptParamFactory.getInstance().equals(algorithmParameterSpec)) {
            throw new InvalidAlgorithmParameterException();
        }
    }

    public void diversKey(byte[] byArray) {
    }

    public int[] getIV() {
        return new int[0];
    }

    public void clean() {
        Arrays.clean(this.value);
        Cleaner.clean(this.tokenObject);
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            return new Rt11SecretKey(this);
        }
        catch (P11Exception p11Exception) {
            CloneNotSupportedException cloneNotSupportedException = new CloneNotSupportedException(p11Exception.toString());
            cloneNotSupportedException.initCause(p11Exception);
            throw cloneNotSupportedException;
        }
    }

    protected static TokenObj cloneTokenObject(TokenObj tokenObj, byte[] byArray) throws P11Exception {
        Session session = tokenObj.getSession();
        Session session2 = session.getToken().createSession();
        AttributeList attributeList = tokenObj.getAttributes(CREATE_ATTRIBUTES);
        attributeList.setValue(17L, byArray);
        TokenObj tokenObj2 = session2.createObject(attributeList);
        return tokenObj2;
    }
}

