/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.jrt11.impl;

import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Enumeration;
import ru.rutoken.jrt11.SessionFactory;
import ru.rutoken.jrt11.TokenException;
import ru.rutoken.jrt11.impl.GostPrivateKey11;
import ru.rutoken.jrt11.impl.GostPublicKey11;
import ru.rutoken.jrt11.impl.RsaPrivateKey11;
import ru.rutoken.jrt11.impl.RsaPublicKey11;
import ru.rutoken.jrt11.level11.Attribute;
import ru.rutoken.jrt11.level11.AttributeList;
import ru.rutoken.jrt11.level11.Const11;
import ru.rutoken.jrt11.level11.P11Exception;
import ru.rutoken.jrt11.level11.Session;
import ru.rutoken.jrt11.level11.Token;
import ru.rutoken.jrt11.level11.TokenObj;
import ru.rutoken.security.ContainerStore;
import ru.rutoken.security.KeyContainer;
import ru.rutoken.security.SpecPrivateKey;
import ru.rutoken.security.SpecPublicKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Store11
extends ContainerStore
implements Const11 {
    public static final String ALGORITHM_NAME = "rtStore";
    protected Session session = (Session)new SessionFactory().getSession();

    public String getAlgorithmName() {
        return ALGORITHM_NAME;
    }

    @Override
    public Enumeration<String> aliases() {
        return null;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public void load(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        try {
            this.session.login(cArray);
        }
        catch (P11Exception p11Exception) {
            throw new IOException();
        }
    }

    @Override
    public KeyContainer getContainer(String string, KeyStore.ProtectionParameter protectionParameter) throws KeyStoreException {
        try {
            AttributeList attributeList = new AttributeList(AttributeList.ANY_ATTRIBUTE);
            attributeList.add(new Attribute(3L, string.getBytes()));
            TokenObj[] tokenObjArray = this.session.findObjects(attributeList);
            PrivateKey privateKey = null;
            PublicKey publicKey = null;
            for (TokenObj tokenObj : tokenObjArray) {
                Key key = this.keyFactory(tokenObj);
                if (key instanceof PublicKey) {
                    publicKey = (PublicKey)key;
                }
                if (!(key instanceof PrivateKey)) continue;
                privateKey = (PrivateKey)key;
            }
            return new KeyContainer(new KeyPair(publicKey, privateKey));
        }
        catch (P11Exception p11Exception) {
            throw new TokenException(p11Exception);
        }
    }

    @Override
    public void setContainer(KeyContainer keyContainer, String string, KeyStore.ProtectionParameter protectionParameter) throws KeyStoreException {
    }

    @Override
    public void deleteContainer(KeyContainer keyContainer, String string, KeyStore.ProtectionParameter protectionParameter) throws KeyStoreException {
        try {
            TokenObj[] tokenObjArray;
            AttributeList attributeList = new AttributeList(AttributeList.ANY_ATTRIBUTE);
            attributeList.add(new Attribute(3L, string.getBytes()));
            for (TokenObj tokenObj : tokenObjArray = this.session.findObjects(attributeList)) {
                tokenObj.delete();
            }
        }
        catch (P11Exception p11Exception) {
            throw new TokenException(p11Exception);
        }
    }

    protected Key keyFactory(TokenObj tokenObj) {
        Key key = null;
        try {
            int n = (int)((Long)tokenObj.getAttributeValue(0L)).longValue();
            switch (n) {
                case 3: {
                    key = this.keyPrivateFactory(tokenObj);
                    break;
                }
                case 2: {
                    key = this.keyPublicFactory(tokenObj);
                }
            }
            return key;
        }
        catch (P11Exception p11Exception) {
            throw new TokenException(p11Exception);
        }
    }

    protected Key keyPrivateFactory(TokenObj tokenObj) {
        SpecPrivateKey specPrivateKey = null;
        try {
            int n = (int)((Long)tokenObj.getAttributeValue(256L)).longValue();
            switch (n) {
                case 48: {
                    specPrivateKey = new SpecPrivateKey(new GostPrivateKey11(tokenObj));
                    break;
                }
                case 0: {
                    specPrivateKey = new SpecPrivateKey(new RsaPrivateKey11(tokenObj));
                }
            }
            return specPrivateKey;
        }
        catch (P11Exception p11Exception) {
            throw new TokenException(p11Exception);
        }
    }

    protected Key keyPublicFactory(TokenObj tokenObj) {
        SpecPublicKey specPublicKey = null;
        try {
            int n = (int)((Long)tokenObj.getAttributeValue(256L)).longValue();
            switch (n) {
                case 48: {
                    specPublicKey = new SpecPublicKey(new GostPublicKey11(tokenObj));
                    break;
                }
                case 0: {
                    specPublicKey = new SpecPublicKey(new RsaPublicKey11(tokenObj));
                }
            }
            return specPublicKey;
        }
        catch (P11Exception p11Exception) {
            throw new TokenException(p11Exception);
        }
    }

    protected TokenObj findCertificate(String string) {
        try {
            AttributeList attributeList = new AttributeList(AttributeList.ANY_ATTRIBUTE);
            attributeList.add(new Attribute(3L, string.getBytes()));
            TokenObj[] tokenObjArray = this.session.findObjects(attributeList);
            if (tokenObjArray.length != 1) {
                throw new ProviderException();
            }
            return tokenObjArray[0];
        }
        catch (P11Exception p11Exception) {
            throw new TokenException(p11Exception);
        }
    }

    @Override
    public void clean() {
        this.session = null;
    }

    public static void cleanStore(AlgorithmParameterSpec algorithmParameterSpec) {
        try {
            Token token = (Token)new SessionFactory(algorithmParameterSpec).getToken();
            token.deleteAll();
        }
        catch (P11Exception p11Exception) {
            throw new TokenException(p11Exception);
        }
    }

    public static void checkClear(AlgorithmParameterSpec algorithmParameterSpec) {
        try {
            Token token = (Token)new SessionFactory(algorithmParameterSpec).getToken();
            token.checkTokenEmpty();
        }
        catch (P11Exception p11Exception) {
            throw new TokenException(p11Exception);
        }
    }
}

