/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.jrt11.level11;

import ru.rutoken.jrt11.level11.Const11;
import ru.rutoken.jrt11.level11.MechanismInfo;
import ru.rutoken.jrt11.level11.P11Exception;
import ru.rutoken.jrt11.level11.Token;
import ru.rutoken.security.Cleanable;
import ru.rutoken.tools.Arrays;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.CK_MECHANISM_INFO;
import sun.security.pkcs11.wrapper.Functions;
import sun.security.pkcs11.wrapper.PKCS11Exception;

public class Mechanism
implements Const11,
Cleanable {
    public static final Mechanism GENERATOR_RSA = new Mechanism(new CK_MECHANISM(0L));
    public static final Mechanism DIGEST_SHA = new Mechanism(new CK_MECHANISM(544L));
    public static final Mechanism DIGEST_MD5 = new Mechanism(new CK_MECHANISM(528L));
    public static final Mechanism SIGN_RSA = new Mechanism(new CK_MECHANISM(1L));
    public static final Mechanism GENERATOR_GOST3410 = new Mechanism(new CK_MECHANISM(4608L));
    public static final Mechanism DIGEST_GOST3411 = new Mechanism(new CK_MECHANISM(4624L));
    public static final Mechanism SIGN_GOST3410 = new Mechanism(new CK_MECHANISM(4609L));
    public static final Mechanism DERIVE_GOST3410 = new Mechanism(new CK_MECHANISM(4612L));
    public static final Mechanism GENERATOR_GOST28147 = new Mechanism(new CK_MECHANISM(4640L));
    public static final Mechanism MAC_GOST28147 = new Mechanism(new CK_MECHANISM(4643L));
    public static final Mechanism HMAC_GOST3411 = new Mechanism(new CK_MECHANISM(4625L));
    public static final Mechanism CIPHER_GOST28147_ECB = new Mechanism(new CK_MECHANISM(4641L));
    public static final Mechanism CIPHER_GOST28147 = new Mechanism(new CK_MECHANISM(4642L));
    public static final Mechanism CIPHER_GOST28147_WRAP = new Mechanism(new CK_MECHANISM(4644L));
    protected final CK_MECHANISM mechanism;

    Mechanism(CK_MECHANISM cK_MECHANISM) {
        this.mechanism = cK_MECHANISM;
    }

    public Mechanism(long l) {
        this.mechanism = new CK_MECHANISM(l);
    }

    public Mechanism(long l, Object object) {
        this.mechanism = new CK_MECHANISM(l);
        this.mechanism.pParameter = object;
    }

    CK_MECHANISM get() {
        return this.mechanism;
    }

    public long getHandle() {
        return this.mechanism.mechanism;
    }

    public Object getParam() {
        return this.mechanism.pParameter;
    }

    public void setParam(Object object) {
        this.mechanism.pParameter = object;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.mechanism.pParameter == null) {
            stringBuilder.append(this.mechanism.mechanism);
            stringBuilder.append(": mechanism=");
            stringBuilder.append(Functions.getMechanismName(this.mechanism.mechanism));
        } else {
            stringBuilder.append("  ");
            stringBuilder.append(this.mechanism.mechanism);
            stringBuilder.append(": mechanism=");
            stringBuilder.append(Functions.getMechanismName(this.mechanism.mechanism));
            stringBuilder.append("  ");
            stringBuilder.append("pParameter: ");
            stringBuilder.append(this.mechanism.pParameter);
        }
        return stringBuilder.toString();
    }

    public MechanismInfo getMechanismInfo(Token token) throws P11Exception {
        try {
            CK_MECHANISM_INFO cK_MECHANISM_INFO = token.getContext().get().C_GetMechanismInfo(token.getSlot(), this.mechanism.mechanism);
            return new MechanismInfo(cK_MECHANISM_INFO, this.mechanism.mechanism);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new P11Exception(pKCS11Exception);
        }
    }

    public void clean() {
        Object object = this.mechanism.pParameter;
        if (object instanceof byte[]) {
            Arrays.clean((byte[])object);
        } else if (object instanceof char[]) {
            Arrays.clean((char[])object);
        }
    }
}

