/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.jrt11.level11;

import java.io.PrintStream;
import java.util.Vector;
import ru.rutoken.jrt11.level11.Attribute;
import ru.rutoken.jrt11.level11.AttributeList;
import ru.rutoken.jrt11.level11.Const11;
import ru.rutoken.jrt11.level11.Context;
import ru.rutoken.jrt11.level11.Mechanism;
import ru.rutoken.jrt11.level11.P11Exception;
import ru.rutoken.jrt11.level11.Session;
import ru.rutoken.jrt11.level11.Token;
import ru.rutoken.security.Cleanable;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.Functions;
import sun.security.pkcs11.wrapper.PKCS11;
import sun.security.pkcs11.wrapper.PKCS11Exception;

public class TokenObj
implements Const11,
Cleanable {
    protected final PKCS11 p11;
    protected final Context context;
    protected final Token token;
    protected Session session;
    protected long handle;

    protected TokenObj(Session session, long l) throws P11Exception {
        this.session = session;
        this.token = this.session.getToken();
        this.context = this.session.getContext();
        this.p11 = this.context.get();
        this.handle = l;
    }

    protected long getHandle() {
        return this.handle;
    }

    public Session getSession() {
        return this.session;
    }

    public void delete() throws P11Exception {
        try {
            this.p11.C_DestroyObject(this.session.getHandle(), this.handle);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new P11Exception(pKCS11Exception);
        }
    }

    public byte[] sign(byte[] byArray, Mechanism mechanism) throws P11Exception {
        try {
            this.p11.C_SignInit(this.session.getHandle(), mechanism.get(), this.handle);
            return this.p11.C_Sign(this.session.getHandle(), byArray);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new P11Exception(pKCS11Exception);
        }
    }

    public boolean verify(byte[] byArray, byte[] byArray2, Mechanism mechanism) throws P11Exception {
        try {
            this.p11.C_VerifyInit(this.session.getHandle(), mechanism.get(), this.handle);
            this.p11.C_Verify(this.session.getHandle(), byArray, byArray2);
            return true;
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (pKCS11Exception.getErrorCode() == 192L) {
                return false;
            }
            throw new P11Exception(pKCS11Exception);
        }
    }

    public AttributeList setAttributes(AttributeList attributeList) throws P11Exception {
        try {
            this.p11.C_SetAttributeValue(this.session.getHandle(), this.handle, attributeList.list);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new P11Exception(pKCS11Exception);
        }
        return attributeList;
    }

    public AttributeList getAttributes(AttributeList attributeList) throws P11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray;
        try {
            cK_ATTRIBUTEArray = new CK_ATTRIBUTE[attributeList.size()];
            for (int i = 0; i < cK_ATTRIBUTEArray.length; ++i) {
                cK_ATTRIBUTEArray[i] = new CK_ATTRIBUTE(attributeList.list[i].type);
            }
            this.p11.C_GetAttributeValue(this.session.getHandle(), this.handle, cK_ATTRIBUTEArray);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new P11Exception(pKCS11Exception);
        }
        return new AttributeList(cK_ATTRIBUTEArray);
    }

    public AttributeList getAttributesUnsafe(AttributeList attributeList) throws P11Exception {
        try {
            this.p11.C_GetAttributeValue(this.session.getHandle(), this.handle, attributeList.list);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new P11Exception(pKCS11Exception);
        }
        return attributeList;
    }

    public void setAttribute(Attribute attribute) throws P11Exception {
        Attribute[] attributeArray = new Attribute[]{attribute};
        this.setAttributes(new AttributeList(attributeArray));
    }

    public Object getAttributeValue(long l) throws P11Exception {
        Attribute attribute = new Attribute(l, null);
        Attribute[] attributeArray = new Attribute[]{attribute};
        AttributeList attributeList = new AttributeList(attributeArray);
        attributeList = this.getAttributesUnsafe(attributeList);
        return attributeList.get(0).getValue();
    }

    public void setAttributeValue(long l, Object object) throws P11Exception {
        Attribute attribute = new Attribute(l, object);
        Attribute[] attributeArray = new Attribute[]{attribute};
        AttributeList attributeList = new AttributeList(attributeArray);
        this.setAttributes(attributeList);
    }

    public AttributeList getAllAttributes() throws P11Exception {
        Cleanable cleanable;
        int n;
        CK_ATTRIBUTE cK_ATTRIBUTE = new CK_ATTRIBUTE();
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{cK_ATTRIBUTE};
        Vector<AttributeList> vector = new Vector<AttributeList>(16);
        for (n = 0; n < 1024; ++n) {
            try {
                cK_ATTRIBUTEArray[0].type = n;
                cK_ATTRIBUTEArray[0].pValue = null;
                this.p11.C_GetAttributeValue(this.session.getHandle(), this.handle, cK_ATTRIBUTEArray);
                cleanable = new Attribute(cK_ATTRIBUTEArray[0].type, cK_ATTRIBUTEArray[0].pValue);
                vector.add((AttributeList)cleanable);
                continue;
            }
            catch (PKCS11Exception pKCS11Exception) {
                long l = pKCS11Exception.getErrorCode();
                if (l == 18L || l == 17L) continue;
                throw new P11Exception(pKCS11Exception);
            }
        }
        n = vector.size();
        cleanable = new AttributeList(n);
        for (int i = 0; i < n; ++i) {
            cleanable.set(i, (Attribute)vector.elementAt(i));
        }
        return cleanable;
    }

    public void printAllAttributes(PrintStream printStream) throws P11Exception {
        CK_ATTRIBUTE cK_ATTRIBUTE = new CK_ATTRIBUTE();
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{cK_ATTRIBUTE};
        for (int i = 0; i < 1024; ++i) {
            try {
                cK_ATTRIBUTEArray[0].type = i;
                cK_ATTRIBUTEArray[0].pValue = null;
                this.p11.C_GetAttributeValue(this.session.getHandle(), this.handle, cK_ATTRIBUTEArray);
                Attribute attribute = new Attribute(cK_ATTRIBUTEArray[0].type, cK_ATTRIBUTEArray[0].pValue);
                printStream.println(attribute.toString());
                continue;
            }
            catch (PKCS11Exception pKCS11Exception) {
                long l = pKCS11Exception.getErrorCode();
                if (l == 17L) {
                    printStream.println("" + cK_ATTRIBUTEArray[0].type + ":" + Functions.getAttributeName(cK_ATTRIBUTEArray[0].type) + "=?");
                }
                if (l == 18L || l == 17L) continue;
                throw new P11Exception(pKCS11Exception);
            }
        }
    }

    public boolean equals(Object object) {
        return object instanceof TokenObj && this.session.getHandle() == ((TokenObj)object).getSession().getHandle() && this.handle == ((TokenObj)object).handle;
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.handle;
    }

    public void clean() {
        this.session = null;
        this.handle = 0L;
    }
}

