/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.security;

import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import ru.rutoken.crypto.SpecSecretKey;
import ru.rutoken.jrt11.TokenException;
import ru.rutoken.jrt11.level11.P11Exception;
import ru.rutoken.jrt11.level11.Session;
import ru.rutoken.security.Cleanable;
import ru.rutoken.security.SpecPrivateKey;
import ru.rutoken.security.SpecPublicKey;
import ru.rutoken.tools.Log;

public class Cleaner {
    public static final byte[] cleanByteArray = new byte[0];
    protected static ArrayList<Object> totalList = new ArrayList();

    private Cleaner() {
    }

    public static void clean(Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof Cleanable) {
            ((Cleanable)object).clean();
            return;
        }
        if (Cleaner.cleanPrimitiveArray(object)) {
            return;
        }
        if (Cleaner.cleanSecurityObject(object)) {
            return;
        }
        if (Cleaner.cleanCryptoObject(object)) {
            return;
        }
        if (Cleaner.cleanKey(object)) {
            return;
        }
        if (Cleaner.cleanLevel11(object)) {
            return;
        }
    }

    protected static boolean cleanPrimitiveArray(Object object) {
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = 0;
            }
            return true;
        }
        if (object instanceof char[]) {
            char[] cArray = (char[])object;
            for (int i = 0; i < cArray.length; ++i) {
                cArray[i] = '\u0000';
            }
            return true;
        }
        if (object instanceof int[]) {
            int[] nArray = (int[])object;
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = 0;
            }
            return true;
        }
        return false;
    }

    protected static boolean cleanKey(Object object) {
        if (object instanceof SpecPrivateKey) {
            ((SpecPrivateKey)object).clean();
            return true;
        }
        if (object instanceof SpecPublicKey) {
            return true;
        }
        if (object instanceof SpecSecretKey) {
            ((SpecSecretKey)object).clean();
            return true;
        }
        if (object instanceof KeyPair) {
            Cleaner.clean(((KeyPair)object).getPrivate());
            return true;
        }
        return false;
    }

    protected static boolean cleanLevel11(Object object) {
        if (object instanceof Session) {
            try {
                ((Session)object).close();
                return true;
            }
            catch (P11Exception p11Exception) {
                throw new TokenException(p11Exception);
            }
        }
        return false;
    }

    protected static boolean cleanSecurityObject(Object object) {
        if (object instanceof SecureRandom) {
            try {
                ((SecureRandom)object).setSeed(cleanByteArray);
            }
            catch (Exception exception) {
                Log.debug(exception);
            }
            return true;
        }
        if (object instanceof Signature) {
            try {
                ((Signature)object).setParameter(ParamClean.INSTANCE);
            }
            catch (Exception exception) {
                Log.debug(exception);
            }
            return true;
        }
        if (object instanceof KeyStore) {
            try {
                ((KeyStore)object).setKeyEntry(null, CleanSecretKey.INSTANCE, null, null);
            }
            catch (Exception exception) {
                Log.debug(exception);
            }
            return true;
        }
        return false;
    }

    protected static boolean cleanCryptoObject(Object object) {
        if (object instanceof KeyGenerator) {
            try {
                ((KeyGenerator)object).init(ParamClean.INSTANCE);
            }
            catch (Exception exception) {
                Log.debug(exception);
            }
            return true;
        }
        if (object instanceof KeyAgreement) {
            try {
                ((KeyAgreement)object).init(CleanPrivateKey.INSTANCE, ParamClean.INSTANCE, null);
            }
            catch (Exception exception) {
                Log.debug(exception);
            }
            return true;
        }
        if (object instanceof Mac) {
            try {
                ((Mac)object).init(CleanSecretKey.INSTANCE, ParamClean.INSTANCE);
            }
            catch (Exception exception) {
                Log.debug(exception);
            }
            return true;
        }
        if (object instanceof Cipher) {
            try {
                ((Cipher)object).init(3, CleanSecretKey.INSTANCE);
            }
            catch (Exception exception) {
                Log.debug(exception);
            }
            return true;
        }
        return false;
    }

    public static synchronized void add(Object object) {
    }

    protected static synchronized void remove(Object object) {
    }

    public static void checkClear() {
    }

    public static class CleanSecretKey
    implements SecretKey {
        public static final CleanSecretKey INSTANCE = new CleanSecretKey();

        private CleanSecretKey() {
        }

        public String getAlgorithm() {
            return null;
        }

        public String getFormat() {
            return null;
        }

        public byte[] getEncoded() {
            return null;
        }
    }

    public static class CleanPrivateKey
    implements PrivateKey {
        public static final CleanPrivateKey INSTANCE = new CleanPrivateKey();

        private CleanPrivateKey() {
        }

        public String getAlgorithm() {
            return null;
        }

        public String getFormat() {
            return null;
        }

        public byte[] getEncoded() {
            return null;
        }
    }

    public static class ParamClean
    implements AlgorithmParameterSpec {
        public static final ParamClean INSTANCE = new ParamClean();

        private ParamClean() {
        }
    }
}

