/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.security;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;
import ru.rutoken.security.Cleanable;
import ru.rutoken.security.KeyContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerStore
implements Cleanable {
    public Key getKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        try {
            return this.getContainer(string, new KeyStore.PasswordProtection(cArray)).getPrivateKey();
        }
        catch (KeyStoreException keyStoreException) {
            UnrecoverableKeyException unrecoverableKeyException = new UnrecoverableKeyException();
            unrecoverableKeyException.initCause(keyStoreException);
            throw unrecoverableKeyException;
        }
    }

    public Certificate[] getCertificateChain(String string) {
        return new Certificate[]{this.getCertificate(string)};
    }

    public Certificate getCertificate(String string) {
        Certificate certificate = null;
        try {
            certificate = this.getContainer(string, null).getCertificate();
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        return certificate;
    }

    public Date getCreationDate(String string) {
        throw new UnsupportedOperationException();
    }

    public void setKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        KeyContainer keyContainer = new KeyContainer((PrivateKey)key, certificateArray);
        this.setContainer(keyContainer, string, new KeyStore.PasswordProtection(cArray));
    }

    public void setKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new UnsupportedOperationException();
    }

    public void setCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        KeyContainer keyContainer = this.getContainer(string, null);
        if (keyContainer == null) {
            keyContainer = new KeyContainer(null, certificate);
        } else {
            keyContainer.setCertificate(certificate);
        }
        this.setContainer(keyContainer, string, null);
    }

    public void deleteEntry(String string) throws KeyStoreException {
        this.deleteContainer(null, string, null);
    }

    public Enumeration<String> aliases() {
        return null;
    }

    public boolean containsAlias(String string) {
        KeyContainer keyContainer = null;
        try {
            keyContainer = this.getContainer(string, null);
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        return keyContainer != null;
    }

    public int size() {
        return 0;
    }

    public boolean isKeyEntry(String string) {
        KeyContainer keyContainer = null;
        try {
            keyContainer = this.getContainer(string, null);
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        return keyContainer != null && keyContainer.getPrivateKey() != null;
    }

    public boolean isCertificateEntry(String string) {
        KeyContainer keyContainer = null;
        try {
            keyContainer = this.getContainer(string, null);
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        return keyContainer != null && keyContainer.getCertificate() != null;
    }

    public String getCertificateAlias(Certificate certificate) {
        String string = null;
        Enumeration<String> enumeration = this.aliases();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            KeyContainer keyContainer = null;
            try {
                keyContainer = this.getContainer(string2, null);
            }
            catch (KeyStoreException keyStoreException) {
                // empty catch block
            }
            if (keyContainer == null || keyContainer.getCertificate() == null || !keyContainer.getCertificate().equals(certificate)) continue;
            string = string2;
            break;
        }
        return string;
    }

    public void store(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
    }

    public void store(KeyStore.LoadStoreParameter loadStoreParameter) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
    }

    public void load(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
    }

    public void load(KeyStore.LoadStoreParameter loadStoreParameter) throws IOException, NoSuchAlgorithmException, CertificateException {
    }

    public KeyStore.Entry getEntry(String string, KeyStore.ProtectionParameter protectionParameter) throws NoSuchAlgorithmException, UnrecoverableEntryException, KeyStoreException {
        return this.getContainer(string, protectionParameter);
    }

    public void setEntry(String string, KeyStore.Entry entry, KeyStore.ProtectionParameter protectionParameter) throws KeyStoreException {
        if (!(entry instanceof KeyContainer)) {
            throw new KeyStoreException("Unknown entry.");
        }
        this.setContainer((KeyContainer)entry, string, protectionParameter);
    }

    public boolean entryInstanceOf(String string, Class<? extends KeyStore.Entry> clazz) throws KeyStoreException {
        return clazz == KeyContainer.class && this.getContainer(string, null) != null;
    }

    public KeyContainer getContainer(String string, KeyStore.ProtectionParameter protectionParameter) throws KeyStoreException {
        return null;
    }

    public void setContainer(KeyContainer keyContainer, String string, KeyStore.ProtectionParameter protectionParameter) throws KeyStoreException {
    }

    public void deleteContainer(KeyContainer keyContainer, String string, KeyStore.ProtectionParameter protectionParameter) throws KeyStoreException {
    }

    @Override
    public void clean() {
    }
}

