/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.security;

import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import ru.rutoken.security.Cleanable;

public class KeyContainer
implements KeyStore.Entry,
Cleanable {
    protected PrivateKey privateKey;
    protected PublicKey publicKey;
    protected Certificate certificate;
    protected Certificate[] chain;

    public KeyContainer(KeyPair keyPair) {
        this.privateKey = keyPair.getPrivate();
        this.publicKey = keyPair.getPublic();
    }

    public KeyContainer(PrivateKey privateKey, Certificate certificate) {
        this.privateKey = privateKey;
        this.certificate = certificate;
    }

    public KeyContainer(PrivateKey privateKey, Certificate[] certificateArray) {
        this.privateKey = privateKey;
        this.chain = certificateArray;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public PublicKey getPublicKey() {
        Certificate certificate;
        PublicKey publicKey = this.publicKey;
        if (publicKey == null && (certificate = this.getCertificate()) != null) {
            publicKey = certificate.getPublicKey();
        }
        return publicKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public KeyPair getKeyPair() {
        return new KeyPair(this.getPublicKey(), this.privateKey);
    }

    public void setKeyPair(KeyPair keyPair) {
        this.publicKey = keyPair.getPublic();
        this.privateKey = keyPair.getPrivate();
    }

    public Certificate getCertificate() {
        return this.certificate == null ? (this.chain == null ? null : this.chain[0]) : this.certificate;
    }

    public void setCertificate(Certificate certificate) {
        this.certificate = certificate;
    }

    public Certificate[] getChain() {
        Certificate[] certificateArray;
        if (this.chain == null) {
            Certificate[] certificateArray2 = new Certificate[1];
            certificateArray = certificateArray2;
            certificateArray2[0] = this.certificate;
        } else {
            certificateArray = this.chain;
        }
        return certificateArray;
    }

    public void setChain(Certificate[] certificateArray) {
        this.chain = certificateArray;
    }

    public void clean() {
        this.privateKey = null;
    }
}

