/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.security;

import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import ru.rutoken.jrt11.impl.Random11;
import ru.rutoken.security.Cleanable;
import ru.rutoken.security.Cleaner;
import ru.rutoken.security.RandomInterface;
import ru.rutoken.tools.Arrays;

public class SecureRandom
implements Cleanable {
    protected final RandomInterface implementation;
    private double nextNextGaussian;
    private boolean haveNextNextGaussian = false;

    public static SecureRandom getInstance(String string) throws NoSuchAlgorithmException {
        if (!"rtRandom".equals(string)) {
            throw new NoSuchAlgorithmException();
        }
        Random11 random11 = new Random11();
        return new SecureRandom(random11);
    }

    public static SecureRandom getInstance(String string, String string2) throws NoSuchAlgorithmException {
        return SecureRandom.getInstance(string);
    }

    public static SecureRandom getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        return SecureRandom.getInstance(string);
    }

    public SecureRandom(RandomInterface randomInterface) {
        this.implementation = randomInterface;
    }

    public String getAlgorithm() {
        return this.implementation.getAlgorithmName();
    }

    public Provider getProvider() {
        return null;
    }

    public void nextBytes(byte[] byArray) {
        this.implementation.getRandomBytes(byArray);
    }

    public void nextBytes(byte[] byArray, int n, int n2) {
        this.implementation.getRandomBytes(byArray, n, n2);
    }

    public int nextInt() {
        byte[] byArray = new byte[4];
        this.nextBytes(byArray);
        return Arrays.getInt(byArray, 0);
    }

    public int nextInt(int n) {
        int n2;
        int n3;
        if (n <= 0) {
            throw new IllegalArgumentException("mod must be positive");
        }
        byte[] byArray = new byte[4];
        do {
            this.nextBytes(byArray);
        } while ((n3 = Arrays.getInt(byArray, 0)) - (n2 = n3 % n) + (n - 1) < 0);
        return n2;
    }

    public long nextLong() {
        byte[] byArray = new byte[8];
        this.nextBytes(byArray);
        return Arrays.getLong(byArray, 0);
    }

    public boolean nextBoolean() {
        return (this.nextInt() & 1) == 0;
    }

    public float nextFloat() {
        byte[] byArray = new byte[4];
        this.nextBytes(byArray, 0, 3);
        int n = Arrays.getInt(byArray, 0);
        return (float)n / 1.6777216E7f;
    }

    public double nextDouble() {
        byte[] byArray = new byte[8];
        this.nextBytes(byArray, 0, 8);
        long l = Arrays.getLong(byArray, 0) & 0x1FFFFFFFFFFFFFL;
        return (double)l / 9.007199254740992E15;
    }

    public double nextGaussian() {
        double d;
        double d2;
        double d3;
        if (this.haveNextNextGaussian) {
            this.haveNextNextGaussian = false;
            return this.nextNextGaussian;
        }
        while ((d3 = (d2 = 2.0 * this.nextDouble() - 1.0) * d2 + (d = 2.0 * this.nextDouble() - 1.0) * d) >= 1.0 || d3 == 0.0) {
        }
        double d4 = Math.sqrt(-2.0 * Math.log(d3) / d3);
        this.nextNextGaussian = d * d4;
        this.haveNextNextGaussian = true;
        return d2 * d4;
    }

    public void setSeed(byte[] byArray) {
        this.implementation.setSeed(byArray);
    }

    public void setSeed(long l) {
        byte[] byArray = new byte[8];
        Arrays.getBytes(l, byArray, 0);
        this.setSeed(byArray);
    }

    public byte[] getSeed(int n) {
        byte[] byArray = new byte[n];
        this.implementation.getRandomBytes(byArray);
        return byArray;
    }

    public byte[] generateSeed(int n) {
        byte[] byArray = new byte[n];
        this.implementation.getRandomBytes(byArray);
        return byArray;
    }

    public String toString() {
        return this.implementation.toString();
    }

    public void clean() {
        this.nextNextGaussian = 0.0;
        this.haveNextNextGaussian = false;
        Cleaner.clean(this.implementation);
    }
}

