/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.security;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import ru.rutoken.security.Cleanable;
import ru.rutoken.security.Cleaner;
import ru.rutoken.security.PrivateKeyInterface;
import ru.rutoken.security.PublicKeyInterface;
import ru.rutoken.security.SpecPrivateKey;
import ru.rutoken.security.SpecPublicKey;

public class SignatureSpi
extends java.security.SignatureSpi
implements Cleanable {
    protected SpecPrivateKey privateKey = null;
    protected SpecPublicKey publicKey = null;
    public final String algorithm;
    public final String keyAlgorithm;
    public final String digestAlgorithm;
    protected final MessageDigest messageDigest;

    public SignatureSpi(String string) throws NoSuchAlgorithmException {
        int n = string.indexOf("with");
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        this.algorithm = string;
        this.keyAlgorithm = string.substring(n + 4);
        this.digestAlgorithm = string.substring(0, n);
        this.messageDigest = MessageDigest.getInstance(this.digestAlgorithm);
    }

    public String getAlgorithmName() {
        return this.algorithm;
    }

    protected int getSignatureLength() {
        return this.privateKey != null ? this.privateKey.getImpl().getSignatureLength() : (this.publicKey != null ? this.publicKey.getImpl().getSignatureLength() : 0);
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec == Cleaner.ParamClean.INSTANCE) {
            Cleaner.clean(this);
        }
    }

    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.privateKey = null;
        if (!(publicKey instanceof SpecPublicKey)) {
            throw new InvalidKeyException();
        }
        this.publicKey = (SpecPublicKey)publicKey;
        if (!this.keyAlgorithm.equals(publicKey.getAlgorithm())) {
            throw new InvalidKeyException();
        }
        this.messageDigest.reset();
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.publicKey = null;
        if (!(privateKey instanceof SpecPrivateKey)) {
            throw new InvalidKeyException();
        }
        this.privateKey = (SpecPrivateKey)privateKey;
        if (!this.keyAlgorithm.equals(privateKey.getAlgorithm())) {
            throw new InvalidKeyException();
        }
        this.messageDigest.reset();
    }

    protected void engineUpdate(byte by) throws SignatureException {
        if (this.privateKey == null && this.publicKey == null) {
            throw new SignatureException();
        }
        this.messageDigest.update(by);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        if (this.privateKey == null && this.publicKey == null) {
            throw new SignatureException();
        }
        this.messageDigest.update(byArray, n, n2);
    }

    protected byte[] engineSign() throws SignatureException {
        byte[] byArray;
        if (this.privateKey == null) {
            throw new SignatureException("Signature was not initialized properly.");
        }
        byte[] byArray2 = this.messageDigest.digest();
        PrivateKeyInterface privateKeyInterface = this.privateKey.getImpl();
        try {
            byArray = privateKeyInterface.signature(byArray2);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SignatureException(invalidKeyException);
        }
        return byArray;
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        if (this.publicKey == null) {
            throw new SignatureException("Signature was not initialized properly.");
        }
        byte[] byArray2 = this.messageDigest.digest();
        PublicKeyInterface publicKeyInterface = this.publicKey.getImpl();
        boolean bl = publicKeyInterface.verifySignature(byArray, byArray2);
        return bl;
    }

    @Deprecated
    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
    }

    @Deprecated
    protected Object engineGetParameter(String string) throws InvalidParameterException {
        return null;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public void clean() {
        this.privateKey = null;
        if (this.messageDigest instanceof Cleanable) {
            Cleaner.clean(this.messageDigest);
        }
    }
}

