/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.security;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;
import ru.rutoken.security.Cleanable;
import ru.rutoken.security.Cleaner;
import ru.rutoken.security.ContainerStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreSpi
extends KeyStoreSpi
implements Cleanable {
    protected final ContainerStore store;

    public StoreSpi(ContainerStore containerStore) {
        this.store = containerStore;
    }

    @Override
    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        return this.store.getKey(string, cArray);
    }

    @Override
    public Certificate[] engineGetCertificateChain(String string) {
        return this.store.getCertificateChain(string);
    }

    @Override
    public Certificate engineGetCertificate(String string) {
        return this.store.getCertificate(string);
    }

    @Override
    public Date engineGetCreationDate(String string) {
        return this.store.getCreationDate(string);
    }

    @Override
    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        if (key == Cleaner.CleanSecretKey.INSTANCE) {
            Cleaner.clean(this);
        } else {
            this.store.setKeyEntry(string, key, cArray, certificateArray);
        }
    }

    @Override
    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        this.store.setKeyEntry(string, byArray, certificateArray);
    }

    @Override
    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        this.store.setCertificateEntry(string, certificate);
    }

    @Override
    public void engineDeleteEntry(String string) throws KeyStoreException {
        this.store.deleteEntry(string);
    }

    @Override
    public Enumeration<String> engineAliases() {
        return this.store.aliases();
    }

    @Override
    public boolean engineContainsAlias(String string) {
        return this.store.containsAlias(string);
    }

    @Override
    public int engineSize() {
        return this.store.size();
    }

    @Override
    public boolean engineIsKeyEntry(String string) {
        return this.store.isKeyEntry(string);
    }

    @Override
    public boolean engineIsCertificateEntry(String string) {
        return this.store.isCertificateEntry(string);
    }

    @Override
    public String engineGetCertificateAlias(Certificate certificate) {
        return this.store.getCertificateAlias(certificate);
    }

    @Override
    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.store.store(outputStream, cArray);
    }

    @Override
    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.store.load(inputStream, cArray);
    }

    @Override
    public KeyStore.Entry engineGetEntry(String string, KeyStore.ProtectionParameter protectionParameter) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        return this.store.getEntry(string, protectionParameter);
    }

    @Override
    public void engineSetEntry(String string, KeyStore.Entry entry, KeyStore.ProtectionParameter protectionParameter) throws KeyStoreException {
        this.store.setEntry(string, entry, protectionParameter);
    }

    @Override
    public boolean engineEntryInstanceOf(String string, Class<? extends KeyStore.Entry> clazz) {
        try {
            return this.store.entryInstanceOf(string, clazz);
        }
        catch (KeyStoreException keyStoreException) {
            throw new ProviderException(keyStoreException);
        }
    }

    @Override
    public void clean() {
        Cleaner.clean(this.store);
    }
}

