/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.security.spec;

import java.security.spec.AlgorithmParameterSpec;

public class OID
implements AlgorithmParameterSpec,
Cloneable {
    public static final char CHAR_SEPARATOR = '.';
    public static final String SPLIT_POINT = "\\u002E";
    public static final int DEFAULT_STRING_LENGTH = 32;
    protected final int[] value;

    public OID(int[] nArray) {
        this.value = new int[nArray.length];
        System.arraycopy(nArray, 0, this.value, 0, nArray.length);
    }

    public OID(OID oID) {
        this.value = new int[oID.value.length];
        System.arraycopy(oID.value, 0, this.value, 0, oID.value.length);
    }

    public OID(String string) {
        this.value = OID.parse(string);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(Integer.toString(this.value[0]));
        for (int i = 1; i < this.value.length; ++i) {
            stringBuilder.append('.').append(this.value[i]);
        }
        return stringBuilder.toString();
    }

    public boolean isEquals(OID oID) {
        return this.isEquals(oID.value);
    }

    public boolean isEquals(int[] nArray) {
        boolean bl = false;
        if (nArray.length == this.value.length) {
            bl = true;
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == this.value[i]) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public boolean isEquals(String string) {
        return string.equals(this.toString());
    }

    public boolean equals(Object object) {
        return this != object || object instanceof OID && this.isEquals(((OID)object).value);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public Object clone() throws CloneNotSupportedException {
        return new OID(this);
    }

    public static int[] parse(String string) {
        int n;
        int n2 = 1;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < string.length(); ++i) {
            if (cArray[i] != '.') continue;
            ++n2;
        }
        if (n2 == 1) {
            throw new IllegalArgumentException();
        }
        int[] nArray = new int[n2];
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < string.length(); ++n) {
            if (cArray[n] != '.') continue;
            nArray[n4] = OID.getInt(cArray, n3, n);
            ++n4;
            n3 = n + 1;
        }
        nArray[n4] = OID.getInt(cArray, n3, n);
        return nArray;
    }

    public static int getInt(char[] cArray, int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            if (cArray[i] < '0' || cArray[i] > '9') {
                throw new IllegalArgumentException();
            }
            n3 = n3 * 10 + cArray[i] - 48;
        }
        return n3;
    }
}

