/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.security.spec.gost;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import ru.rutoken.security.spec.OID;
import ru.rutoken.security.spec.gost.CryptParamInterface;
import ru.rutoken.security.spec.gost.CryptParamSpec;
import ru.rutoken.tools.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CryptParamFactory {
    public static final int TEST = 0;
    public static final int CRYPTOPRO_A = 1;
    public static final int CRYPTOPRO_B = 2;
    public static final int CRYPTOPRO_C = 3;
    public static final int CRYPTOPRO_D = 4;
    public static final int CRYPTOPRO_OSCAR_1_1 = 5;
    public static final int CRYPTOPRO_OSCAR_1_0 = 6;
    public static final int CRYPTOPRO_RIC_1 = 7;
    protected static final CryptParamSpec[] LIST = new CryptParamSpec[]{new CryptParamSpec(0), new CryptParamSpec(1), new CryptParamSpec(2), new CryptParamSpec(3), new CryptParamSpec(4), new CryptParamSpec(5), new CryptParamSpec(6), new CryptParamSpec(7)};
    public static final int DEFAULT = 1;

    private CryptParamFactory() {
    }

    public static CryptParamInterface getInstance() {
        return LIST[1];
    }

    public static CryptParamInterface getInstance(int n) {
        if (n < 0 || n > 7) {
            throw new IllegalArgumentException();
        }
        return LIST[n];
    }

    public static CryptParamInterface getInstance(OID oID) {
        int n = -1;
        for (int i = 0; i < LIST.length; ++i) {
            if (!CryptParamSpec.OID_LIST[i].isEquals(oID)) continue;
            n = i;
            break;
        }
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        return LIST[n];
    }

    public static CryptParamInterface getInstance(String string) {
        int n = -1;
        for (int i = 0; i < LIST.length; ++i) {
            if (!CryptParamSpec.OID_LIST[i].isEquals(string)) continue;
            n = i;
            break;
        }
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        return LIST[n];
    }

    public static CryptParamInterface decode(byte[] byArray, int n) {
        int n2 = -1;
        for (int i = 0; i < LIST.length; ++i) {
            byte[] byArray2 = LIST[i].getEncodedOID();
            if (!Arrays.equals(byArray2, 0, byArray, n, byArray2.length)) continue;
            n2 = i;
            break;
        }
        if (n2 == -1) {
            throw new IllegalArgumentException();
        }
        return LIST[n2];
    }

    public static int getAmount() {
        return LIST.length;
    }

    public static Enumeration<CryptParamInterface> getEnumeration() {
        Vector vector = new Vector(LIST.length);
        Collections.addAll(vector, LIST);
        return vector.elements();
    }

    public static Iterator<CryptParamInterface> getIterator() {
        ArrayList arrayList = new ArrayList(LIST.length);
        Collections.addAll(arrayList, LIST);
        return arrayList.iterator();
    }
}

