/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.security.spec.gost;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import ru.rutoken.security.spec.OID;
import ru.rutoken.security.spec.gost.DigestParamInterface;
import ru.rutoken.security.spec.gost.DigestParamSpec;
import ru.rutoken.tools.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DigestParamFactory {
    public static final int TEST = 0;
    public static final int CRYPTOPRO_A = 1;
    public static final int CRYPTOPRO_B = 2;
    public static final int CRYPTOPRO_C = 3;
    public static final int CRYPTOPRO_D = 4;
    protected static final DigestParamSpec[] LIST = new DigestParamSpec[]{new DigestParamSpec(0), new DigestParamSpec(1), new DigestParamSpec(2), new DigestParamSpec(3), new DigestParamSpec(4)};
    public static final int DEFAULT = 1;

    private DigestParamFactory() {
    }

    public static DigestParamInterface getInstance() {
        return LIST[1];
    }

    public static DigestParamInterface getInstance(int n) {
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException();
        }
        return LIST[n];
    }

    public static DigestParamInterface getInstance(OID oID) {
        int n = -1;
        for (int i = 0; i < LIST.length; ++i) {
            if (!DigestParamSpec.OID_LIST[i].isEquals(oID)) continue;
            n = i;
            break;
        }
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        return LIST[n];
    }

    public static DigestParamInterface getInstance(String string) {
        int n = -1;
        for (int i = 0; i < LIST.length; ++i) {
            if (!DigestParamSpec.OID_LIST[i].isEquals(string)) continue;
            n = i;
            break;
        }
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        return LIST[n];
    }

    public static DigestParamInterface decode(byte[] byArray, int n) {
        int n2 = -1;
        for (int i = 0; i < LIST.length; ++i) {
            byte[] byArray2 = LIST[i].getEncodedOID();
            if (!Arrays.equals(byArray2, 0, byArray, n, byArray2.length)) continue;
            n2 = i;
            break;
        }
        if (n2 == -1) {
            throw new IllegalArgumentException();
        }
        return LIST[n2];
    }

    public static int getAmount() {
        return LIST.length;
    }

    public static Enumeration<DigestParamInterface> getEnumeration() {
        Vector vector = new Vector(LIST.length);
        Collections.addAll(vector, LIST);
        return vector.elements();
    }

    public static Iterator<DigestParamInterface> getIterator() {
        ArrayList arrayList = new ArrayList(LIST.length);
        Collections.addAll(arrayList, LIST);
        return arrayList.iterator();
    }
}

