/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.security.spec.gost;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import ru.rutoken.security.spec.OID;
import ru.rutoken.security.spec.gost.EllipticParamInterface;
import ru.rutoken.security.spec.gost.EllipticParamSpec;
import ru.rutoken.tools.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EllipticParamFactory {
    public static final int TEST = 0;
    public static final int CRYPTOPRO_A = 1;
    public static final int CRYPTOPRO_B = 2;
    public static final int CRYPTOPRO_C = 3;
    protected static final EllipticParamSpec[] LIST = new EllipticParamSpec[]{new EllipticParamSpec(0), new EllipticParamSpec(1), new EllipticParamSpec(2), new EllipticParamSpec(3)};
    public static final int DEFAULT = 1;

    private EllipticParamFactory() {
    }

    public static EllipticParamInterface getInstance() {
        return LIST[1];
    }

    public static EllipticParamInterface getInstance(int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException();
        }
        return LIST[n];
    }

    public static EllipticParamInterface getInstance(OID oID) {
        int n = -1;
        for (int i = 0; i < LIST.length; ++i) {
            if (!EllipticParamSpec.OID_LIST[i].isEquals(oID)) continue;
            n = i;
            break;
        }
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        return LIST[n];
    }

    public static EllipticParamInterface getInstance(String string) {
        int n = -1;
        for (int i = 0; i < LIST.length; ++i) {
            if (!EllipticParamSpec.OID_LIST[i].isEquals(string)) continue;
            n = i;
            break;
        }
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        return LIST[n];
    }

    public static EllipticParamInterface decode(byte[] byArray, int n) {
        int n2 = -1;
        for (int i = 0; i < LIST.length; ++i) {
            byte[] byArray2 = LIST[i].getEncodedOID();
            if (!Arrays.equals(byArray2, 0, byArray, n, byArray2.length)) continue;
            n2 = i;
            break;
        }
        if (n2 == -1) {
            throw new IllegalArgumentException();
        }
        return LIST[n2];
    }

    public static int getAmount() {
        return LIST.length;
    }

    public static Enumeration<EllipticParamInterface> getEnumeration() {
        Vector vector = new Vector(LIST.length);
        Collections.addAll(vector, LIST);
        return vector.elements();
    }

    public static Iterator<EllipticParamInterface> getIterator() {
        ArrayList arrayList = new ArrayList(LIST.length);
        Collections.addAll(arrayList, LIST);
        return arrayList.iterator();
    }
}

