/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.security.spec.gost;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import ru.rutoken.security.spec.OID;
import ru.rutoken.security.spec.gost.ExchangeParamInterface;
import ru.rutoken.security.spec.gost.ExchangeParamSpec;
import ru.rutoken.tools.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExchangeParamFactory {
    public static final int CRYPTOPRO_XCHA = 0;
    public static final int CRYPTOPRO_XCHB = 1;
    protected static final ExchangeParamSpec[] LIST = new ExchangeParamSpec[]{new ExchangeParamSpec(0), new ExchangeParamSpec(1)};
    public static final int DEFAULT = 0;

    private ExchangeParamFactory() {
    }

    public static ExchangeParamInterface getInstance() {
        return LIST[0];
    }

    public static ExchangeParamInterface getInstance(int n) {
        if (n < 0 || n > 1) {
            throw new IllegalArgumentException();
        }
        return LIST[n];
    }

    public static ExchangeParamInterface getInstance(OID oID) {
        int n = -1;
        for (int i = 0; i < LIST.length; ++i) {
            if (!ExchangeParamSpec.OID_LIST[i].isEquals(oID)) continue;
            n = i;
            break;
        }
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        return LIST[n];
    }

    public static ExchangeParamInterface getInstance(String string) {
        int n = -1;
        for (int i = 0; i < LIST.length; ++i) {
            if (!ExchangeParamSpec.OID_LIST[i].isEquals(string)) continue;
            n = i;
            break;
        }
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        return LIST[n];
    }

    public static ExchangeParamInterface decode(byte[] byArray, int n) {
        int n2 = -1;
        for (int i = 0; i < LIST.length; ++i) {
            byte[] byArray2 = LIST[i].getEncodedOID();
            if (!Arrays.equals(byArray2, 0, byArray, n, byArray2.length)) continue;
            n2 = i;
            break;
        }
        if (n2 == -1) {
            throw new IllegalArgumentException();
        }
        return LIST[n2];
    }

    public static int getAmount() {
        return LIST.length;
    }

    public static Enumeration<ExchangeParamInterface> getEnumeration() {
        Vector vector = new Vector(LIST.length);
        Collections.addAll(vector, LIST);
        return vector.elements();
    }

    public static Iterator<ExchangeParamInterface> getIterator() {
        ArrayList arrayList = new ArrayList(LIST.length);
        Collections.addAll(arrayList, LIST);
        return arrayList.iterator();
    }
}

