/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import ru.rutoken.tools.Log;

public class Arrays {
    public static final int KILO = 1024;
    public static final byte[] ZERO_BYTES_32 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final int[] ZERO_INTS_8 = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    public static final int SEED = (int)(System.currentTimeMillis() >> 32);
    public static final int DEFAULT_BUFFER_SIZE = 4096;

    private Arrays() {
    }

    public static boolean equals(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        if (byArray2.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        if (nArray2.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        if (n + n3 <= byArray.length && n2 + n3 <= byArray2.length) {
            for (int i = 0; i < n3; ++i) {
                if (byArray[n + i] == byArray2[n2 + i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(int[] nArray, int n, int[] nArray2, int n2, int n3) {
        if (n + n3 <= nArray.length && n2 + n3 <= nArray2.length) {
            for (int i = 0; i < n3; ++i) {
                if (nArray[n + i] == nArray2[n2 + i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean eq(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        if (byArray2.length != n) {
            Log.debug("ERROR: a.length=" + n + "  !=  b.length=" + byArray2.length);
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            Log.debug("ERROR: i=" + i + ",  a[i]=" + byArray[i] + "  !=  b[i]=" + byArray2[i]);
            return false;
        }
        return true;
    }

    public static boolean eq(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        if (nArray2.length != n) {
            Log.debug("ERROR: a.length=" + n + "  !=  b.length=" + nArray2.length);
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            Log.debug("ERROR: i=" + i + ",  a[i]=" + nArray[i] + "  !=  b[i]=" + nArray2[i]);
            return false;
        }
        return true;
    }

    public static boolean eq(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        if (n + n3 <= byArray.length && n2 + n3 <= byArray2.length) {
            for (int i = 0; i < n3; ++i) {
                if (byArray[n + i] == byArray2[n2 + i]) continue;
                Log.debug("ERROR: i=" + i + ",  a[" + n + i + "]=" + byArray[n + i] + "  !=  b[" + n2 + i + "]=" + byArray2[n2 + i]);
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean eq(int[] nArray, int n, int[] nArray2, int n2, int n3) {
        if (n + n3 <= nArray.length && n2 + n3 <= nArray2.length) {
            for (int i = 0; i < n3; ++i) {
                if (nArray[n + i] == nArray2[n2 + i]) continue;
                Log.debug("ERROR: i=" + i + ",  a[" + n + i + "]=" + nArray[n + i] + "  !=  b[" + n2 + i + "]=" + nArray2[n2 + i]);
                return false;
            }
            return true;
        }
        return false;
    }

    public static byte[] clean(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 0;
        }
        return byArray;
    }

    public static int[] clean(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = 0;
        }
        return nArray;
    }

    public static char[] clean(char[] cArray) {
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = '\u0000';
        }
        return cArray;
    }

    public static boolean isZero(byte[] byArray) {
        for (byte by : byArray) {
            if (by == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isZero(int[] nArray) {
        for (int n : nArray) {
            if (n == 0) continue;
            return false;
        }
        return true;
    }

    public static byte[] fillRandom(byte[] byArray) {
        return Arrays.fillRandom(byArray, SEED);
    }

    public static byte[] fillRandom(byte[] byArray, int n) {
        int n2 = n;
        for (int i = 0; i < byArray.length; ++i) {
            n2 = n2 * 214013 + 2531011;
            byArray[i] = (byte)(n2 >> 16);
        }
        return byArray;
    }

    public static byte[] clone(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    public static int[] clone(int[] nArray, int n, int n2) {
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, n, nArray2, 0, n2);
        return nArray2;
    }

    public static int getInt(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
    }

    public static long getLong(byte[] byArray, int n) {
        return (long)(byArray[n] & 0xFF) | (long)(byArray[n + 1] & 0xFF) << 8 | (long)(byArray[n + 2] & 0xFF) << 16 | (long)(byArray[n + 3] & 0xFF) << 24 | (long)(byArray[n + 4] & 0xFF) << 32 | (long)(byArray[n + 5] & 0xFF) << 40 | (long)(byArray[n + 6] & 0xFF) << 48 | (long)(byArray[n + 7] & 0xFF) << 56;
    }

    public static int[] getInts(byte[] byArray) {
        int n = byArray.length >>> 2;
        int[] nArray = new int[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            nArray[n3] = Arrays.getInt(byArray, n2);
            ++n3;
            n2 += 4;
        }
        return nArray;
    }

    public static int[] getInts(byte[] byArray, int n, int n2) {
        int n3 = n2 >>> 2;
        int[] nArray = new int[n3];
        int n4 = 0;
        while (n4 < n3) {
            nArray[n4] = Arrays.getInt(byArray, n);
            ++n4;
            n += 4;
        }
        return nArray;
    }

    public static int[] getInts(byte[] byArray, int n, int n2, int[] nArray, int n3) {
        int n4 = n2 >>> 2;
        int n5 = 0;
        while (n5 < n4) {
            nArray[n3 + n5] = Arrays.getInt(byArray, n);
            ++n5;
            n += 4;
        }
        return nArray;
    }

    public static int[] getInts(byte[] byArray, int[] nArray) {
        int n = byArray.length >>> 2;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            nArray[n3] = Arrays.getInt(byArray, n2);
            ++n3;
            n2 += 4;
        }
        return nArray;
    }

    public static byte[] getBytes(int n, byte[] byArray, int n2) {
        byArray[n2 + 3] = (byte)(n >> 24);
        byArray[n2 + 2] = (byte)(n >> 16);
        byArray[n2 + 1] = (byte)(n >> 8);
        byArray[n2] = (byte)n;
        return byArray;
    }

    public static byte[] getBytes(long l, byte[] byArray, int n) {
        byArray[n + 7] = (byte)(l >> 56);
        byArray[n + 6] = (byte)(l >> 48);
        byArray[n + 5] = (byte)(l >> 40);
        byArray[n + 4] = (byte)(l >> 32);
        byArray[n + 3] = (byte)(l >> 24);
        byArray[n + 2] = (byte)(l >> 16);
        byArray[n + 1] = (byte)(l >> 8);
        byArray[n] = (byte)l;
        return byArray;
    }

    public static byte[] getBytes(int[] nArray) {
        int n = nArray.length;
        byte[] byArray = new byte[n << 2];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            Arrays.getBytes(nArray[n3], byArray, n2);
            ++n3;
            n2 += 4;
        }
        return byArray;
    }

    public static byte[] getBytes(int[] nArray, int n, int n2) {
        byte[] byArray = new byte[n2 << 2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            Arrays.getBytes(nArray[n], byArray, n3);
            ++n4;
            n3 += 4;
            ++n;
        }
        return byArray;
    }

    public static byte[] getBytes(int[] nArray, int n, int n2, byte[] byArray, int n3) {
        int n4 = 0;
        while (n4 < n2) {
            Arrays.getBytes(nArray[n], byArray, n3);
            ++n4;
            n3 += 4;
            ++n;
        }
        return byArray;
    }

    public static byte[] invert(byte[] byArray) {
        for (int i = 0; i < byArray.length >> 1; ++i) {
            byte by = byArray[i];
            byArray[i] = byArray[byArray.length - 1 - i];
            byArray[byArray.length - 1 - i] = by;
        }
        return byArray;
    }

    public static int[] invert(int[] nArray) {
        for (int i = 0; i < nArray.length >> 1; ++i) {
            int n = nArray[i];
            nArray[i] = nArray[nArray.length - 1 - i];
            nArray[nArray.length - 1 - i] = n;
        }
        return nArray;
    }

    public static byte[] getInverted(byte[] byArray) {
        int n = byArray.length;
        byte[] byArray2 = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray2[n - 1 - i] = byArray[i];
        }
        return byArray2;
    }

    public static int[] getInverted(int[] nArray) {
        int n = nArray.length;
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray2[n - 1 - i] = nArray[i];
        }
        return nArray2;
    }

    public static byte[] getInverted(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            byArray2[n2 - 1 - i] = byArray[n + i];
        }
        return byArray2;
    }

    public static int[] getInverted(int[] nArray, int n, int n2) {
        int[] nArray2 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray2[n2 - 1 - i] = nArray[n + i];
        }
        return nArray2;
    }

    public static byte[] read(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        do {
            n3 = inputStream.read(byArray, n, n2 - n);
            n += n3;
        } while (n3 > 0);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile(File file, byte[] byArray, int n, int n2) throws IOException {
        if (file.length() < (long)n2) {
            throw new IllegalArgumentException();
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            Arrays.read(fileInputStream, byArray, n, n2);
        }
        finally {
            fileInputStream.close();
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile(File file) throws IOException {
        int n = (int)file.length();
        byte[] byArray = new byte[n];
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            Arrays.read(fileInputStream, byArray, 0, n);
        }
        finally {
            fileInputStream.close();
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File file, byte[] byArray, int n, int n2) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            fileOutputStream.write(byArray, n, n2);
            fileOutputStream.flush();
        }
        finally {
            fileOutputStream.close();
        }
    }

    public static void writeFile(File file, byte[] byArray) throws IOException {
        Arrays.writeFile(file, byArray, 0, byArray.length);
    }

    public static int getTempArraySize(int n) {
        return 4096 <= n ? 4096 : n;
    }
}

