/*
 * Decompiled with CFR 0.152.
 */
package ru.rutoken.tools;

public class Hex {
    public static final char SEPARATOR = ' ';
    public static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final char[] FIRST_HEX = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'D', 'D', 'D', 'D', 'D', 'D', 'D', 'D', 'D', 'D', 'D', 'D', 'D', 'D', 'D', 'D', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'F', 'F', 'F', 'F', 'F', 'F', 'F', 'F', 'F', 'F', 'F', 'F', 'F', 'F', 'F', 'F'};
    public static final char[] SECOND_HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static void toHexString(byte[] byArray, int n, int n2, char[] cArray, int n3) {
        if (cArray.length < n3 + n2 * 3 - 1) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < n2; ++i) {
            cArray[n3++] = FIRST_HEX[byArray[i + n] & 0xFF];
            cArray[n3++] = SECOND_HEX[byArray[i + n] & 0xFF];
            if (i >= n2 - 1) continue;
            cArray[n3++] = 32;
        }
    }

    public static String toHexString(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2 * 3 - 1];
        Hex.toHexString(byArray, n, n2, cArray, 0);
        return new String(cArray);
    }

    public static String toHexString(byte[] byArray) {
        char[] cArray = new char[byArray.length * 3 - 1];
        Hex.toHexString(byArray, 0, byArray.length, cArray, 0);
        return new String(cArray);
    }

    public static void toHexString(int[] nArray, int n, int n2, char[] cArray, int n3) {
        if (cArray.length < n3 + n2 * 9 - 1) {
            throw new IllegalArgumentException();
        }
        int n4 = 0;
        while (n4 < n2) {
            for (int i = 0; i < 8; ++i) {
                cArray[n3 + i] = DIGITS[nArray[n4 + n] >>> 28 - i * 4 & 0xF];
            }
            if (n4 < n2 - 1) {
                cArray[n3 + 8] = 32;
            }
            ++n4;
            n3 += 9;
        }
    }

    public static String toHexString(int[] nArray, int n, int n2) {
        char[] cArray = new char[n2 * 9 - 1];
        Hex.toHexString(nArray, n, n2, cArray, 0);
        return new String(cArray);
    }

    public static String toHexString(int[] nArray) {
        char[] cArray = new char[nArray.length * 9 - 1];
        Hex.toHexString(nArray, 0, nArray.length, cArray, 0);
        return new String(cArray);
    }

    public static int parseDigit(char c) {
        int n = -1;
        if (c >= '0' && c <= '9') {
            n = c - 48;
        } else if (c >= 'a' && c <= 'f') {
            n = c + 10 - 97;
        } else if (c >= 'A' && c <= 'F') {
            n = c + 10 - 65;
        }
        return n;
    }

    public static byte parseByte(char[] cArray, int n) {
        int n2 = Hex.parseDigit(cArray[n]);
        if (n2 == -1) {
            throw new IllegalArgumentException();
        }
        int n3 = Hex.parseDigit(cArray[n + 1]);
        if (n3 == -1) {
            throw new IllegalArgumentException();
        }
        return (byte)((n2 << 4) + n3);
    }

    public static int parseInt(char[] cArray, int n) {
        int n2 = 0;
        for (int i = 0; i < 8; ++i) {
            int n3 = Hex.parseDigit(cArray[n + i]);
            if (n3 == -1) {
                throw new IllegalArgumentException();
            }
            n2 = (n2 << 4) + n3;
        }
        return n2;
    }

    public static byte[] fromHexString(String string) {
        char[] cArray = string.toCharArray();
        int n = (cArray.length + 2) / 3;
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            byArray[n3] = Hex.parseByte(cArray, n2);
            ++n3;
            n2 += 3;
        }
        return byArray;
    }

    public static int[] fromHexStringInts(String string) {
        char[] cArray = string.toCharArray();
        int n = (cArray.length + 2) / 9;
        int[] nArray = new int[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            nArray[n3] = Hex.parseInt(cArray, n2);
            ++n3;
            n2 += 9;
        }
        return nArray;
    }

    public static String getCodeBytes(byte[] byArray, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = new char[2];
        while (n2 > 0) {
            int n3 = n2 < 8 ? n2 : 8;
            for (int i = 0; i < n3; ++i) {
                stringBuilder.append("(byte) 0x");
                cArray[0] = FIRST_HEX[byArray[n] & 0xFF];
                cArray[1] = SECOND_HEX[byArray[n++] & 0xFF];
                stringBuilder.append(cArray);
                stringBuilder.append(", ");
            }
            stringBuilder.append("\n");
            n2 -= n3;
        }
        return new String(stringBuilder);
    }

    public static String getCodeBytes(byte[] byArray) {
        return Hex.getCodeBytes(byArray, 0, byArray.length);
    }

    public static void printCodeBytes(byte[] byArray, String string) {
        System.out.println("public static final byte[] " + string + " = {");
        System.out.print(Hex.getCodeBytes(byArray));
        System.out.println("};");
    }

    public static String getCodeInts(int[] nArray, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = new char[8];
        while (n2 > 0) {
            int n3 = n2 < 4 ? n2 : 4;
            for (int i = 0; i < n3; ++i) {
                stringBuilder.append("0x");
                for (int j = 0; j < 8; ++j) {
                    cArray[j] = DIGITS[nArray[n] >>> 28 - j * 4 & 0xF];
                }
                ++n;
                stringBuilder.append(cArray);
                stringBuilder.append(", ");
            }
            stringBuilder.append("\n");
            n2 -= n3;
        }
        return new String(stringBuilder);
    }

    public static String getCodeInts(int[] nArray) {
        return Hex.getCodeInts(nArray, 0, nArray.length);
    }

    public static String toHex(byte[] byArray) {
        return Hex.toHex(byArray, 0, byArray.length);
    }

    public static String toHex(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2 << 1];
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            cArray[n4] = FIRST_HEX[byArray[n + n3] & 0xFF];
            cArray[n4 + 1] = SECOND_HEX[byArray[n + n3] & 0xFF];
            ++n3;
            n4 += 2;
        }
        return new String(cArray);
    }

    public static void printHex(byte[] byArray, String string) {
        System.out.println("public static final String " + string + " = ");
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = n - n2 <= 32 ? n - n2 : 32;
            String string2 = Hex.toHex(byArray, n2, n3);
            System.out.print("\"" + string2 + "\"");
            if ((n2 += n3) == n) {
                System.out.println(";");
                continue;
            }
            System.out.println(" +");
        }
    }

    public static byte[] fromHex(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length >> 1;
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            byArray[n2] = Hex.parseByte(cArray, n3);
            ++n2;
            n3 += 2;
        }
        return byArray;
    }
}

