/************************************************************************
* Rutoken                                                               *
* Copyright (C) Aktiv Co. 2003 - 2014                                   *
*  :  http://www.rutoken.ru                          *
*  :    http://www.rutoken.ru/hotline/download/drivers/*
*  : http://www.rutoken.ru/hotline/                 *
*-----------------------------------------------------------------------*
*               *
*     Rutoken    Cert2Cont:          * 
*  -    ;                          * 
*  -     .                     *
************************************************************************/

    
#include "stdafx.h"
#include "CSPs.h"
#include "Cert2Cont.h"
#include "Util_Funcs.h"


/************************************************************************
*                                    *
************************************************************************/
bool EnumCSPs( OUT LPTSTR lpszCSPs[],
               OUT DWORD  pdwCSPsTypes[],
               OUT DWORD& dwCSPsCount )
{
    bool   bResult          = true;          //       

    DWORD  dwIndex          = 0;             //  
    DWORD  dwError          = ERROR_SUCCESS; //      
        
    LPTSTR lpszCurCSP       = NULL;          //       
    DWORD  dwCurCSPNameLen  = 0;             //     
    DWORD  dwCurCSPType     = 0;             //  


    for (  dwIndex = 0;
           dwIndex < C2C_MAX_ENUM_COUNT;
           dwIndex++ )
    {
        /************************************************************************
        *                                     *
        * (   )                                        * 
        ************************************************************************/
        bResult = (    CryptEnumProviders(dwIndex,
                                          NULL,
                                          0,
                                          &dwCurCSPType,
                                          NULL,
                                          &dwCurCSPNameLen )
                    != FALSE );
        if (!bResult)
        {
            dwError = GetLastError();
            if (dwError == ERROR_NO_MORE_ITEMS)
            {
                bResult = true;
                break;
            }
            else
            {
                PrintErrorText(TEXT("CryptEnumProviders"),
                               dwError );
                break;
            }
        }

        lpszCurCSP = (LPTSTR)LocalAlloc(LMEM_ZEROINIT, dwCurCSPNameLen);


        /************************************************************************
        *                     *
        ************************************************************************/
        bResult = (    CryptEnumProviders( dwIndex,
                                           NULL,
                                           0,
                                           &dwCurCSPType,
                                           lpszCurCSP,
                                           &dwCurCSPNameLen)
                    != FALSE );
        if (!bResult)
        {
            dwError = GetLastError();
            if (dwError == ERROR_NO_MORE_ITEMS)
            {
                bResult = true;
                break;
            }
            else
            {
                PrintErrorText(TEXT("CryptEnumProviders"),
                               dwError);
                break;
            }
        }

        /************************************************************************
        *                            *
        *                                             * 
        ************************************************************************/
        dwCSPsCount = dwIndex + 1;
        lpszCSPs[dwIndex] = lpszCurCSP;
        pdwCSPsTypes[dwIndex] = dwCurCSPType;
    }

    return bResult;
}

/************************************************************************
*        ,  * 
*                * 
* ,                              *
************************************************************************/
DWORD SelectCSP( IN LPCTSTR lpszPreferredCSP,
                 IN LPTSTR  lpszCSPs[],
                 IN DWORD*  pdwCSPsTypes,
                 IN DWORD   dwCSPsCount )
{
    DWORD dwSelectedCSP  = C2C_BAD_SELECT;  //  .     
    DWORD dwIndex        = 0;               //  

    if (lpszPreferredCSP)
    {
        /************************************************************************
        *        ,    *
        *   :                                         *
        *  -   ,  ,   *
        *    ,    ;                 * 
        *  -    ,   ,               *
        *      .                                      *
        ************************************************************************/
        for (   dwIndex = 0;
                dwIndex < dwCSPsCount;
                dwIndex++ )
        {
            if (::memcmp(lpszPreferredCSP,
                         lpszCSPs[dwIndex],
                         ((_tcsclen(lpszPreferredCSP) + 1) * sizeof(TCHAR)) )
                == 0)
            {
                dwSelectedCSP = dwIndex;
                break;
            }
        }
    }
    else
    {
        /************************************************************************
        *         , *
        *   :                                         *
        *  -     ;         *
        *  -     ,                   * 
        *         .                   *
        ************************************************************************/
        _tprintf(TEXT("Select CSP:\n"));
        for (   dwIndex = 0;
                dwIndex < dwCSPsCount;
                dwIndex++ )
            _tprintf(TEXT("[%d] - %s\n"), dwIndex, lpszCSPs[dwIndex]);

        if (    (_tscanf(TEXT("%d"), &dwSelectedCSP) != 1)
            ||  ((dwSelectedCSP + 1) > dwCSPsCount) )
        {
            _tprintf(TEXT("Input error.\n"));
            dwSelectedCSP = C2C_BAD_SELECT;
            return dwSelectedCSP;
        }
    }

    if (dwSelectedCSP == C2C_BAD_SELECT)
        _tprintf(TEXT("Error: no such CSP in the system.\n"));
    else
    {
        _tprintf(TEXT("Selected CSP: \"%s\".\n"), lpszCSPs[dwSelectedCSP]);
        _tprintf(TEXT("CSP type is %X.\n"), pdwCSPsTypes[dwSelectedCSP]);
    }

    return dwSelectedCSP;
}
