/************************************************************************
* Rutoken                                                               *
* Copyright (C) Aktiv Co. 2003 - 2014                                   *
*  :  http://www.rutoken.ru                          *
*  :    http://www.rutoken.ru/hotline/download/drivers/*
*  : http://www.rutoken.ru/hotline/                 *
*-----------------------------------------------------------------------*
*    :                                       *
*  -    ;                                *
*  -    ;                                 *
*  -   ;                                      *
*  -     .                          *
************************************************************************/

/************************************************************************
*   stdafx.h.                                             *
*  stdafx.h  **  Cert2Cont            *      
*    /   Win32 API.   *
*-----------------------------------------------------------------------*
*   Cert2Cont.h.                                          *
*  Cert2Cont.h  **  Cert2Cont   :     *
*  - ;                                                        * 
*  -    .                                    *
*-----------------------------------------------------------------------*
*   CSPs.h.                                               *
*  CSPs.h  **  Cert2Cont              *
*     .              *
*-----------------------------------------------------------------------*
*   Containers.h.                                         *
*  Containers.h  **  Cert2Cont        *
*   :                                   *
*  -  ;                                              *
*  -     .                         *
*-----------------------------------------------------------------------*
*   Util_Funcs.h.                                         *
*  Util_Funcs.h  **  Cert2Cont        *
*   :                                   *
*  -     ;                               *
*  -      ;                  *
*  -   .                              *
*-----------------------------------------------------------------------*
*   Import.h.                                             *
*  Import.h  **  Cert2Cont            *
*       .         *
************************************************************************/
    

#include "stdafx.h"
#include "Cert2Cont.h"
#include "CSPs.h"
#include "Containers.h"
#include "Util_Funcs.h"
#include "Import.h"


/************************************************************************
* main()                                                                *
************************************************************************/
int _tmain( int argc, _TCHAR* argv[])
{
    bool   bResult                             = true;          //       
    DWORD  dwError                             = ERROR_SUCCESS; //      
    DWORD  dwIndex                             = 0;             //   

    LPTSTR lpszCSPName                         = NULL;          //      
    LPTSTR lpszContainerName                   = NULL;          //      
    DWORD  dwKeySpec                           = 0;             //   

    LPTSTR lpszCertFileName                    = NULL;          //      
    bool   bPrintHelpAndExit                   = false;         //  true,      

    LPTSTR lpszCSPs[C2C_MAX_ENUM_COUNT];                        //                          
    DWORD  pdwCSPsTypes[C2C_MAX_ENUM_COUNT];                    //     
    DWORD  dwCSPsCount                         = 0;             //                          
    DWORD  dwSelectedCSP                       = 0;             //                           

    BYTE*  pbtContainers[C2C_MAX_ENUM_COUNT];                   //                          
    DWORD  dwContainersCount                   = 0;             //      
    DWORD  dwSelectedContainer                 = 0;             //       

    LPVOID lpvCertBuffer                       = NULL;          //     
    DWORD  dwCertBufferSize                    = 0;             //        
    
    
    ::ZeroMemory( lpszCSPs,
                  (sizeof(LPTSTR) * C2C_MAX_ENUM_COUNT));
    
    ::ZeroMemory( pdwCSPsTypes,
                  (sizeof(DWORD) * C2C_MAX_ENUM_COUNT));

    ::ZeroMemory( pbtContainers,
                  (sizeof(BYTE*) * C2C_MAX_ENUM_COUNT));    
    
    /**********************************************************************
    *  1:  .                                     *
    **********************************************************************/
    PrintWelcomeInformation();
    
    /**********************************************************************
    *  2:  ,    .   *
    **********************************************************************/
    bResult = ParseCommandLine( argc,
                                argv,
                                lpszCSPName,
                                lpszContainerName,
                                dwKeySpec,
                                lpszCertFileName,
                                bPrintHelpAndExit );
    if (   !bResult
        || bPrintHelpAndExit )
    {
        FreeCommandLineParameters(  lpszCSPName,
                                    lpszContainerName,
                                    dwKeySpec,
                                    lpszCertFileName );
        if (!bResult)
        {
            _tprintf(TEXT("Error occurred.\nPress Enter to exit."));
            _gettch();
        }
        else
        {
            _tprintf(TEXT("Press Enter to exit.\n"));
            _gettch();
        }
        return 0;
    }

    /**********************************************************************
    *  3:    .                      *
    **********************************************************************/    
    bResult = EnumCSPs( lpszCSPs,
                        pdwCSPsTypes,
                        dwCSPsCount );
    if (!bResult)
    {
        FreeCommandLineParameters(  lpszCSPName,
                                    lpszContainerName,
                                    dwKeySpec,
                                    lpszCertFileName );

        FreePointersList( (LPVOID*)&lpszCSPs,
                          dwCSPsCount );

        _tprintf(TEXT("Error occurred.\nPress Enter to exit."));
        _gettch();
        return 0;
    }

    /************************************************************************
    *  4:                     *
    *        .                                             *
    ************************************************************************/
    dwSelectedCSP = SelectCSP(  lpszCSPName,
                                lpszCSPs,
                                pdwCSPsTypes,
                                dwCSPsCount );
    bResult = (dwSelectedCSP != C2C_BAD_SELECT);
    if (!bResult)
    {
        FreeCommandLineParameters( lpszCSPName,
                                   lpszContainerName,
                                   dwKeySpec,
                                   lpszCertFileName );

        FreePointersList( (LPVOID*)&lpszCSPs,
                          dwCSPsCount );

        _tprintf(TEXT("Error occurred.\nPress Enter to exit."));
        _gettch();
        return 0;
    }

    /**********************************************************************
    *  5:    .                            *
    **********************************************************************/    
    bResult = EnumContainers( lpszCSPs,
                              pdwCSPsTypes,
                              dwSelectedCSP,
                              pbtContainers,
                              dwContainersCount );
    if (!bResult)
    {
        FreeCommandLineParameters( lpszCSPName,
                                   lpszContainerName,
                                   dwKeySpec,
                                   lpszCertFileName );

        FreePointersList( (LPVOID*)&lpszCSPs,
                          dwCSPsCount );

        FreePointersList( (LPVOID*)&pbtContainers,
                          dwContainersCount );

        _tprintf(TEXT("Error occurred.\nPress Enter to exit."));
        _gettch();
        return 0;
    }

    /************************************************************************
    *  6:                     *
    *        .                                                   *
    ************************************************************************/
    dwSelectedContainer = SelectContainer(  lpszContainerName,
                                            pbtContainers,
                                            dwContainersCount );
    bResult = (dwSelectedContainer != C2C_BAD_SELECT);
    if (!bResult)
    {
        FreeCommandLineParameters(  lpszCSPName,
                                    lpszContainerName,
                                    dwKeySpec,
                                    lpszCertFileName );

        FreePointersList( (LPVOID*)&lpszCSPs,
                          dwCSPsCount );

        FreePointersList( (LPVOID*)&pbtContainers,
                          dwContainersCount );

        _tprintf(TEXT("Error occurred.\nPress Enter to exit."));
        _gettch();
        return 0;
    }

    /************************************************************************
    *  7:    .                                   *
    ************************************************************************/
    bResult = ReadCertificateFromFile(  lpszCertFileName,
                                        lpvCertBuffer,
                                        dwCertBufferSize );
    if (!bResult)
    {
        FreePointersList((LPVOID*)&lpszCSPs,
                         dwCSPsCount );

        FreePointersList((LPVOID*)&pbtContainers,
                         dwContainersCount );

        FreeBuffer(&lpvCertBuffer);
        _tprintf(TEXT("Error occurred.\nPress Enter to exit."));
        _gettch();
        return 0;
    }

    /************************************************************************
    *  8:     .                *
    ************************************************************************/
    bResult = ImportCertificateToContainer( lpszCSPs,
                                            pdwCSPsTypes,
                                            dwSelectedCSP,
                                            pbtContainers,
                                            dwSelectedContainer,
                                            dwKeySpec,
                                            lpvCertBuffer,
                                            dwCertBufferSize );

    FreePointersList((LPVOID*)&lpszCSPs,
                     dwCSPsCount );

    FreePointersList((LPVOID*)&pbtContainers,
                     dwSelectedContainer );

    FreeBuffer(&lpvCertBuffer);

    if (bResult)
        _tprintf(TEXT("Success.\nPress Enter to exit.\n"));
    else
        _tprintf(TEXT("Error occurred.\nPress Enter to exit.\n"));
    _gettch();
    return 0;
}
